<?php
/**
 * SVG Icons
 *
 * @package Atlas
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/*
--------------------------------------------------------------------------------
* SVG Icons
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_get_svg_icon' ) ) {

	function th90_get_svg_icon( $icon = '', $class = '' ) {
        switch ( $icon ) {
			case 'menu':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18"><path fill="currentColor" d="M4 1h1s3 0 3 3v1s0 3-3 3H4S1 8 1 5V4s0-3 3-3m0 10h1s3 0 3 3v1s0 3-3 3H4s-3 0-3-3v-1s0-3 3-3M14 1h1s3 0 3 3v1s0 3-3 3h-1s-3 0-3-3V4s0-3 3-3m0 10h1s3 0 3 3v1s0 3-3 3h-1s-3 0-3-3v-1s0-3 3-3"/></svg>';
                break;
			case 'menu2':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18"><path fill="currentColor" d="M6 3h9v3H3V3h3m-3 9h12v3H3Z"/></svg>';
                break;
			case 'menu3':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18"><path fill="currentColor" d="M2 1h3s1 0 1 1v3s0 1-1 1H2S1 6 1 5V2s0-1 1-1m0 10h3s1 0 1 1v3s0 1-1 1H2s-1 0-1-1v-3s0-1 1-1M12 1h3s1 0 1 1v3s0 1-1 1h-3s-1 0-1-1V2s0-1 1-1m0 10h3s1 0 1 1v3s0 1-1 1h-3s-1 0-1-1v-3s0-1 1-1"/></svg>';
                break;
			case 'menu4':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18"><path fill="currentColor" d="M4 1h11s3 0 3 3 0 3-3 3H4S1 7 1 4s0-3 3-3m0 10h3s3 0 3 3 0 3-3 3H4s-3 0-3-3 0-3 3-3"/></svg>';
                break;
			case 'quote':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" d="M17 11a4 4 0 1 1 4-4c0 1.473-1.333 6.14-4 14h-2l2-10ZM7 11a4 4 0 1 1 4-4c0 1.473-1.333 6.14-4 14H5l2-10Z"/></svg>';
                break;
			case 'video':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="32" d="M112 111v290c0 17.44 17 28.52 31 20.16l247.9-148.37c12.12-7.25 12.12-26.33 0-33.58L143 90.84c-14-8.36-31 2.72-31 20.16z"/></svg>';
                break;

            case 'audio':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M20 3v14a4 4 0 1 1-2-3.465V5H9v12a4 4 0 1 1-2-3.465V3h13ZM5 19a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm11 0a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"/></svg>';
                break;

            case 'gallery':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M11.27 12.216 15 6l8 15H2L9 8l2.27 4.216Zm1.12 2.022L14.987 19h4.68l-4.77-8.942-2.507 4.18ZM5.348 19h7.304L9 12.219 5.348 19ZM5.5 8a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"/></svg>';
                break;

			case 'search':
            	$out = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-width="3" style="fill:none" viewBox="0 0 24 24"><path d="M2.778 11.767a8.989 8.989 0 1 0 17.978 0 8.989 8.989 0 1 0-17.978 0m15.24 6.718L21.542 22"/></svg>';
				break;

			case 'arrow_up_long':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l73.4-73.4V480c0 17.7 14.3 32 32 32s32-14.3 32-32V109.3l73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"/></svg>';
                break;

			case 'hot':
				$out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M159.3 5.4c7.8-7.3 19.9-7.2 27.7.1 27.6 25.9 53.5 53.8 77.7 84 11-14.4 23.5-30.1 37-42.9 7.9-7.4 20.1-7.4 28 .1 34.6 33 63.9 76.6 84.5 118 20.3 40.8 33.8 82.5 33.8 111.9C448 404.2 348.2 512 224 512 98.4 512 0 404.1 0 276.5c0-38.4 17.8-85.3 45.4-131.7C73.3 97.7 112.7 48.6 159.3 5.4zM225.7 416c25.3 0 47.7-7 68.8-21 42.1-29.4 53.4-88.2 28.1-134.4-4.5-9-16-9.6-22.5-2l-25.2 29.3c-6.6 7.6-18.5 7.4-24.7-.5-16.5-21-46-58.5-62.8-79.8-6.3-8-18.3-8.1-24.7-.1-33.8 42.5-50.8 69.3-50.8 99.4.1 68.5 50.7 109.1 113.8 109.1z"/></svg>';
				break;

			case 'moon':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M223.5 32C100 32 0 132.3 0 256s100 224 223.5 224c60.6 0 115.5-24.2 155.8-63.4 5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-9.8 1.7-19.8 2.6-30.1 2.6-96.9 0-175.5-78.8-175.5-176 0-65.8 36-123.1 89.3-153.3 6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-6.3-.5-12.6-.8-19-.8z"/></svg>';
                break;
            case 'sun':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 18a6 6 0 1 1 0-12 6 6 0 0 1 0 12ZM11 1h2v3h-2V1Zm0 19h2v3h-2v-3ZM3.515 4.929l1.414-1.414L7.05 5.636 5.636 7.05 3.515 4.93ZM16.95 18.364l1.414-1.414 2.121 2.121-1.414 1.414-2.121-2.121Zm2.121-14.85 1.414 1.415-2.121 2.121-1.414-1.414 2.121-2.121ZM5.636 16.95l1.414 1.414-2.121 2.121-1.414-1.414 2.121-2.121ZM23 11v2h-3v-2h3ZM4 11v2H1v-2h3Z"/></svg>';
                break;
			case 'cart':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M2.123 4.25h2.166a.25.25 0 0 1 .246.205l1.701 9.358a1.75 1.75 0 0 0 1.722 1.437h11.363c.82 0 1.531-.57 1.708-1.37l1.556-7a1.75 1.75 0 0 0-1.708-2.13H9.123a.75.75 0 0 0 0 1.5h11.754a.251.251 0 0 1 .244.304l-1.556 7a.25.25 0 0 1-.244.196H7.958a.25.25 0 0 1-.246-.205L6.011 4.187A1.752 1.752 0 0 0 4.289 2.75H2.123a.75.75 0 0 0 0 1.5zm16 11.5a2.75 2.75 0 1 0 0 5.5 2.75 2.75 0 1 0 0-5.5zm-8.5 0a2.75 2.75 0 1 0 0 5.5 2.75 2.75 0 1 0 0-5.5z"/></svg>';
                break;

			case 'error':
				$out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64"><path d="M30 60h3.75v-.019C48.843 59.581 61 47.188 61 32 61 16.561 48.439 4 33 4c-.042 0-.083.003-.125.003V4H30c-7.483 0-14.514 2.915-19.793 8.205C4.915 17.485 2 24.516 2 32s2.915 14.515 8.204 19.792C15.486 57.085 22.517 60 30 60zM41.602 9.6C50.598 13.067 57 21.797 57 32c0 13.234-10.767 24-24 24-1 0-1.984-.069-2.953-.188L41.51 9.97l.092-.37zM33 8c.333 0 .664.012.994.025l-.014.055-11.388 45.543C14.556 49.74 9 41.507 9 32 9 18.766 19.767 8 33 8z"/></svg>';
				break;
			case 'location':
				$out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="m384 476.1-192-54.9V35.9l192 54.9v385.3zm32-1.2V88.4l127.1-50.9c15.8-6.3 32.9 5.3 32.9 22.3v334.8c0 9.8-6 18.6-15.1 22.3L416 474.8zM15.1 95.1 160 37.2v386.4L32.9 474.5C17.1 480.8 0 469.2 0 452.2V117.4c0-9.8 6-18.6 15.1-22.3z"/></svg>';
				break;

			case 'phone':
				$out = '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z"/></svg>';
				break;

			case 'close':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m12 10.586 4.95-4.95 1.415 1.415-4.95 4.95 4.95 4.95-1.415 1.414-4.95-4.95-4.95 4.95-1.413-1.415 4.95-4.95-4.95-4.95L7.05 5.638l4.95 4.95Z"/></svg>';
                break;

			case 'pulse':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m9 7.539 6 14L18.66 13H23v-2h-5.66L15 16.461l-6-14L5.34 11H1v2h5.66L9 7.539Z"/></svg>';
                break;

            case 'star':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m12 18.26-7.053 3.948 1.575-7.928L.588 8.792l8.027-.952L12 .5l3.385 7.34 8.027.952-5.934 5.488 1.575 7.928L12 18.26Zm0-2.292 4.247 2.377-.948-4.773 3.573-3.305-4.833-.573-2.038-4.419-2.039 4.42-4.833.572 3.573 3.305-.948 4.773L12 15.968Z"/></svg>';
                break;

            case 'three-dots':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M4.5 10.5c-.825 0-1.5.675-1.5 1.5s.675 1.5 1.5 1.5S6 12.825 6 12s-.675-1.5-1.5-1.5Zm15 0c-.825 0-1.5.675-1.5 1.5s.675 1.5 1.5 1.5S21 12.825 21 12s-.675-1.5-1.5-1.5Zm-7.5 0c-.825 0-1.5.675-1.5 1.5s.675 1.5 1.5 1.5 1.5-.675 1.5-1.5-.675-1.5-1.5-1.5Z"/></svg>';
                break;

			case 'arrow-left':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10.8284 12.0007L15.7782 16.9504L14.364 18.3646L8 12.0007L14.364 5.63672L15.7782 7.05093L10.8284 12.0007Z"></path></svg>';
                break;

			case 'arrow-right':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m13.171 12-4.95-4.95 1.415-1.413L16 12l-6.364 6.364-1.414-1.415 4.95-4.95Z"/></svg>';
                break;

			case 'arrow-right-double':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="m19.164 12-6.207-6.207-1.414 1.414L16.336 12l-4.793 4.793 1.414 1.414L19.164 12Zm-5.65 0L7.307 5.793 5.893 7.207 10.686 12l-4.793 4.793 1.414 1.414L13.514 12Z"/></svg>';
                break;

			case 'arrow-left-double':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M4.83594 12.0001L11.043 18.2072L12.4573 16.793L7.66436 12.0001L12.4573 7.20718L11.043 5.79297L4.83594 12.0001ZM10.4858 12.0001L16.6929 18.2072L18.1072 16.793L13.3143 12.0001L18.1072 7.20718L16.6929 5.79297L10.4858 12.0001Z"></path></svg>';
                break;

			case 'flash':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M13 10H20L11 23V14H4L13 1V10Z"></path></svg>';
                break;

			case 'plus':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M11 11V5h2v6h6v2h-6v6h-2v-6H5v-2h6Z"/></svg>';
                break;

			case 'paper-plane':
				$out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128"><path d="M31.295 23.057A7.097 7.097 0 0 0 25.5 26.3c-1.5 2.3-1.4 5.2.1 7.5l8.7 13.398c.9 1.4 2.8 1.8 4.1.9 1.4-.9 1.8-2.799.9-4.099l-8.7-13.4c-.3-.5-.1-.9 0-1.1.1-.2.4-.5 1-.5l88.5 11c.5.1.7.4.8.7.1.3.2.6-.2 1L60 106.9c-.4.4-.8.3-1 .3-.2-.1-.6-.3-.7-.8l-2.6-20.5c-.1-.6-.1-1.3-.2-1.9-.4-9.6 5.4-18.3 14.5-21.6l19.4-7c1.6-.6 2.4-2.3 1.8-3.8-.6-1.6-2.3-2.4-3.8-1.8l-19.4 7c-12.4 4.5-19.9 16.8-18.3 29.9l2.6 20.5c.3 2.7 2.2 4.9 4.8 5.8.7.2 1.5.3 2.2.3 1.9 0 3.7-.8 5.1-2.2l60.7-65.2a7.04 7.04 0 0 0 1.5-7.2c-.9-2.5-3.1-4.2-5.7-4.6l-88.6-11a7.38 7.38 0 0 0-1.005-.043zm5.447 37.845a2.763 2.763 0 0 0-1.142.198l-18.8 6.8c-1.6.6-2.4 2.3-1.8 3.8.4 1.3 1.5 2 2.8 2 .3 0 .7-.1 1-.2l18.8-6.8c1.6-.6 2.4-2.3 1.8-3.8-.45-1.2-1.519-1.95-2.658-1.998zm4.7 13.202a2.754 2.754 0 0 0-1.141.197L8.4 85.9c-1.6.6-2.4 2.298-1.8 3.798.4 1.2 1.6 2 2.8 2 .3 0 .7-.099 1-.199l31.9-11.6c1.6-.6 2.4-2.3 1.8-3.8-.45-1.2-1.52-1.95-2.659-1.996z"/></svg>';
				break;

			/* Post Meta Icons */
			case 'person':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 17c3.663 0 6.866 1.575 8.608 3.925l-1.842.871C17.348 20.116 14.848 19 12.001 19c-2.848 0-5.347 1.116-6.765 2.796l-1.841-.872C5.137 18.574 8.339 17 12 17Zm0-15a5 5 0 0 1 5 5v3a5 5 0 0 1-4.782 4.995L12 15a5 5 0 0 1-5-5V7a5 5 0 0 1 4.783-4.995L12.001 2Zm0 2a3 3 0 0 0-2.994 2.824L9.001 7v3a3 3 0 0 0 5.995.176L15 10V7a3 3 0 0 0-3-3Z"/></svg>';
                break;

			case 'comment':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10 3h4a8 8 0 1 1 0 16v3.5c-5-2-12-5-12-11.5a8 8 0 0 1 8-8Zm2 14h2a6 6 0 0 0 0-12h-4a6 6 0 0 0-6 6c0 3.61 2.462 5.966 8 8.48V17Z"/></svg>';
                break;

			case 'date':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10Zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm1-8h4v2h-6V7h2v5Z"/></svg>';
                break;

			case 'view':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 3c5.392 0 9.878 3.88 10.819 9-.94 5.12-5.427 9-10.819 9-5.392 0-9.878-3.88-10.818-9C2.122 6.88 6.608 3 12 3Zm0 16a9.005 9.005 0 0 0 8.778-7 9.005 9.005 0 0 0-17.555 0A9.005 9.005 0 0 0 12 19Zm0-2.5a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9Zm0-2a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z"/></svg>';
                break;

            default:
                $out = '';
                break;
        }
        return '<span class="icon-svg' . $class . '">' . $out . '</span>';
    }
}


/*
--------------------------------------------------------------------------------
* Print SVG Icons
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_svg_icon' ) ) {

	function th90_svg_icon( $icon = '', $class = '' ) {
        echo do_shortcode( th90_get_svg_icon( $icon, $class ) );
    }
}

/*
--------------------------------------------------------------------------------
* Print Custom SVG Icons
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_svg_icon_custom' ) ) {

	function th90_svg_icon_custom( $icon = '' ) {
        echo '<span class="icon-svg">' . do_shortcode( $icon ) . '</span>';
    }
}

/*
--------------------------------------------------------------------------------
* SVG Icons Socials
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_get_svg_icon_socials' ) ) {

	function th90_get_svg_icon_social( $icon = '' ) {
        switch ( $icon ) {

			case '500px':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M103.3 344.3c-6.5-14.2-6.9-18.3 7.4-23.1 25.6-8 8 9.2 43.2 49.2h.3v-93.9c1.2-50.2 44-92.2 97.7-92.2 53.9 0 97.7 43.5 97.7 96.8 0 63.4-60.8 113.2-128.5 93.3-10.5-4.2-2.1-31.7 8.5-28.6 53 0 89.4-10.1 89.4-64.4 0-61-77.1-89.6-116.9-44.6-23.5 26.4-17.6 42.1-17.6 157.6 50.7 31 118.3 22 160.4-20.1 24.8-24.8 38.5-58 38.5-93 0-35.2-13.8-68.2-38.8-93.3-24.8-24.8-57.8-38.5-93.3-38.5s-68.8 13.8-93.5 38.5c-.3.3-16 16.5-21.2 23.9l-.5.6c-3.3 4.7-6.3 9.1-20.1 6.1-6.9-1.7-14.3-5.8-14.3-11.8V20c0-5 3.9-10.5 10.5-10.5h241.3c8.3 0 8.3 11.6 8.3 15.1 0 3.9 0 15.1-8.3 15.1H130.3v132.9h.3c104.2-109.8 282.8-36 282.8 108.9 0 178.1-244.8 220.3-310.1 62.8zm63.3-260.8c-.5 4.2 4.6 24.5 14.6 20.6C306 56.6 384 144.5 390.6 144.5c4.8 0 22.8-15.3 14.3-22.8-93.2-89-234.5-57-238.3-38.2zM393 414.7C283 524.6 94 475.5 61 310.5c0-12.2-30.4-7.4-28.9 3.3 24 173.4 246 256.9 381.6 121.3 6.9-7.8-12.6-28.4-20.7-20.4zM213.6 306.6c0 4 4.3 7.3 5.5 8.5 3 3 6.1 4.4 8.5 4.4 3.8 0 2.6.2 22.3-19.5 19.6 19.3 19.1 19.5 22.3 19.5 5.4 0 18.5-10.4 10.7-18.2L265.6 284l18.2-18.2c6.3-6.8-10.1-21.8-16.2-15.7L249.7 268c-18.6-18.8-18.4-19.5-21.5-19.5-5 0-18 11.7-12.4 17.3L234 284c-18.1 17.9-20.4 19.2-20.4 22.6z"/></svg>';
                break;

            case 'behance':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>';
                break;

            case 'deviantart':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M320 93.2l-98.2 179.1 7.4 9.5H320v127.7H159.1l-13.5 9.2-43.7 84c-.3 0-8.6 8.6-9.2 9.2H0v-93.2l93.2-179.4-7.4-9.2H0V102.5h156l13.5-9.2 43.7-84c.3 0 8.6-8.6 9.2-9.2H320v93.1z"/></svg>';
                break;

            case 'digg':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M81.7 172.3H0v174.4h132.7V96h-51v76.3zm0 133.4H50.9v-92.3h30.8v92.3zm297.2-133.4v174.4h81.8v28.5h-81.8V416H512V172.3H378.9zm81.8 133.4h-30.8v-92.3h30.8v92.3zm-235.6 41h82.1v28.5h-82.1V416h133.3V172.3H225.1v174.4zm51.2-133.3h30.8v92.3h-30.8v-92.3zM153.3 96h51.3v51h-51.3V96zm0 76.3h51.3v174.4h-51.3V172.3z"/></svg>';
                break;

            case 'dribbble':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>';
                break;

            case 'email':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M64 208.1L256 65.9 448 208.1v47.4L289.5 373c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64 255.5V208.1zM256 0c-12.1 0-23.8 3.9-33.5 11L25.9 156.7C9.6 168.8 0 187.8 0 208.1V448c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V208.1c0-20.3-9.6-39.4-25.9-51.4L289.5 11C279.8 3.9 268.1 0 256 0z"/></svg>';
                break;

            case 'facebook':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg>';
                break;

			case 'website':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M51.7 295.1l31.7 6.3c7.9 1.6 16-.9 21.7-6.6l15.4-15.4c11.6-11.6 31.1-8.4 38.4 6.2l9.3 18.5c4.8 9.6 14.6 15.7 25.4 15.7c15.2 0 26.1-14.6 21.7-29.2l-6-19.9c-4.6-15.4 6.9-30.9 23-30.9h2.3c13.4 0 25.9-6.7 33.3-17.8l10.7-16.1c5.6-8.5 5.3-19.6-.8-27.7l-16.1-21.5c-10.3-13.7-3.3-33.5 13.4-37.7l17-4.3c7.5-1.9 13.6-7.2 16.5-14.4l16.4-40.9C303.4 52.1 280.2 48 256 48C141.1 48 48 141.1 48 256c0 13.4 1.3 26.5 3.7 39.1zm407.7 4.6c-3-.3-6-.1-9 .8l-15.8 4.4c-6.7 1.9-13.8-.9-17.5-6.7l-2-3.1c-6-9.4-16.4-15.1-27.6-15.1s-21.6 5.7-27.6 15.1l-6.1 9.5c-1.4 2.2-3.4 4.1-5.7 5.3L312 330.1c-18.1 10.1-25.5 32.4-17 51.3l5.5 12.4c8.6 19.2 30.7 28.5 50.5 21.1l2.6-1c10-3.7 21.3-2.2 29.9 4.1l1.5 1.1c37.2-29.5 64.1-71.4 74.4-119.5zM512 256c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM144.5 348.1c-2.1 8.6 3.1 17.3 11.6 19.4l32 8c8.6 2.1 17.3-3.1 19.4-11.6s-3.1-17.3-11.6-19.4l-32-8c-8.6-2.1-17.3 3.1-19.4 11.6zm92-20c-2.1 8.6 3.1 17.3 11.6 19.4s17.3-3.1 19.4-11.6l8-32c2.1-8.6-3.1-17.3-11.6-19.4s-17.3 3.1-19.4 11.6l-8 32zM343.2 113.7c-7.9-4-17.5-.7-21.5 7.2l-16 32c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l16-32c4-7.9 .7-17.5-7.2-21.5z"/></svg>';
                break;

            case 'flickr':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z"/></svg>';
                break;

            case 'foursquare':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 368 512"><path d="M323.1 3H49.9C12.4 3 0 31.3 0 49.1v433.8c0 20.3 12.1 27.7 18.2 30.1 6.2 2.5 22.8 4.6 32.9-7.1C180 356.5 182.2 354 182.2 354c3.1-3.4 3.4-3.1 6.8-3.1h83.4c35.1 0 40.6-25.2 44.3-39.7l48.6-243C373.8 25.8 363.1 3 323.1 3zm-16.3 73.8l-11.4 59.7c-1.2 6.5-9.5 13.2-16.9 13.2H172.1c-12 0-20.6 8.3-20.6 20.3v13c0 12 8.6 20.6 20.6 20.6h90.4c8.3 0 16.6 9.2 14.8 18.2-1.8 8.9-10.5 53.8-11.4 58.8-.9 4.9-6.8 13.5-16.9 13.5h-73.5c-13.5 0-17.2 1.8-26.5 12.6 0 0-8.9 11.4-89.5 108.3-.9.9-1.8.6-1.8-.3V75.9c0-7.7 6.8-16.6 16.6-16.6h219c8.2 0 15.6 7.7 13.5 17.5z"/></svg>';
                break;

            case 'github':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 480 512"><path d="M186.1 328.7c0 20.9-10.9 55.1-36.7 55.1s-36.7-34.2-36.7-55.1 10.9-55.1 36.7-55.1 36.7 34.2 36.7 55.1zM480 278.2c0 31.9-3.2 65.7-17.5 95-37.9 76.6-142.1 74.8-216.7 74.8-75.8 0-186.2 2.7-225.6-74.8-14.6-29-20.2-63.1-20.2-95 0-41.9 13.9-81.5 41.5-113.6-5.2-15.8-7.7-32.4-7.7-48.8 0-21.5 4.9-32.3 14.6-51.8 45.3 0 74.3 9 108.8 36 29-6.9 58.8-10 88.7-10 27 0 54.2 2.9 80.4 9.2 34-26.7 63-35.2 107.8-35.2 9.8 19.5 14.6 30.3 14.6 51.8 0 16.4-2.6 32.7-7.7 48.2 27.5 32.4 39 72.3 39 114.2zm-64.3 50.5c0-43.9-26.7-82.6-73.5-82.6-18.9 0-37 3.4-56 6-14.9 2.3-29.8 3.2-45.1 3.2-15.2 0-30.1-.9-45.1-3.2-18.7-2.6-37-6-56-6-46.8 0-73.5 38.7-73.5 82.6 0 87.8 80.4 101.3 150.4 101.3h48.2c70.3 0 150.6-13.4 150.6-101.3zm-82.6-55.1c-25.8 0-36.7 34.2-36.7 55.1s10.9 55.1 36.7 55.1 36.7-34.2 36.7-55.1-10.9-55.1-36.7-55.1z"/></svg>';
                break;

            case 'goodreads':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M42.6 403.3h2.8c12.7 0 25.5 0 38.2.1 1.6 0 3.1-.4 3.6 2.1 7.1 34.9 30 54.6 62.9 63.9 26.9 7.6 54.1 7.8 81.3 1.8 33.8-7.4 56-28.3 68-60.4 8-21.5 10.7-43.8 11-66.5.1-5.8.3-47-.2-52.8l-.9-.3c-.8 1.5-1.7 2.9-2.5 4.4-22.1 43.1-61.3 67.4-105.4 69.1-103 4-169.4-57-172-176.2-.5-23.7 1.8-46.9 8.3-69.7C58.3 47.7 112.3.6 191.6 0c61.3-.4 101.5 38.7 116.2 70.3.5 1.1 1.3 2.3 2.4 1.9V10.6h44.3c0 280.3.1 332.2.1 332.2-.1 78.5-26.7 143.7-103 162.2-69.5 16.9-159 4.8-196-57.2-8-13.5-11.8-28.3-13-44.5zM188.9 36.5c-52.5-.5-108.5 40.7-115 133.8-4.1 59 14.8 122.2 71.5 148.6 27.6 12.9 74.3 15 108.3-8.7 47.6-33.2 62.7-97 54.8-154-9.7-71.1-47.8-120-119.6-119.7z"/></svg>';
                break;

            case 'google':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 488 512"><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"/></svg>';
                break;

            case 'instagram':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M13.028 2.001a78.82 78.82 0 0 1 2.189.022l.194.007c.224.008.445.018.712.03 1.064.05 1.79.218 2.427.465.66.254 1.216.598 1.772 1.154a4.908 4.908 0 0 1 1.153 1.771c.247.637.415 1.364.465 2.428.012.266.022.488.03.712l.006.194a79 79 0 0 1 .023 2.188l.001.746v1.31a78.836 78.836 0 0 1-.023 2.189l-.006.194c-.008.224-.018.445-.03.712-.05 1.064-.22 1.79-.466 2.427a4.884 4.884 0 0 1-1.153 1.772 4.915 4.915 0 0 1-1.772 1.153c-.637.247-1.363.415-2.427.465-.267.012-.488.022-.712.03l-.194.006a79 79 0 0 1-2.189.023l-.746.001h-1.309a78.836 78.836 0 0 1-2.189-.023l-.194-.006a60.64 60.64 0 0 1-.712-.03c-1.064-.05-1.79-.22-2.428-.466a4.89 4.89 0 0 1-1.771-1.153 4.904 4.904 0 0 1-1.154-1.772c-.247-.637-.415-1.363-.465-2.427a74.367 74.367 0 0 1-.03-.712l-.005-.194A79.053 79.053 0 0 1 2 13.028v-2.056a78.82 78.82 0 0 1 .022-2.188l.007-.194c.008-.224.018-.446.03-.712.05-1.065.218-1.79.465-2.428A4.88 4.88 0 0 1 3.68 3.68 4.897 4.897 0 0 1 5.45 2.525c.638-.247 1.363-.415 2.428-.465l.712-.03.194-.005A79.053 79.053 0 0 1 10.972 2h2.056Zm-1.028 5A5 5 0 1 0 12 17a5 5 0 0 0 0-10Zm0 2A3 3 0 1 1 12.001 15a3 3 0 0 1 0-6Zm5.25-3.5a1.25 1.25 0 0 0 0 2.498 1.25 1.25 0 0 0 0-2.5Z"/></svg>';
                break;

            case 'linkedin':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg>';
                break;

            case 'mailchimp':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M330.61 243.52a36.15 36.15 0 0 1 9.3 0c1.66-3.83 1.95-10.43.45-17.61-2.23-10.67-5.25-17.14-11.48-16.13s-6.47 8.74-4.24 19.42c1.26 6 3.49 11.14 6 14.32zM277.05 252c4.47 2 7.2 3.26 8.28 2.13 1.89-1.94-3.48-9.39-12.12-13.09a31.44 31.44 0 0 0-30.61 3.68c-3 2.18-5.81 5.22-5.41 7.06.85 3.74 10-2.71 22.6-3.48 7-.44 12.8 1.75 17.26 3.71zm-9 5.13c-9.07 1.42-15 6.53-13.47 10.1.9.34 1.17.81 5.21-.81a37 37 0 0 1 18.72-1.95c2.92.34 4.31.52 4.94-.49 1.46-2.22-5.71-8-15.39-6.85zm54.17 17.1c3.38-6.87-10.9-13.93-14.3-7s10.92 13.88 14.32 6.97zm15.66-20.47c-7.66-.13-7.95 15.8-.26 15.93s7.98-15.81.28-15.96zm-218.79 78.9c-1.32.31-6 1.45-8.47-2.35-5.2-8 11.11-20.38 3-35.77-9.1-17.47-27.82-13.54-35.05-5.54-8.71 9.6-8.72 23.54-5 24.08 4.27.57 4.08-6.47 7.38-11.63a12.83 12.83 0 0 1 17.85-3.72c11.59 7.59 1.37 17.76 2.28 28.62 1.39 16.68 18.42 16.37 21.58 9a2.08 2.08 0 0 0-.2-2.33c.03.89.68-1.3-3.35-.39zm299.72-17.07c-3.35-11.73-2.57-9.22-6.78-20.52 2.45-3.67 15.29-24-3.07-43.25-10.4-10.92-33.9-16.54-41.1-18.54-1.5-11.39 4.65-58.7-21.52-83 20.79-21.55 33.76-45.29 33.73-65.65-.06-39.16-48.15-51-107.42-26.47l-12.55 5.33c-.06-.05-22.71-22.27-23.05-22.57C169.5-18-41.77 216.81 25.78 273.85l14.76 12.51a72.49 72.49 0 0 0-4.1 33.5c3.36 33.4 36 60.42 67.53 60.38 57.73 133.06 267.9 133.28 322.29 3 1.74-4.47 9.11-24.61 9.11-42.38s-10.09-25.27-16.53-25.27zm-316 48.16c-22.82-.61-47.46-21.15-49.91-45.51-6.17-61.31 74.26-75.27 84-12.33 4.54 29.64-4.67 58.49-34.12 57.81zM84.3 249.55C69.14 252.5 55.78 261.09 47.6 273c-4.88-4.07-14-12-15.59-15-13.01-24.85 14.24-73 33.3-100.21C112.42 90.56 186.19 39.68 220.36 48.91c5.55 1.57 23.94 22.89 23.94 22.89s-34.15 18.94-65.8 45.35c-42.66 32.85-74.89 80.59-94.2 132.4zM323.18 350.7s-35.74 5.3-69.51-7.07c6.21-20.16 27 6.1 96.4-13.81 15.29-4.38 35.37-13 51-25.35a102.85 102.85 0 0 1 7.12 24.28c3.66-.66 14.25-.52 11.44 18.1-3.29 19.87-11.73 36-25.93 50.84A106.86 106.86 0 0 1 362.55 421a132.45 132.45 0 0 1-20.34 8.58c-53.51 17.48-108.3-1.74-126-43a66.33 66.33 0 0 1-3.55-9.74c-7.53-27.2-1.14-59.83 18.84-80.37 1.23-1.31 2.48-2.85 2.48-4.79a8.45 8.45 0 0 0-1.92-4.54c-7-10.13-31.19-27.4-26.33-60.83 3.5-24 24.49-40.91 44.07-39.91l5 .29c8.48.5 15.89 1.59 22.88 1.88 11.69.5 22.2-1.19 34.64-11.56 4.2-3.5 7.57-6.54 13.26-7.51a17.45 17.45 0 0 1 13.6 2.24c10 6.64 11.4 22.73 11.92 34.49.29 6.72 1.1 23 1.38 27.63.63 10.67 3.43 12.17 9.11 14 3.19 1.05 6.15 1.83 10.51 3.06 13.21 3.71 21 7.48 26 12.31a16.38 16.38 0 0 1 4.74 9.29c1.56 11.37-8.82 25.4-36.31 38.16-46.71 21.68-93.68 14.45-100.48 13.68-20.15-2.71-31.63 23.32-19.55 41.15 22.64 33.41 122.4 20 151.37-21.35.69-1 .12-1.59-.73-1-41.77 28.58-97.06 38.21-128.46 26-4.77-1.85-14.73-6.44-15.94-16.67 43.6 13.49 71 .74 71 .74s2.03-2.79-.56-2.53zm-68.47-5.7zm-83.4-187.5c16.74-19.35 37.36-36.18 55.83-45.63a.73.73 0 0 1 1 1c-1.46 2.66-4.29 8.34-5.19 12.65a.75.75 0 0 0 1.16.79c11.49-7.83 31.48-16.22 49-17.3a.77.77 0 0 1 .52 1.38 41.86 41.86 0 0 0-7.71 7.74.75.75 0 0 0 .59 1.19c12.31.09 29.66 4.4 41 10.74.76.43.22 1.91-.64 1.72-69.55-15.94-123.08 18.53-134.5 26.83a.76.76 0 0 1-1-1.12z"/></svg>';
                break;

            case 'medium':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M71.5 142.3c.6-5.9-1.7-11.8-6.1-15.8L20.3 72.1V64h140.2l108.4 237.7L364.2 64h133.7v8.1l-38.6 37c-3.3 2.5-5 6.7-4.3 10.8v272c-.7 4.1 1 8.3 4.3 10.8l37.7 37v8.1H307.3v-8.1l39.1-37.9c3.8-3.8 3.8-5 3.8-10.8V171.2L241.5 447.1h-14.7L100.4 171.2v184.9c-1.1 7.8 1.5 15.6 7 21.2l50.8 61.6v8.1h-144v-8L65 377.3c5.4-5.6 7.9-13.5 6.5-21.2V142.3z"/></svg>';
                break;

            case 'mixcloud':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M424.43 219.729C416.124 134.727 344.135 68 256.919 68c-72.266 0-136.224 46.516-159.205 114.074-54.545 8.029-96.63 54.822-96.63 111.582 0 62.298 50.668 112.966 113.243 112.966h289.614c52.329 0 94.969-42.362 94.969-94.693 0-45.131-32.118-83.063-74.48-92.2zm-20.489 144.53H114.327c-39.04 0-70.881-31.564-70.881-70.604s31.841-70.604 70.881-70.604c18.827 0 36.548 7.475 49.838 20.766 19.963 19.963 50.133-10.227 30.18-30.18-14.675-14.398-32.672-24.365-52.053-29.349 19.935-44.3 64.79-73.926 114.628-73.926 69.496 0 125.979 56.483 125.979 125.702 0 13.568-2.215 26.857-6.369 39.594-8.943 27.517 32.133 38.939 40.147 13.29 2.769-8.306 4.984-16.889 6.369-25.472 19.381 7.476 33.502 26.303 33.502 48.453 0 28.795-23.535 52.33-52.607 52.33zm235.069-52.33c0 44.024-12.737 86.386-37.102 122.657-4.153 6.092-10.798 9.414-17.72 9.414-16.317 0-27.127-18.826-17.443-32.949 19.381-29.349 29.903-63.682 29.903-99.122s-10.521-69.773-29.903-98.845c-15.655-22.831 19.361-47.24 35.163-23.534 24.366 35.993 37.102 78.356 37.102 122.379zm-70.88 0c0 31.565-9.137 62.021-26.857 88.325-4.153 6.091-10.798 9.136-17.72 9.136-17.201 0-27.022-18.979-17.443-32.948 13.013-19.104 19.658-41.255 19.658-64.513 0-22.981-6.645-45.408-19.658-64.512-15.761-22.986 19.008-47.095 35.163-23.535 17.719 26.026 26.857 56.483 26.857 88.047z"/></svg>';
                break;

            case 'pinterest':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path d="M256.05 32c-123.7 0-224 100.3-224 224 0 91.7 55.2 170.5 134.1 205.2-.6-15.6-.1-34.4 3.9-51.4 4.3-18.2 28.8-122.1 28.8-122.1s-7.2-14.3-7.2-35.4c0-33.2 19.2-58 43.2-58 20.4 0 30.2 15.3 30.2 33.6 0 20.5-13.1 51.1-19.8 79.5-5.6 23.8 11.9 43.1 35.4 43.1 42.4 0 71-54.5 71-119.1 0-49.1-33.1-85.8-93.2-85.8-67.9 0-110.3 50.7-110.3 107.3 0 19.5 5.8 33.3 14.8 43.9 4.1 4.9 4.7 6.9 3.2 12.5-1.1 4.1-3.5 14-4.6 18-1.5 5.7-6.1 7.7-11.2 5.6-31.3-12.8-45.9-47-45.9-85.6 0-63.6 53.7-139.9 160.1-139.9 85.5 0 141.8 61.9 141.8 128.3 0 87.9-48.9 153.5-120.9 153.5-24.2 0-46.9-13.1-54.7-27.9 0 0-13 51.6-15.8 61.6-4.7 17.3-14 34.5-22.5 48a225.13 225.13 0 0 0 63.5 9.2c123.7 0 224-100.3 224-224S379.75 32 256.05 32z"/></svg>';
                break;

            case 'reddit':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M440.3 203.5c-15 0-28.2 6.2-37.9 15.9-35.7-24.7-83.8-40.6-137.1-42.3L293 52.3l88.2 19.8c0 21.6 17.6 39.2 39.2 39.2 22 0 39.7-18.1 39.7-39.7s-17.6-39.7-39.7-39.7c-15.4 0-28.7 9.3-35.3 22l-97.4-21.6c-4.9-1.3-9.7 2.2-11 7.1L246.3 177c-52.9 2.2-100.5 18.1-136.3 42.8-9.7-10.1-23.4-16.3-38.4-16.3-55.6 0-73.8 74.6-22.9 100.1-1.8 7.9-2.6 16.3-2.6 24.7 0 83.8 94.4 151.7 210.3 151.7 116.4 0 210.8-67.9 210.8-151.7 0-8.4-.9-17.2-3.1-25.1 49.9-25.6 31.5-99.7-23.8-99.7zM129.4 308.9c0-22 17.6-39.7 39.7-39.7 21.6 0 39.2 17.6 39.2 39.7 0 21.6-17.6 39.2-39.2 39.2-22 .1-39.7-17.6-39.7-39.2zm214.3 93.5c-36.4 36.4-139.1 36.4-175.5 0-4-3.5-4-9.7 0-13.7 3.5-3.5 9.7-3.5 13.2 0 27.8 28.5 120 29 149 0 3.5-3.5 9.7-3.5 13.2 0 4.1 4 4.1 10.2.1 13.7zm-.8-54.2c-21.6 0-39.2-17.6-39.2-39.2 0-22 17.6-39.7 39.2-39.7 22 0 39.7 17.6 39.7 39.7-.1 21.5-17.7 39.2-39.7 39.2z"/></svg>';
                break;

            case 'rss':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M128.081 415.959c0 35.369-28.672 64.041-64.041 64.041S0 451.328 0 415.959s28.672-64.041 64.041-64.041 64.04 28.673 64.04 64.041zm175.66 47.25c-8.354-154.6-132.185-278.587-286.95-286.95C7.656 175.765 0 183.105 0 192.253v48.069c0 8.415 6.49 15.472 14.887 16.018 111.832 7.284 201.473 96.702 208.772 208.772.547 8.397 7.604 14.887 16.018 14.887h48.069c9.149.001 16.489-7.655 15.995-16.79zm144.249.288C439.596 229.677 251.465 40.445 16.503 32.01 7.473 31.686 0 38.981 0 48.016v48.068c0 8.625 6.835 15.645 15.453 15.999 191.179 7.839 344.627 161.316 352.465 352.465.353 8.618 7.373 15.453 15.999 15.453h48.068c9.034-.001 16.329-7.474 16.005-16.504z"/></svg>';
                break;

            case 'skype':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M424.7 299.8c2.9-14 4.7-28.9 4.7-43.8 0-113.5-91.9-205.3-205.3-205.3-14.9 0-29.7 1.7-43.8 4.7C161.3 40.7 137.7 32 112 32 50.2 32 0 82.2 0 144c0 25.7 8.7 49.3 23.3 68.2-2.9 14-4.7 28.9-4.7 43.8 0 113.5 91.9 205.3 205.3 205.3 14.9 0 29.7-1.7 43.8-4.7 19 14.6 42.6 23.3 68.2 23.3 61.8 0 112-50.2 112-112 .1-25.6-8.6-49.2-23.2-68.1zm-194.6 91.5c-65.6 0-120.5-29.2-120.5-65 0-16 9-30.6 29.5-30.6 31.2 0 34.1 44.9 88.1 44.9 25.7 0 42.3-11.4 42.3-26.3 0-18.7-16-21.6-42-28-62.5-15.4-117.8-22-117.8-87.2 0-59.2 58.6-81.1 109.1-81.1 55.1 0 110.8 21.9 110.8 55.4 0 16.9-11.4 31.8-30.3 31.8-28.3 0-29.2-33.5-75-33.5-25.7 0-42 7-42 22.5 0 19.8 20.8 21.8 69.1 33 41.4 9.3 90.7 26.8 90.7 77.6 0 59.1-57.1 86.5-112 86.5z"/></svg>';
                break;

            case 'snapchat':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M510.846 392.673c-5.211 12.157-27.239 21.089-67.36 27.318-2.064 2.786-3.775 14.686-6.507 23.956-1.625 5.566-5.623 8.869-12.128 8.869l-.297-.005c-9.395 0-19.203-4.323-38.852-4.323-26.521 0-35.662 6.043-56.254 20.588-21.832 15.438-42.771 28.764-74.027 27.399-31.646 2.334-58.025-16.908-72.871-27.404-20.714-14.643-29.828-20.582-56.241-20.582-18.864 0-30.736 4.72-38.852 4.72-8.073 0-11.213-4.922-12.422-9.04-2.703-9.189-4.404-21.263-6.523-24.13-20.679-3.209-67.31-11.344-68.498-32.15a10.627 10.627 0 0 1 8.877-11.069c69.583-11.455 100.924-82.901 102.227-85.934.074-.176.155-.344.237-.515 3.713-7.537 4.544-13.849 2.463-18.753-5.05-11.896-26.872-16.164-36.053-19.796-23.715-9.366-27.015-20.128-25.612-27.504 2.437-12.836 21.725-20.735 33.002-15.453 8.919 4.181 16.843 6.297 23.547 6.297 5.022 0 8.212-1.204 9.96-2.171-2.043-35.936-7.101-87.29 5.687-115.969C158.122 21.304 229.705 15.42 250.826 15.42c.944 0 9.141-.089 10.11-.089 52.148 0 102.254 26.78 126.723 81.643 12.777 28.65 7.749 79.792 5.695 116.009 1.582.872 4.357 1.942 8.599 2.139 6.397-.286 13.815-2.389 22.069-6.257 6.085-2.846 14.406-2.461 20.48.058l.029.01c9.476 3.385 15.439 10.215 15.589 17.87.184 9.747-8.522 18.165-25.878 25.018-2.118.835-4.694 1.655-7.434 2.525-9.797 3.106-24.6 7.805-28.616 17.271-2.079 4.904-1.256 11.211 2.46 18.748.087.168.166.342.239.515 1.301 3.03 32.615 74.46 102.23 85.934 6.427 1.058 11.163 7.877 7.725 15.859z"/></svg>';
                break;

            case 'soundcloud':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2.8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1.6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7.6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3.1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z"/></svg>';
                break;

            case 'steam':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M395.5 177.5c0 33.8-27.5 61-61 61-33.8 0-61-27.3-61-61s27.3-61 61-61c33.5 0 61 27.2 61 61zm52.5.2c0 63-51 113.8-113.7 113.8L225 371.3c-4 43-40.5 76.8-84.5 76.8-40.5 0-74.7-28.8-83-67L0 358V250.7L97.2 290c15.1-9.2 32.2-13.3 52-11.5l71-101.7c.5-62.3 51.5-112.8 114-112.8C397 64 448 115 448 177.7zM203 363c0-34.7-27.8-62.5-62.5-62.5-4.5 0-9 .5-13.5 1.5l26 10.5c25.5 10.2 38 39 27.7 64.5-10.2 25.5-39.2 38-64.7 27.5-10.2-4-20.5-8.3-30.7-12.2 10.5 19.7 31.2 33.2 55.2 33.2 34.7 0 62.5-27.8 62.5-62.5zm207.5-185.3c0-42-34.3-76.2-76.2-76.2-42.3 0-76.5 34.2-76.5 76.2 0 42.2 34.3 76.2 76.5 76.2 41.9.1 76.2-33.9 76.2-76.2z"/></svg>';
                break;

            case 'telegram':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M446.7 98.6l-67.6 318.8c-5.1 22.5-18.4 28.1-37.3 17.5l-103-75.9-49.7 47.8c-5.5 5.5-10.1 10.1-20.7 10.1l7.4-104.9 190.9-172.5c8.3-7.4-1.8-11.5-12.9-4.1L117.8 284 16.2 252.2c-22.1-6.9-22.5-22.1 4.6-32.7L418.2 66.4c18.4-6.9 34.5 4.1 28.5 32.2z"/></svg>';
                break;

            case 'tiktok':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>';
                break;

            case 'tumblr':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M309.8 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6v-144H17.9c-5.5 0-10-4.5-10-10v-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1.8-11 6.5-16.3 16.1-16.3h70.9c5.5 0 10 4.5 10 10v115.2h83c5.5 0 10 4.4 10 9.9v81.7c0 5.5-4.5 10-10 10h-83.4V360c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5.9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"/></svg>';
                break;

            case 'twitch':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M391.17,103.47H352.54v109.7h38.63ZM285,103H246.37V212.75H285ZM120.83,0,24.31,91.42V420.58H140.14V512l96.53-91.42h77.25L487.69,256V0ZM449.07,237.75l-77.22,73.12H294.61l-67.6,64v-64H140.14V36.58H449.07Z"/></svg>';
                break;

            case 'twitter':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8l164.9-188.5L26.8 48h145.6l100.5 132.9L389.2 48zm-24.8 373.8h39.1L151.1 88h-42l255.3 333.8z"/></svg>';
                break;

            case 'viber':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M444 49.9C431.3 38.2 379.9.9 265.3.4c0 0-135.1-8.1-200.9 52.3C27.8 89.3 14.9 143 13.5 209.5c-1.4 66.5-3.1 191.1 117 224.9h.1l-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM457.9 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9.4-85.7.4-85.7-.1 0-.1 0 0 0-101.8-28.2-95.8-134.3-94.7-189.8 1.1-55.5 11.6-101 42.6-131.6 55.7-50.5 170.4-43 170.4-43 96.9.4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9.6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4.7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5.9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9.1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7.5 133 51.4 133.7 139.2zM374.9 329v.2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8h.2c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1.8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z"/></svg>';
                break;

            case 'vimeo':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"/></svg>';
                break;

            case 'vine':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M384 254.7v52.1c-18.4 4.2-36.9 6.1-52.1 6.1-36.9 77.4-103 143.8-125.1 156.2-14 7.9-27.1 8.4-42.7-.8C137 452 34.2 367.7 0 102.7h74.5C93.2 261.8 139 343.4 189.3 404.5c27.9-27.9 54.8-65.1 75.6-106.9-49.8-25.3-80.1-80.9-80.1-145.6 0-65.6 37.7-115.1 102.2-115.1 114.9 0 106.2 127.9 81.6 181.5 0 0-46.4 9.2-63.5-20.5 3.4-11.3 8.2-30.8 8.2-48.5 0-31.3-11.3-46.6-28.4-46.6-18.2 0-30.8 17.1-30.8 50 .1 79.2 59.4 118.7 129.9 101.9z"/></svg>';
                break;

            case 'vkontakte':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M545 117.7c3.7-12.5 0-21.7-17.8-21.7h-58.9c-15 0-21.9 7.9-25.6 16.7 0 0-30 73.1-72.4 120.5-13.7 13.7-20 18.1-27.5 18.1-3.7 0-9.4-4.4-9.4-16.9V117.7c0-15-4.2-21.7-16.6-21.7h-92.6c-9.4 0-15 7-15 13.5 0 14.2 21.2 17.5 23.4 57.5v86.8c0 19-3.4 22.5-10.9 22.5-20 0-68.6-73.4-97.4-157.4-5.8-16.3-11.5-22.9-26.6-22.9H38.8c-16.8 0-20.2 7.9-20.2 16.7 0 15.6 20 93.1 93.1 195.5C160.4 378.1 229 416 291.4 416c37.5 0 42.1-8.4 42.1-22.9 0-66.8-3.4-73.1 15.4-73.1 8.7 0 23.7 4.4 58.7 38.1 40 40 46.6 57.9 69 57.9h58.9c16.8 0 25.3-8.4 20.4-25-11.2-34.9-86.9-106.7-90.3-111.5-8.7-11.2-6.2-16.2 0-26.2.1-.1 72-101.3 79.4-135.6z"/></svg>';
                break;

            case 'whatsapp':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>';
                break;

            case 'xing':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8.3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1.2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z"/></svg>';
                break;

            case 'youtube':
                $out = '<svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path d="M508.64 148.79c0-45-33.1-81.2-74-81.2C379.24 65 322.74 64 265 64h-18c-57.6 0-114.2 1-169.6 3.6C36.6 67.6 3.5 104 3.5 149 1 184.59-.06 220.19 0 255.79q-.15 53.4 3.4 106.9c0 45 33.1 81.5 73.9 81.5 58.2 2.7 117.9 3.9 178.6 3.8q91.2.3 178.6-3.8c40.9 0 74-36.5 74-81.5 2.4-35.7 3.5-71.3 3.4-107q.34-53.4-3.26-106.9zM207 353.89v-196.5l145 98.2z"/></svg>';
                break;
            default:
                $out = '';
                break;
        }
        return '<span class="icon-svg">' . $out . '</span>';
    }
}

/*
--------------------------------------------------------------------------------
* Print SVG Icons Socials
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_svg_icon_social' ) ) {

	function th90_svg_icon_social( $icon = '' ) {
        echo do_shortcode( th90_get_svg_icon_social( $icon ) );
    }
}

/*
--------------------------------------------------------------------------------
* SVG URL ENCODE
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_get_svg_url_encode' ) ) {
	function th90_get_svg_url_encode( $icon = '', $color = '' ) {
		switch ( $icon ) {
			case 'papper':
				$out = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100' viewBox='0 0 100 100'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpath opacity='.5' d='M96 95h4v1h-4v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9zm-1 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9z'/%3E%3Cpath d='M6 5V0H5v5H0v1h5v94h1V6h94V5H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'hideout':
				$out = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='40' height='40' viewBox='0 0 40 40'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpath d='M0 38.59l2.83-2.83 1.41 1.41L1.41 40H0v-1.41zM0 1.4l2.83 2.83 1.41-1.41L1.41 0H0v1.41zM38.59 40l-2.83-2.83 1.41-1.41L40 38.59V40h-1.41zM40 1.41l-2.83 2.83-1.41-1.41L38.59 0H40v1.41zM20 18.6l2.83-2.83 1.41 1.41L21.41 20l2.83 2.83-1.41 1.41L20 21.41l-2.83 2.83-1.41-1.41L18.59 20l-2.83-2.83 1.41-1.41L20 18.59z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'triangle':
				$out = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='36' height='72' viewBox='0 0 36 72'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpath d='M2 6h12L8 18 2 6zm18 36h12l-6 12-6-12z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'yyy':
				$out = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='60' height='96' viewBox='0 0 60 96'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpath d='M36 10a6 6 0 0 1 12 0v12a6 6 0 0 1-6 6 6 6 0 0 0-6 6 6 6 0 0 1-12 0 6 6 0 0 0-6-6 6 6 0 0 1-6-6V10a6 6 0 1 1 12 0 6 6 0 0 0 12 0zm24 78a6 6 0 0 1-6-6 6 6 0 0 0-6-6 6 6 0 0 1-6-6V58a6 6 0 1 1 12 0 6 6 0 0 0 6 6v24zM0 88V64a6 6 0 0 0 6-6 6 6 0 0 1 12 0v12a6 6 0 0 1-6 6 6 6 0 0 0-6 6 6 6 0 0 1-6 6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'stars':
				$out = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpolygon fill-rule='evenodd' points='8 4 12 6 8 8 6 12 4 8 0 6 4 4 6 0 8 4'/%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'wiggle':
				$out = "data:image/svg+xml,%3Csvg width='52' height='26' viewBox='0 0 52 26' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='" . urlencode( $color ) . "' fill-opacity='1'%3E%3Cpath d='M10 10c0-2.21-1.79-4-4-4-3.314 0-6-2.686-6-6h2c0 2.21 1.79 4 4 4 3.314 0 6 2.686 6 6 0 2.21 1.79 4 4 4 3.314 0 6 2.686 6 6 0 2.21 1.79 4 4 4v2c-3.314 0-6-2.686-6-6 0-2.21-1.79-4-4-4-3.314 0-6-2.686-6-6zm25.464-1.95l8.486 8.486-1.414 1.414-8.486-8.486 1.414-1.414z' /%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
				break;
			case 'lines_motion':
				$out = "data:image/svg+xml,%3Csvg width='120' height='120' viewBox='0 0 120 120' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M9 0h2v20H9V0zm25.134.84l1.732 1-10 17.32-1.732-1 10-17.32zm-20 20l1.732 1-10 17.32-1.732-1 10-17.32zM58.16 4.134l1 1.732-17.32 10-1-1.732 17.32-10zm-40 40l1 1.732-17.32 10-1-1.732 17.32-10zM80 9v2H60V9h20zM20 69v2H0v-2h20zm79.32-55l-1 1.732-17.32-10L82 4l17.32 10zm-80 80l-1 1.732-17.32-10L2 84l17.32 10zm96.546-75.84l-1.732 1-10-17.32 1.732-1 10 17.32zm-100 100l-1.732 1-10-17.32 1.732-1 10 17.32zM38.16 24.134l1 1.732-17.32 10-1-1.732 17.32-10zM60 29v2H40v-2h20zm19.32 5l-1 1.732-17.32-10L62 24l17.32 10zm16.546 4.16l-1.732 1-10-17.32 1.732-1 10 17.32zM111 40h-2V20h2v20zm3.134.84l1.732 1-10 17.32-1.732-1 10-17.32zM40 49v2H20v-2h20zm19.32 5l-1 1.732-17.32-10L42 44l17.32 10zm16.546 4.16l-1.732 1-10-17.32 1.732-1 10 17.32zM91 60h-2V40h2v20zm3.134.84l1.732 1-10 17.32-1.732-1 10-17.32zm24.026 3.294l1 1.732-17.32 10-1-1.732 17.32-10zM39.32 74l-1 1.732-17.32-10L22 64l17.32 10zm16.546 4.16l-1.732 1-10-17.32 1.732-1 10 17.32zM71 80h-2V60h2v20zm3.134.84l1.732 1-10 17.32-1.732-1 10-17.32zm24.026 3.294l1 1.732-17.32 10-1-1.732 17.32-10zM120 89v2h-20v-2h20zm-84.134 9.16l-1.732 1-10-17.32 1.732-1 10 17.32zM51 100h-2V80h2v20zm3.134.84l1.732 1-10 17.32-1.732-1 10-17.32zm24.026 3.294l1 1.732-17.32 10-1-1.732 17.32-10zM100 109v2H80v-2h20zm19.32 5l-1 1.732-17.32-10 1-1.732 17.32 10zM31 120h-2v-20h2v20z' fill='" . urlencode( $color ) . "' fill-opacity='1' fill-rule='evenodd'/%3E%3C/svg%3E";
			break;
			case 'snowball_dots':
				$out = "data:image/svg+xml;charset=utf8,%3Csvg id='Layer_1' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 500 500' style='enable-background:new 0 0 500 500'%3E%3Cstyle%3E .st0{fill:" . urlencode( $color ) . "} %3C/style%3E%3Ccircle class='st0' cx='87.5' cy='46.5' r='8.5'/%3E%3Ccircle class='st0' cx='94.5' cy='124.5' r='15.5'/%3E%3Ccircle class='st0' cx='244.5' cy='91.5' r='21.5'/%3E%3Ccircle class='st0' cx='348.5' cy='80.5' r='7.5'/%3E%3Ccircle class='st0' cx='155' cy='356' r='10'/%3E%3Ccircle class='st0' cx='422' cy='139' r='14'/%3E%3Ccircle class='st0' cx='123' cy='251' r='6'/%3E%3Ccircle class='st0' cx='280' cy='204' r='11'/%3E%3Ccircle class='st0' cx='315' cy='311' r='11'/%3E%3Ccircle class='st0' cx='262' cy='411' r='6'/%3E%3Ccircle class='st0' cx='455.5' cy='395.5' r='12.5'/%3E%3Ccircle class='st0' cx='432' cy='500' r='25'/%3E%3Ccircle class='st0' cx='432' r='25'/%3E%3Ccircle class='st0' cx='-3.5' cy='240.5' r='10.5'/%3E%3Ccircle class='st0' cx='496.5' cy='240.5' r='10.5'/%3E%3Ccircle class='st0' cx='96' cy='437' r='3'/%3E%3C/svg%3E";
				break;
			case 'hecho':
				$out = "data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 500 500' fill-opacity='1' style='enable-background:new 0 0 500 500'%3E%3Cstyle%3E .st2{fill:" . urlencode( $color ) . "} %3C/style%3E%3Cg style='display:none'%3E%3Cpath style='display:inline;fill:%23006838' d='M-9.7-3.7h534v534h-534z' id='Layer_2'/%3E%3C/g%3E%3Cg id='Layer_1'%3E%3Cpath class='st2' d='M203.1 58.9c-1.7-.8-3-.5-3.8-.3-.1 0-.2 0-.2.1-.1-.1-.4-.2-.8-.6-3.6-3.1-6.5-3.4-7-3.4-.3 0-.6 0-.9.1l-34.2 11.4c-.6.2-1.1.6-1.4 1.2 0 0-.8 1.2-3.1 3.2-2.2 1.8-4.9 2-4.9 2-1.2.1-2.2 1-2.4 2.2 0 0-.2 1-.8 1.2-2.2.9-5.7 3.1-6.1 3.4-.2.1-.3.2-.5.4l-1.2 1.2c-1.6.3-4.3.9-5.8 1.8-.7.4-1.3 1-1.9 1.5-1.2 1-2.5 2.2-4 2.6-.8.2-2 0-3.2-.2-1.8-.4-4.1-.8-6.2.5-.7.5-1.8 1.3-3.2 2.3-2.7 2-6.5 4.8-8.9 5.9l-1.2.6c-3.6 1.8-3.7 1.6-4.3 1-.9-1-1.2-1.7-1.6-2.8-.5-1.3-1.2-2.9-2.9-5.3-3.6-5-7.2-4.2-9.2-3.7-.2.1-.5.1-.7.2-1.4.2-2.4.9-3.1 1.4-.1.1-.3.2-.4.3-1.5-.5-2.6-.6-3.5-.6-.5 0-.8 0-1.1-.1-1.8-.5-4-.2-4.4-.1-.8.1-1.5.6-1.9 1.3-.4.7-.5 1.5-.2 2.3l1.1 2.9c.1.3.3 1.1.4 2.1.2 1.8 1.6 7.5 2.1 9.3.5 1.9.8 2.9 1.1 4.7.3 1.6 1 2.6 1.4 3.2 0 .1-.1.2-.1.3-.6 1.3-1.6 3.5-.5 6.2.4 1.1.9 3.1 1.4 4.9.6 2.2.9 3.6 1.3 4.6.6 1.9 3.4 19.8 3.5 25.2.1 3.6-.2 9.2-.4 13.3-.1 2.2-.2 4-.2 4.9 0 .7-.3 1.3-.6 2-.4.9-1.1 2.5-.3 4.2.7 1.3 2 1.7 3 2 1.7.5 2.2.8 2.3 2.2.1 1.4.1 2.4 0 3.3-.1 2.2-.1 3.7 1.6 6.6 2.7 4.8 5.6 5.1 8.3 5 2-.1 33.6-8.6 55.2-14.8 7.6-2.2 14-4.1 17.3-5.2 13.5-4.6 60.3-20.4 60.8-20.6.7-.2 1.3-.7 1.6-1.4.3-.7.3-1.4 0-2.1-7.1-16.8-14.8-35.9-15.2-38.5-.1-1.8-.4-3.2-.6-4.7-.3-1.3-.5-2.7-.7-4.4-.6-6-4.6-6.3-6.6-6.4h-.3c-1-.1-1.2-.2-1.2-.2s-.2-.2-.2-.9c-.3-2.6-.3-4.1.2-5.6.1-.3.2-.5.3-.7.6-1.6.8-2.4 1.1-6.2.2-2 0-3.4 0-4.3-.1-1.2-.1-1.7.2-2.7.7-2.2.4-4.3.1-6.1-.2-1.1-.3-2.1-.2-2.9.1-.4.2-.8.2-1.2.6-2.9 1.5-7.1-2.4-9zm-2.7 7.6c-.1.4-.2.9-.3 1.3-.3 1.7 0 3.3.2 4.7.2 1.3.4 2.6.1 3.5-.7 2.1-.6 3.5-.5 4.9.1.9.2 1.9 0 3.5-.3 3.2-.4 3.6-.8 4.7-.1.2-.2.5-.3.8-.9 2.6-.8 5.2-.5 7.9.5 5.4 4.8 5.7 6.2 5.8h.3c.5 0 1.2.1 1.4.2 0 0 .3.3.4 1.5.2 2 .5 3.6.8 4.9.3 1.4.5 2.6.6 4 .1 2.9 9.4 25.6 14.5 37.7-10.2 3.4-46.5 15.7-58.1 19.7-13.6 4.7-67.4 19.2-71 19.7-1.5.1-2.1 0-3.4-2.3-1-1.8-1-2.2-.9-3.8 0-.9.1-2.2 0-3.9-.3-4.4-3.3-5.9-5.2-6.6.4-.8.7-2 .7-3.4 0-.8.1-2.6.2-4.7.2-4.2.5-9.9.4-13.6-.1-5.3-2.9-24.9-3.9-27.2-.3-.6-.7-2.3-1.1-3.8-.5-2-1-4.1-1.6-5.5-.2-.6-.1-1.1.4-2.2.3-.6.6-1.4.7-2.2.2-1.7-.6-2.7-1.1-3.4-.3-.4-.4-.6-.5-.9-.3-2.1-.7-3.4-1.3-5.3-.5-1.9-1.8-7.2-1.9-8.4-.1-1.1-.3-2-.4-2.5.4 0 .7.1 1 .1.7 0 1.3.1 2.1.4 2.4.9 4.1-.3 5.1-1 .4-.2.7-.5.9-.5.4-.1.7-.1 1.1-.2 1.5-.4 2.1-.5 3.7 1.6 1.3 1.9 1.9 3.1 2.3 4.3.5 1.3 1.1 2.6 2.5 4.2 3.4 3.9 7.4 1.9 10.6.3l1.2-.6c2.8-1.4 6.8-4.3 9.7-6.4 1.3-.9 2.3-1.7 2.9-2.1.3-.1 1.6.1 2.3.2 1.6.3 3.6.7 5.7.1 2.7-.8 4.6-2.5 6-3.7.5-.4 1-.8 1.3-1 .6-.4 3-1 4.7-1.3.5-.1 1-.3 1.4-.7l1.6-1.6c1.1-.7 3.7-2.2 5.1-2.8 1.8-.8 2.8-2.2 3.4-3.3 1.6-.4 3.9-1.2 6-2.9 1.9-1.6 3.1-2.9 3.7-3.7l32.5-11c.6.2 1.9.7 3.4 2 2.4 2.1 4 2.2 5.8 1.7h.2c.1.6-.2 1.9-.3 2.8z'/%3E%3Cpath class='st2' d='M119.7 144.4c-2.3.7-4.2 2.2-5.3 4.3-2-1.2-4.5-1.5-6.8-.8-4.7 1.4-7.4 6.3-6.1 11 2.9 10 18.6 15.9 19.3 16.2.4.1.8.2 1.2 0 .4-.1.7-.3 1-.7.4-.6 10.6-13.9 7.7-24-1.4-4.6-6.3-7.4-11-6zm1.1 26.6c-3.6-1.6-13.7-6.5-15.7-13.2-.8-2.7.8-5.5 3.5-6.3 1.9-.5 3.9.1 5.2 1.6.5.6 1.2.8 1.9.6.7-.2 1.2-.8 1.3-1.5.3-2 1.7-3.6 3.6-4.1 2.7-.8 5.5.8 6.3 3.5 2.1 6.7-3.9 16.1-6.1 19.4z'/%3E%3Cg%3E%3Cpath class='st2' d='M477.1 410.2c-.9-1.3-1.9-1.6-2.5-1.8h-.2c-.1-.1-.2-.3-.3-.7-1.2-3.6-3-5-3.4-5.2-.2-.1-.4-.2-.7-.3l-28-6.3c-.5-.1-1-.1-1.5.2 0 0-1 .5-3.4.9-2.2.3-4.2-.6-4.2-.6-.9-.4-1.9-.2-2.6.5 0 0-.5.6-1 .5-1.9-.3-5.2-.2-5.6-.2-.2 0-.3 0-.5.1l-1.3.3c-1.2-.4-3.3-1.1-4.7-1.1-.6 0-1.3.1-2 .3-1.2.2-2.6.5-3.8.1-.7-.2-1.4-.8-2.1-1.5-1.1-1-2.5-2.3-4.4-2.2-.7 0-1.8.1-3.2.3-2.7.3-6.4.6-8.5.4-.4 0-.7-.1-1.1-.1-3.2-.2-3.2-.4-3.3-1.1-.2-1-.1-1.7 0-2.6.2-1.1.4-2.5.2-4.8-.4-4.9-3.2-5.8-4.8-6.3-.2-.1-.4-.1-.6-.2-1.1-.4-2-.4-2.7-.3h-.4c-.8-.9-1.6-1.5-2.1-1.8-.3-.2-.6-.4-.7-.6-1-1.1-2.7-1.8-3-1.9-.6-.2-1.2-.2-1.8.1-.6.3-.9.8-1.1 1.5l-.4 2.4c-.1.2-.3.9-.6 1.6-.6 1.3-2 5.8-2.4 7.2-.4 1.5-.6 2.3-1.2 3.7-.5 1.2-.4 2.2-.3 2.8-.1.1-.2.1-.2.2-.9.7-2.5 1.8-2.9 4.1-.2 1-.6 2.5-1.1 3.9-.5 1.8-.9 2.9-1 3.7-.4 1.6-5.8 15-7.9 18.7-1.4 2.5-3.9 6.2-5.7 8.9-1 1.5-1.8 2.6-2.1 3.3-.3.5-.7.8-1.2 1.1-.7.5-1.8 1.2-1.9 2.8-.1 1.2.6 2 1.2 2.6.9 1 1.2 1.5.7 2.4-.5 1-.9 1.7-1.3 2.2-1 1.4-1.6 2.5-1.6 5.2-.1 4.4 1.7 5.8 3.6 6.8 1.4.8 26.5 7.9 43.8 12.5 6.1 1.6 11.3 2.9 14 3.5 11.1 2.4 49.6 10.8 50 10.9.6.1 1.2 0 1.6-.3.5-.3.8-.9.9-1.4 2.1-14.4 4.7-30.7 5.4-32.6.7-1.2 1.1-2.3 1.5-3.5.4-1 .7-2 1.3-3.3 2.1-4.3-.6-6.2-1.9-7.1l-.2-.1c-.6-.4-.7-.6-.7-.6s0-.2.2-.7c.9-1.9 1.5-2.9 2.4-3.7.2-.1.3-.3.5-.4 1.1-.8 1.6-1.3 3.3-3.7.9-1.3 1.4-2.3 1.8-3 .4-.8.6-1.2 1.3-1.8 1.4-1.2 2-2.7 2.6-4.1.3-.8.6-1.6 1-2.1.2-.2.4-.5.6-.7 1.8-1.6 4.1-4.1 2.2-7zm-4.9 4c-.2.3-.5.5-.7.8-.9 1-1.4 2.2-1.8 3.3-.4 1-.8 2-1.4 2.5-1.4 1.2-1.9 2.1-2.4 3.2-.3.6-.7 1.4-1.4 2.4-1.5 2.1-1.7 2.3-2.5 2.9-.2.1-.3.3-.5.4-1.7 1.4-2.7 3.3-3.6 5.2-1.8 3.9.9 5.9 1.9 6.6l.2.2c.3.2.8.5.8.7 0 0 .1.3-.4 1.2-.7 1.5-1.1 2.6-1.5 3.7-.4 1.1-.7 2-1.2 2.9-1.1 2.1-4 21.4-5.5 31.7-8.4-1.8-38.2-8.4-47.8-10.4-11.2-2.4-54-14.6-56.7-15.7-1.1-.6-1.4-.8-1.4-3 0-1.7.2-1.9.9-3 .4-.6 1-1.4 1.6-2.7 1.6-3.1.2-5.4-.8-6.6.6-.4 1.3-1.1 1.9-2 .3-.6 1.1-1.7 2.1-3.1 1.8-2.8 4.4-6.6 5.9-9.2 2.1-3.7 8.2-18.2 8.5-20.2.1-.5.5-1.9.8-3 .5-1.6 1-3.2 1.2-4.4.1-.5.4-.8 1.2-1.3.5-.3 1-.7 1.4-1.2.8-1.1.7-2.1.6-2.8 0-.4 0-.6.1-.8.6-1.6.9-2.6 1.3-4.2.4-1.5 1.7-5.7 2.1-6.6.3-.8.6-1.5.7-1.9.2.2.5.3.7.5.5.3.9.6 1.3 1.1 1.3 1.6 3 1.5 3.9 1.4h.8l.9.3c1.2.4 1.7.5 1.8 2.6.1 1.9 0 2.9-.2 3.9-.2 1.1-.3 2.2 0 3.9.7 4.1 4.3 4.3 7.2 4.5.3 0 .7.1 1 .1 2.5.2 6.4-.2 9.2-.4 1.2-.1 2.3-.2 2.9-.2.3 0 1 .7 1.5 1.1 1 .9 2.2 2 3.8 2.4 2.1.6 4.2.2 5.6-.1.5-.1 1-.2 1.3-.2.6 0 2.4.5 3.7 1.1.4.2.9.2 1.3.1l1.7-.4c1.1 0 3.4 0 4.6.2 1.6.2 2.8-.3 3.7-.9 1.2.4 3.2.8 5.3.5 2-.3 3.3-.7 4.1-1l26.8 6c.3.4 1 1.2 1.5 2.8.8 2.4 1.9 3.1 3.3 3.5h.1c-.2.3-1 1.1-1.4 1.6z'/%3E%3Cpath class='st2' d='M385 434.4c-1.9-.5-3.8-.2-5.4.8-.9-1.6-2.5-2.9-4.3-3.4-3.8-1-7.6 1.2-8.6 5-2.1 8 6.2 18.6 6.5 19 .2.3.5.4.8.5.3.1.6.1.9-.1.5-.2 13-5.1 15.1-13.2 1-3.7-1.3-7.6-5-8.6zM374.8 453c-1.8-2.6-6.7-10.1-5.3-15.4.6-2.2 2.8-3.5 5-2.9 1.5.4 2.7 1.7 2.9 3.2.1.6.5 1 1.1 1.2.6.2 1.2 0 1.5-.5 1-1.2 2.6-1.7 4.2-1.3 2.2.6 3.5 2.8 2.9 5-1.5 5.4-9.4 9.4-12.3 10.7z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E";
			break;

			case 'hot_wing':
				$out = "data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 500 500' fill-opacity='1' style='enable-background:new 0 0 500 500'%3E%3Cstyle%3E .st2{fill:" . urlencode( $color ) . "} %3C/style%3E%3Cg style='display:none'%3E%3Cpath style='display:inline;' d='M-10-12h522v522H-10z' id='Layer_1'/%3E%3C/g%3E%3Cg id='Layer_2'%3E%3Cpath class='st2' d='M113.3 136c-2.6-4.6-5.1-8.9-3.3-13.7.5-1.5 1.6-2.5 2.9-3.8 1.5-1.4 3.1-3 3.9-5.3.9-2.7.5-5.8.2-8.5-.2-1.5-.4-3-.4-4.2 0-.7.1-1.3.1-2 .2-4.5.5-9.1-1-13-1.6-4.2-5-6.8-10.1-7.5-1-7-11.9-10.6-15.5-11.6-6.5-1.8-8.6-.7-13.6 1.9l-.8.4c-5.5 2.1-11.6 13.9-11.4 18.8.1 2.9 1.6 5.3 3.1 7.6 1 1.6 2 3.1 2.4 4.7.2.7.1 1.4 0 2.1-.2 1.2-.4 2.8.5 4.7.8 1.7 2.6 2.9 4.2 4.1.7.5 1.3.9 1.7 1.3.3.3.9 1.1 1.4 1.7.7.8 1.1 1.3 1.5 1.7 1.5 1.4 3.2 2.5 4.9 3.6 1.3.9 2.6 1.7 3.7 2.6 2.3 2 2.6 3.3 3 5.7.3 1.4.6 3.2 1.4 5.4.5 1.3 1 2.3 1.5 3 .7 1.3 1.1 2 1.2 4.3-.3 1.2-1.7 6.2-2.1 7.2-.3.5-.3 1.1-.1 1.6 1.7 4.7 5.1 4.8 7.6 4.9 1.1 0 2.2.1 3.1.5.8.4 1.6 1 2.3 1.7 1.1 1 2.4 2.1 4.1 2.1.2 0 .4 0 .7-.1 1.9-.3 3.5-1.9 5.5-5.4.4-.6.6-1.3.9-1.9.1-.2.2-.4.2-.6 1.5-4.9-1.3-9.7-3.7-14zM51.2 88c-2.7-.6-5.4-1.1-8.1-1.7-1.9-.4-2.7 2.5-.8 2.9 2.7.6 5.4 1.1 8.1 1.7 1.9.3 2.7-2.6.8-2.9zM55.2 56.8c-.8-1.8-3.4-.2-2.6 1.5 1.8 4 4 7.6 6.8 11 1.2 1.5 3.3-.6 2.1-2.1-2.5-3.2-4.6-6.6-6.3-10.4zM82.8 50.9c-.7.2-1.3 1.1-1 1.8.1.2.1.4.2.5v.1c-.5.4-.8 1-.6 1.6.2.8 1.1 1.3 1.8 1 1.8-.5 2.1-2.6 1.5-4.1-.3-.6-1-1.1-1.9-.9zm-.9 2.8v-.2.2zM105.8 52.2c-2.7 3.3-4.6 7.1-5.3 11.4-.3 1.9 2.6 2.7 2.9.8.6-3.7 2.1-7.1 4.5-10.1 1.3-1.5-.8-3.6-2.1-2.1zM122.1 72.8c-.4-.7-1.3-.9-2.1-.5l-1.8.9c-.7.4-.9 1.4-.5 2.1.4.7 1.3.9 2.1.5l1.8-.9c.7-.4.9-1.4.5-2.1zM57.6 111.5c-1 .5-2.1 1.1-3.1 1.6-.7.4-.9 1.4-.5 2.1.4.7 1.3.9 2.1.5 1-.5 2.1-1.1 3.1-1.6.7-.4.9-1.4.5-2.1-.5-.7-1.4-.9-2.1-.5zM390.2 383.2c-.9-2.9-1.8-5.8-2.6-8.7-.6-1.8-3.5-1.1-2.9.8.9 2.9 1.8 5.8 2.6 8.7.6 1.9 3.5 1.1 2.9-.8zM424.9 390.8c1.8-.6 2.5-3 3.2-4.5.7-1.8 1.4-3.6 1.9-5.4.5-1.9-2.4-2.7-2.9-.8-.4 1.3-.8 2.7-1.3 4-.3.9-.6 1.7-1 2.6-.2.4-.4.7-.6 1.1-.1.3-.6.4 0 .2-1.9.5-1.1 3.4.7 2.8zM441.3 402.1c1.1-.8 2.3-1.7 3.4-2.5.7-.5 1-1.3.5-2.1-.4-.6-1.4-1-2.1-.5-1.1.8-2.3 1.7-3.4 2.5-.7.5-1 1.3-.5 2.1.4.6 1.4 1 2.1.5zM370.8 414.8c-1.8-2.6-4.7-3.7-7.8-3.2-1.9.3-1.1 3.2.8 2.9 1.7-.3 3.4.4 4.4 1.8 1.1 1.6 3.7.1 2.6-1.5zM457.7 427.7c2.2-.7 4.4-1.4 6.7-2 1.8-.6 1.1-3.5-.8-2.9-2.2.7-4.4 1.4-6.7 2-1.8.6-1 3.5.8 2.9zM371.7 396.6c-3.1-2.5-6.2-4.9-9.3-7.4-1.5-1.2-3.6.9-2.1 2.1 3.1 2.5 6.2 4.9 9.3 7.4 1.5 1.2 3.6-.9 2.1-2.1zM219.3 205.6c-.4-.7-1.2-1.2-2-1.1-.8.1-1.5.7-1.7 1.5 0 .2-1.3 4.4-8.7 7.6-4 1.7-6.4 3.9-7.2 6.4-.8 2.6.4 4.5.5 4.6l53.1 88.2c.2.4 1.4 2.3 3.8 2.9.5.1.9.2 1.4.2 1.4 0 2.8-.5 4.3-1.4 1.7-1.1 2.9-2.4 3.9-3.8v-.1c2-2.8 2.6-5.4 2.6-5.6.1-.5 0-.9-.2-1.4l-49.8-98zm41.2 105.6c-1 .6-1.8.9-2.5.7-.8-.2-1.3-1-1.3-1v-.1l-53.1-88.2c0-.1-.4-.7-.1-1.5.2-.7 1.1-2 4-3.5l18.5 32.1c.4.6 1 1 1.7 1 .3 0 .7-.1 1-.3 1-.6 1.3-1.8.7-2.7l-18.3-31.8c3.1-1.7 5-3.6 6.3-5.2l47.8 94.1c0 .1-.1.3-.2.5L246.8 272c-.5-1-1.7-1.3-2.7-.8-1 .5-1.3 1.7-.8 2.7l19.4 35.3c-.7.8-1.3 1.4-2.2 2zM322 132.2c-.5-.6-1.4-.8-2.2-.6-.2.1-4.3 1.5-11.2-2.8-3.7-2.3-6.8-3-9.4-2.2-2.6.8-3.5 2.9-3.5 3.1l-42 94c-.2.4-1.1 2.5-.2 4.8.7 1.7 2.1 3.1 4.3 3.9 1.9.8 3.9 1 5.6 1 3.3 0 5.8-1 5.9-1 .4-.2.8-.5 1-.9l52-97c.4-.8.2-1.7-.3-2.3zm-54.9 96.6c-1 .3-3.1.7-5.4.4l15.1-33.5c.5-1 0-2.2-1-2.6-1-.5-2.2 0-2.6 1l-15.3 33.7c-.3-.3-.6-.6-.7-.9-.3-.8 0-1.6.1-1.7v-.1l42-94c0-.1.3-.7 1.2-.9.7-.2 2.3-.3 5.1 1.3L289.9 165c-.5 1 0 2.2 1 2.7.3.1.6.2.8.2.8 0 1.5-.4 1.8-1.2l15.6-33.2c3.1 1.5 5.8 2.1 7.8 2.2l-49.8 93.1zM246 122c.2.4 1.2 2.4 3.6 3.2.6.2 1.2.3 1.9.3 1.2 0 2.5-.4 3.9-1.1 5.4-2.9 7.2-8.6 7.3-8.9.1-.4.1-.9-.1-1.4l-42-101.7c-.3-.8-1.1-1.2-1.9-1.2-.8 0-1.6.6-1.8 1.3-.1.2-1.6 4.3-9.3 6.9-4.1 1.4-6.7 3.3-7.6 5.8-1 2.5.1 4.5.1 4.7L246 122zm-42.3-95.4c.3-.7 1.2-1.9 4.3-3.1l15.9 33.4c.3.7 1.1 1.1 1.8 1.1.3 0 .6-.1.9-.2 1-.5 1.4-1.7.9-2.7L211.7 22c3.2-1.5 5.3-3.2 6.6-4.7l40.2 97.6c-.4 1-1.4 2.9-3.1 4.5l-16.2-32.9c-.5-1-1.7-1.4-2.7-.9-1 .5-1.4 1.7-.9 2.7l16.4 33.2c-.4.1-.8.1-1.1 0-.8-.3-1.2-1.1-1.2-1.1v-.1l-45.9-92.2c-.2-.1-.5-.7-.1-1.5zM407.5 299H405v-2.5c0-1.1-.9-2-2-2s-2 .9-2 2v2.5h-2.5c-1.1 0-2 .9-2 2s.9 2 2 2h2.5v2.5c0 1.1.9 2 2 2s2-.9 2-2V303h2.5c1.1 0 2-.9 2-2s-.9-2-2-2zM120.7 210.7l2.7-2.7c.8-.8.8-2 0-2.8-.8-.8-2-.8-2.8 0l-2.7 2.7-2.7-2.7c-.8-.8-2-.8-2.8 0-.8.8-.8 2 0 2.8l2.7 2.7-2.7 2.7c-.8.8-.8 2 0 2.8.4.4.9.6 1.4.6s1-.2 1.4-.6l2.7-2.7 2.7 2.7c.4.4.9.6 1.4.6s1-.2 1.4-.6c.8-.8.8-2 0-2.8l-2.7-2.7zM449.6 471.6c0-.1-3.1-14.1-4.8-23.1-1.3-7.2-1.4-11.7-1.4-13.1.9-1.8 4-8.2 3.1-14.2-.3-1.8-.3-3.2-.4-4.4-.2-3.1-.3-5.8-3.9-7.3-1.5-.6-2.9-1.2-4.2-1.6-1.5-.6-2.9-1.1-4-1.6-.6-.3-2-1-11.5 2.3l-.2.2c-.2.1-6.4 4.3-14.4 14.3-.4.5-1.9-1.6 10-13 .3-2.9-.6-6.7-.8-8.3-.5-3.1-4.9-6.6-6.2-7.6l-.6-.3c-4.9-1.5-16.8-4.4-20.3-.6-3.3 3.6-6.2 12.2-6.3 16.7 0 2 .1 6.4.3 10.9.2 4.5.3 9.3.3 12.6 0 2.5-.3 6.1-.7 9.5-.8 8.3-1.1 12.2.2 14 1.5 2.1 2.6 3.1 4.5 4.9.4.4.9.8 1.5 1.3 4.4 4.1 16.9-.9 25.3-7.8 4.6-3.8 9.1-7.9 12.4-11-.2-.7-.1-2 .4-4.9.7-4.4-.2-5.9-.2-5.9.2-.1.5-.1.8.2.8.6.9 2.6.3 5.9l-.1 3.6c.2 1.9.6 4.2 1.5 6.8l.9-1.5c.1-.3.5-.4.8-.3.3.1.4.5.3.8l-1.4 2.3c.3.7.6 1.3.9 2l1.1-2.3c.1-.3.5-.4.8-.3.3.1.4.5.3.8l-1.5 3c0 .1.1.1.1.2.3.5.6 1 .9 1.4l.5-1.1c.1-.3.5-.4.8-.3.3.1.4.5.3.8l-.8 1.7c2.6 3.9 4.6 6 6 7.5.7.8 1.3 1.3 1.6 1.8 1.3 2.1 4.1 6.3 4.2 6.5.4.6 1 .9 1.7.9.3 0 .5-.1.8-.2.8-.4 1.3-1.3 1.1-2.2z'/%3E%3Cg%3E%3Cpath class='st2' d='M124.4 419.2c-.4-.4-.9-.7-1.5-.7H121c.1-1.2.1-2.7-.6-4.1-3.9-7.8-10.3-14.1-17.2-16.9-4.7-1.9-7.1.1-8.3 2.1-2.8 4.5-8.2 7.1-13.4 9.7-2.3 1.1-4.4 2.1-6.3 3.3-2.1 1.3-3.1 2.3-3.3 5.3 0 .2 0 .4.1.6h-3.2c-.6 0-1.1.3-1.5.7s-.5 1-.5 1.6l4.3 27.5c.2 1 1 1.7 2 1.7h45.5c1 0 1.8-.7 2-1.7l4.3-27.5c.1-.6-.1-1.2-.5-1.6zM76 418.1c0-1.3 0-1.3 1.4-2.1 1.7-1.1 3.7-2.1 5.9-3.1 5.4-2.7 11.6-5.7 15-11.1.5-.8 1.1-1.4 3.5-.5 6 2.4 11.6 8 15.1 15 .3.5.2 1.4.2 2.3H75.9c.1-.2.1-.4.1-.5zm40.9 27.9H91v-.2l-1-9c-.1-1.1-1.1-1.9-2.2-1.8-1.1.1-1.9 1.1-1.8 2.2l1 8.8h-4.1L81 430.8c-.1-1.1-1.1-1.9-2.2-1.7-1.1.1-1.9 1.1-1.7 2.2l1.8 14.8h-4l-3.6-23.5h49.3l-3.7 23.4z'/%3E%3Ccircle class='st2' cx='98' cy='414' r='2'/%3E%3Ccircle class='st2' cx='104.5' cy='408.5' r='2.5'/%3E%3C/g%3E%3Cpath class='st2' d='M394.2 176c.6-3.2 1.2-6.1 3.9-7.7.8-.5 1.8-.5 2.9-.6 1.2-.1 2.6-.2 4-.9 1.5-.9 2.5-2.5 3.5-3.9.5-.8 1-1.6 1.5-2.1.3-.3.6-.6.8-.9 1.9-2 3.9-4.1 4.7-6.5.9-2.6.3-5.1-1.8-7.5 2.3-3.7-1.4-9.7-2.6-11.6-2.3-3.4-3.7-3.8-7.1-4.5l-.6-.1c-3.4-1.2-10.9 1.9-12.8 4.3-1.1 1.4-1.4 3.1-1.6 4.8-.2 1.2-.3 2.3-.8 3.2-.2.4-.5.7-.9 1-.6.5-1.3 1.1-1.6 2.4-.3 1.1.1 2.4.4 3.6.1.5.3 1 .3 1.3v2.7c.2 1.3.5 2.5.8 3.6.3.9.5 1.8.7 2.7.3 1.9-.1 2.6-.9 3.9-.4.8-1 1.7-1.5 3.1-.3.8-.4 1.5-.5 2-.2.9-.3 1.4-1.2 2.5-.6.4-3.2 2.2-3.8 2.6-.3.1-.6.4-.7.7-1.1 2.9.5 4.3 1.6 5.3.5.5 1 .9 1.3 1.5.2.5.3 1.1.4 1.7.1.9.3 1.9 1.1 2.6.1.1.2.2.3.2 1 .6 2.4.5 4.7-.3.4-.1.8-.3 1.2-.5.1 0 .2-.1.3-.2 2.8-2.1 3.4-5.4 4-8.4zM438.5 49.6l3.2-5.4c.9-1.6.4-3.6-1.1-4.5-1.6-.9-3.6-.4-4.5 1.1l-3.2 5.4-5.4-3.2c-1.6-.9-3.6-.4-4.5 1.1-.9 1.6-.4 3.6 1.1 4.5l5.4 3.2-3.2 5.4c-.9 1.6-.4 3.6 1.1 4.5.8.5 1.7.6 2.5.4.8-.2 1.6-.7 2-1.5l3.2-5.4 5.4 3.2c.8.5 1.7.6 2.5.4.8-.2 1.6-.7 2-1.5.9-1.6.4-3.6-1.1-4.5l-5.4-3.2zM169 378.4l-2 .8-.8-2c-.3-.9-1.3-1.3-2.2-1-.9.3-1.3 1.3-1 2.2l.8 2-2 .8c-.9.3-1.3 1.3-1 2.2.3.9 1.3 1.3 2.2 1l2-.8.8 2c.3.9 1.3 1.3 2.2 1s1.3-1.3 1-2.2l-.8-2 2-.8c.9-.3 1.3-1.3 1-2.2-.3-.9-1.3-1.3-2.2-1z'/%3E%3C/g%3E%3C/svg%3E";
			break;

			case 'sprinkles':
				$out = "data:image/svg+xml,%3Csvg id='Layer_1' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 500 500' fill-opacity='1' %3E%3Cstyle%3E .st0{fill:" . urlencode( $color ) . "} %3C/style%3E%3Cpath class='st0' d='M55.5 475h-19c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h19c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM144.7 178.9c-.4 0-.8-.1-1.2-.2-1.8-.7-2.7-2.7-2.1-4.5l6.6-17.8c.7-1.8 2.7-2.7 4.5-2.1 1.8.7 2.7 2.7 2.1 4.5l-6.6 17.8c-.6 1.4-1.9 2.3-3.3 2.3zM107.9 130.4c-1 0-2.1-.5-2.7-1.3l-11.8-14.9c-1.2-1.5-.9-3.7.6-4.9 1.5-1.2 3.7-.9 4.9.6l11.8 14.9c1.2 1.5.9 3.7-.6 4.9-.7.5-1.4.7-2.2.7zM103.2 87.6c-1.5 0-2.8-.9-3.3-2.4-.6-1.8.3-3.8 2.2-4.4l6.6-2.3c1.8-.6 3.8.3 4.4 2.2.6 1.8-.3 3.8-2.2 4.4l-6.6 2.3c-.3.2-.7.2-1.1.2zM300.5 46c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-5l15-15c1.4-1.4 3.6-1.4 4.9 0 1.4 1.4 1.4 3.6 0 5l-15 15c-.6.7-1.5 1-2.4 1zM193.5 292c-1.9 0-3.5-1.6-3.5-3.5v-9c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v9c0 1.9-1.6 3.5-3.5 3.5zM163.5 40c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-5l17.5-17.5c1.4-1.4 3.6-1.4 5 0s1.4 3.6 0 5L166 39c-.7.7-1.6 1-2.5 1zM252.5 167h-12c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h12c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM199 142.5c-.9 0-1.8-.3-2.5-1L186 131c-1.4-1.4-1.4-3.6 0-5s3.6-1.4 5 0l10.5 10.5c1.4 1.4 1.4 3.6 0 5-.7.7-1.6 1-2.5 1zM108.5 162h-31c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h31c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM134.5 231c-1.9 0-3.5-1.6-3.5-3.5v-16c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v16c0 1.9-1.6 3.5-3.5 3.5zM136.5 86c-1.9 0-3.5-1.6-3.5-3.5v-23c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v23c0 1.9-1.6 3.5-3.5 3.5zM63.5 64h-21c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h21c1.9 0 3.5 1.6 3.5 3.5S65.4 64 63.5 64zM70.5 124c-.9 0-1.8-.3-2.5-1l-9-9c-1.4-1.4-1.4-3.6 0-5s3.6-1.4 5 0l9 9c1.4 1.4 1.4 3.6 0 5-.7.7-1.6 1-2.5 1zM97.5 200c-1.9 0-3.5-1.6-3.5-3.5v-8c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v8c0 1.9-1.6 3.5-3.5 3.5zM256.5 129h-15c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h15c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM172.5 102c-1.9 0-3.5-1.6-3.5-3.5v-9c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v9c0 1.9-1.6 3.5-3.5 3.5zM275.5 214c-.9 0-1.8-.3-2.5-1l-9-9c-1.4-1.4-1.4-3.6 0-5s3.6-1.4 4.9 0l9 9c1.4 1.4 1.4 3.6 0 5-.6.7-1.5 1-2.4 1zM104.5 262c-1.9 0-3.5-1.6-3.5-3.5v-17c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v17c0 1.9-1.6 3.5-3.5 3.5zM53.5 278c-1.1 0-2.1-.5-2.8-1.4-1.2-1.5-.8-3.7.7-4.9l12-9c1.5-1.2 3.7-.8 4.9.7 1.2 1.5.8 3.7-.7 4.9l-12 9c-.6.5-1.4.7-2.1.7zM173.5 264c-.6 0-1.1-.1-1.7-.4l-13-7c-1.7-.9-2.3-3-1.4-4.7.9-1.7 3-2.3 4.7-1.4l13 7c1.7.9 2.3 3 1.4 4.7-.6 1.1-1.8 1.8-3 1.8zM203.5 182h-26c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h26c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM84.5 61c-1.9 0-3.5-1.6-3.5-3.5v-22c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v22c0 1.9-1.6 3.5-3.5 3.5zM196.5 82c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-5l15-15c1.4-1.4 3.6-1.4 5 0s1.4 3.6 0 5l-15 15c-.7.7-1.6 1-2.5 1zM196.5 236c-.9 0-1.8-.3-2.5-1l-13-13c-1.4-1.4-1.4-3.6 0-5s3.6-1.4 5 0l13 13c1.4 1.4 1.4 3.6 0 5-.7.7-1.6 1-2.5 1zM37.5 151c-1.1 0-2.2-.5-2.9-1.6-1.1-1.6-.6-3.8 1-4.9l9-6c1.6-1.1 3.8-.6 4.9 1 1.1 1.6.6 3.8-1 4.9l-9 6c-.7.4-1.3.6-2 .6zM30.5 107h-5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h5c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM121.5 42h-6c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h6c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM123.5 345c-1.2 0-2.3-.6-3-1.6l-7-11c-1-1.6-.6-3.8 1.1-4.8 1.6-1 3.8-.6 4.8 1.1l7 11c1 1.6.6 3.8-1.1 4.8-.5.3-1.2.5-1.8.5zM31.5 353c-.2 0-.5 0-.7-.1-1.9-.4-3.1-2.3-2.7-4.2l3-14c.4-1.9 2.3-3.1 4.2-2.7 1.9.4 3.1 2.3 2.7 4.2l-3 14c-.4 1.7-1.9 2.8-3.5 2.8zM72.5 318c-.6 0-1.1-.1-1.6-.4l-17-9c-1.7-.9-2.4-3-1.5-4.7.9-1.7 3-2.4 4.7-1.5l17 9c1.7.9 2.4 3 1.5 4.7-.6 1.2-1.8 1.9-3.1 1.9zM256.5 380h-19c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h19c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM299.2 353.3c-.2 0-.4 0-.7-.1-1.9-.4-3.1-2.2-2.8-4.1l3.6-18.7c.4-1.9 2.2-3.1 4.1-2.8 1.9.4 3.1 2.2 2.8 4.1l-3.6 18.7c-.3 1.8-1.7 2.9-3.4 2.9zM328 295c-.4 0-.7-.1-1.1-.2l-18-5.9c-1.8-.6-2.8-2.6-2.2-4.4.6-1.8 2.6-2.8 4.4-2.2l18 5.9c1.8.6 2.8 2.6 2.2 4.4-.4 1.4-1.8 2.4-3.3 2.4zM345.2 267.6c-1.5 0-2.8-.9-3.3-2.4-.6-1.8.3-3.8 2.2-4.4l6.6-2.3c1.8-.6 3.8.3 4.4 2.2.6 1.8-.3 3.8-2.2 4.4l-6.6 2.3c-.4.2-.7.2-1.1.2zM396 381.5c-.9 0-1.8-.3-2.5-1L376 363c-1.4-1.4-1.4-3.6 0-4.9 1.4-1.4 3.6-1.4 4.9 0l17.5 17.5c1.4 1.4 1.4 3.6 0 4.9-.6.7-1.5 1-2.4 1zM350.5 422c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-4.9l15-15c1.4-1.4 3.6-1.4 4.9 0 1.4 1.4 1.4 3.6 0 4.9l-15 15c-.6.7-1.5 1-2.4 1zM417.3 460.2c-1.4 0-2.7-.8-3.2-2.2-.7-1.8.1-3.8 1.9-4.6l8.3-3.4c1.8-.7 3.8.1 4.6 1.9.7 1.8-.1 3.8-1.9 4.6l-8.3 3.4c-.5.2-.9.3-1.4.3zM329.5 464c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-4.9l17.5-17.5c1.4-1.4 3.6-1.4 4.9 0 1.4 1.4 1.4 3.6 0 4.9L332 463c-.7.7-1.6 1-2.5 1zM486.5 401h-12c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h12c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM399 442.5c-.9 0-1.8-.3-2.5-1L386 431c-1.4-1.4-1.4-3.6 0-4.9 1.4-1.4 3.6-1.4 4.9 0l10.5 10.5c1.4 1.4 1.4 3.6 0 4.9-.6.7-1.5 1-2.4 1zM314.5 405h-31c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h31c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM338.5 375c-1.9 0-3.5-1.6-3.5-3.5v-23c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v23c0 1.9-1.6 3.5-3.5 3.5zM454.5 382h-15c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h15c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM426.5 414c-1.9 0-3.5-1.6-3.5-3.5v-9c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v9c0 1.9-1.6 3.5-3.5 3.5zM402.5 325c-.9 0-1.8-.3-2.5-1-1.4-1.4-1.4-3.6 0-4.9l15-15c1.4-1.4 3.6-1.4 4.9 0 1.4 1.4 1.4 3.6 0 4.9l-15 15c-.6.7-1.5 1-2.4 1zM423.5 257c-1.2 0-2.3-.6-3-1.6l-7-11c-1-1.6-.6-3.8 1.1-4.8 1.6-1 3.8-.6 4.8 1.1l7 11c1 1.6.6 3.8-1.1 4.8-.5.3-1.2.5-1.8.5zM413.5 198c-.6 0-1.1-.1-1.6-.4l-17-9c-1.7-.9-2.4-3-1.5-4.7.9-1.7 3-2.4 4.7-1.5l17 9c1.7.9 2.4 3 1.5 4.7-.6 1.2-1.8 1.9-3.1 1.9zM220.5 344c-1.6 0-3-1.1-3.4-2.7l-9-36c-.5-1.9.7-3.8 2.5-4.2 1.9-.5 3.8.7 4.2 2.5l9 36c.5 1.9-.7 3.8-2.5 4.2-.2.2-.5.2-.8.2zM276.5 281.5c-2.5 0-4.6-1.9-4.9-4.3l-3-22c-.2-1.3.2-2.6 1-3.7s2-1.7 3.3-1.9c1.3-.2 2.6.2 3.7 1s1.8 2 1.9 3.3l3 22c.2 1.3-.2 2.6-1 3.7s-2 1.7-3.3 1.9h-.7zm-3-29h-.3c-.5.1-1 .3-1.3.8-.3.4-.5 1-.4 1.5l3 22c.1 1.1 1.1 1.9 2.2 1.7.5-.1 1-.3 1.3-.8.3-.4.5-1 .4-1.5l-3-22c-.1-.5-.3-1-.8-1.3-.2-.3-.7-.4-1.1-.4zM139.5 297h-.3l-21-2c-1.9-.2-3.3-1.9-3.2-3.8.2-1.9 1.9-3.3 3.8-3.2l21 2c1.9.2 3.3 1.9 3.2 3.8-.2 1.8-1.7 3.2-3.5 3.2zM289.5 168c-.3 0-.6 0-1-.1l-7-2c-1.9-.5-2.9-2.5-2.4-4.3.5-1.9 2.5-2.9 4.3-2.4l7 2c1.9.5 2.9 2.5 2.4 4.3-.4 1.5-1.8 2.5-3.3 2.5zM89.5 400H89c-1.9-.3-3.2-2.1-2.9-4l4-26c.3-1.9 2.1-3.2 4-2.9 1.9.3 3.2 2.1 2.9 4l-4 26c-.3 1.7-1.8 2.9-3.5 2.9zM163.5 400c-.5 0-1-.1-1.5-.3-1.8-.8-2.5-2.9-1.7-4.7l7-15c.8-1.8 2.9-2.5 4.7-1.7 1.8.8 2.5 2.9 1.7 4.7l-7 15c-.6 1.3-1.9 2-3.2 2zM221.5 263c-1.7 0-3.2-1.2-3.5-3-.3-1.9 1-3.7 2.9-4l13-2c1.9-.3 3.7 1 4 2.9s-1 3.7-2.9 4l-13 2c-.1.1-.3.1-.5.1zM174.5 341c-.4 0-.7-.1-1.1-.2l-15-5c-1.8-.6-2.8-2.6-2.2-4.4.6-1.8 2.6-2.8 4.4-2.2l15 5c1.8.6 2.8 2.6 2.2 4.4-.5 1.5-1.8 2.4-3.3 2.4zM260.5 320c-1 0-1.9-.4-2.6-1.2-1.3-1.5-1.1-3.7.3-4.9l8-7c1.5-1.3 3.7-1.1 4.9.3 1.3 1.5 1.1 3.7-.3 4.9l-8 7c-.7.6-1.5.9-2.3.9zM217.5 384c-1 0-2-.4-2.7-1.3l-5-6c-1.2-1.5-1-3.7.4-4.9 1.5-1.2 3.7-1 4.9.4l5 6c1.2 1.5 1 3.7-.4 4.9-.6.6-1.4.9-2.2.9zM55.5 423c-.7 0-1.3-.2-1.9-.6l-18-12c-1.6-1.1-2-3.2-1-4.9 1.1-1.6 3.2-2 4.9-1l18 12c1.6 1.1 2 3.2 1 4.9-.8 1.1-1.9 1.6-3 1.6zM53.5 36c-1 0-2.1-.5-2.8-1.4l-7-9c-1.2-1.5-.9-3.7.6-4.9 1.5-1.2 3.7-.9 4.9.6l7 9c1.2 1.5.9 3.7-.6 4.9-.6.6-1.3.8-2.1.8zM303.5 133c-1.8 0-3.4-1.4-3.5-3.3l-1-17c-.1-1.9 1.4-3.6 3.3-3.7 1.9-.1 3.6 1.4 3.7 3.3l1 17c.1 1.9-1.4 3.6-3.3 3.7h-.2zM319.5 184c-1.6 0-3-1.1-3.4-2.7-.5-1.9.7-3.8 2.5-4.2l28-7c1.9-.5 3.8.7 4.2 2.5.5 1.9-.7 3.8-2.5 4.2l-28 7c-.2.2-.5.2-.8.2zM431.5 72c-1.7 0-3.1-1.2-3.4-2.9l-4-22c-.3-1.9.9-3.7 2.8-4.1 1.9-.3 3.7.9 4.1 2.8l4 22c.3 1.9-.9 3.7-2.8 4.1-.3.1-.5.1-.7.1zM354.5 232c-1.3 0-2.5-.7-3.1-1.9l-11-21c-.9-1.7-.2-3.8 1.5-4.7 1.7-.9 3.8-.2 4.7 1.5l11 21c.9 1.7.2 3.8-1.5 4.7-.5.3-1.1.4-1.6.4zM339.5 139c-.6 0-1.2-.2-1.8-.5-1.7-1-2.2-3.1-1.2-4.8l9-15c1-1.7 3.1-2.2 4.8-1.2 1.7 1 2.2 3.1 1.2 4.8l-9 15c-.7 1.1-1.8 1.7-3 1.7zM338.5 79c-.5 0-1-.1-1.5-.3l-13-6c-1.8-.8-2.5-2.9-1.7-4.6.8-1.8 2.9-2.5 4.6-1.7l13 6c1.8.8 2.5 2.9 1.7 4.6-.5 1.2-1.8 2-3.1 2zM223.5 100h-7c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h7c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM312.5 233c-1.9 0-3.5-1.6-3.5-3.5v-8c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v8c0 1.9-1.6 3.5-3.5 3.5zM402.2 160.3c-.3 0-.6 0-.8-.1-2.7-.4-4.6-3-4.1-5.7l4.6-27.7c.5-2.7 3-4.6 5.8-4.1 2.6.4 4.4 2.8 4.2 5.4v.4l-4.6 27.7c-.2 1.3-.9 2.5-2 3.2-1.1.6-2.1.9-3.1.9zm4.6-34.6c-1 0-1.8.7-2 1.7l-4.6 27.7c-.2 1.1.6 2.1 1.6 2.3.5.1 1.1 0 1.5-.3s.7-.8.8-1.3l4.6-27.7v-.1c.1-1-.6-2-1.7-2.2 0-.1-.1-.1-.2-.1zM379.5 102c-1.7 0-3.2-1.3-3.5-3l-2-14c-.3-1.9 1.1-3.7 3-4 1.9-.3 3.7 1.1 4 3l2 14c.3 1.9-1.1 3.7-3 4h-.5zM101.5 454c-.5 0-1.1-.1-1.6-.4l-8-4c-1.7-.9-2.4-3-1.6-4.7.9-1.7 3-2.4 4.7-1.6l8 4c1.7.9 2.4 3 1.6 4.7-.6 1.3-1.8 2-3.1 2zM474.5 136c-1.6 0-3-1.1-3.4-2.7l-3-12c-.5-1.9.7-3.8 2.5-4.2 1.9-.5 3.8.7 4.2 2.5l3 12c.5 1.9-.7 3.8-2.5 4.2-.2.2-.5.2-.8.2zM480.5 508c-1.1 0-2.2-.5-2.9-1.5l-7-10c-1.1-1.6-.7-3.8.9-4.9 1.6-1.1 3.8-.7 4.9.9l7 10c1.1 1.6.7 3.8-.9 4.9-.6.4-1.3.6-2 .6zM145 475.5c-1.9 0-3.5-1.6-3.5-3.5v-21.1c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5V472c0 2-1.6 3.5-3.5 3.5zM380.5 302c-.6 0-1.1-.1-1.7-.4l-13-7c-1.7-.9-2.3-3-1.4-4.7.9-1.7 3-2.3 4.7-1.4l13 7c1.7.9 2.3 3 1.4 4.7-.6 1.1-1.8 1.8-3 1.8zM362.4 343.9c-1.8 0-3.4-1.4-3.5-3.3l-.8-14.7c-.1-1.9 1.4-3.6 3.3-3.7 1.9-.1 3.6 1.4 3.7 3.3l.8 14.7c.1 1.9-1.4 3.6-3.3 3.7h-.2zM223.5 224c-1.9 0-3.5-1.6-3.5-3.5v-9c0-1.9 1.6-3.5 3.5-3.5s3.5 1.6 3.5 3.5v9c0 1.9-1.6 3.5-3.5 3.5zM380.5 481c-1.2 0-2.3-.6-3-1.6l-7-11c-1-1.6-.6-3.8 1.1-4.8 1.6-1 3.8-.6 4.8 1.1l7 11c1 1.6.6 3.8-1.1 4.8-.5.3-1.2.5-1.8.5zM390.5 26h-12c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5h12c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5zM434.4 111.1c-.6 0-1.2-.2-1.8-.5-1.7-1-2.2-3.2-1.2-4.8l6.2-10.3c1-1.7 3.2-2.2 4.8-1.2 1.7 1 2.2 3.2 1.2 4.8l-6.2 10.3c-.7 1.1-1.8 1.7-3 1.7zM113.5 424.5c-2.3 0-4.3-1.6-4.8-3.8-.3-1.3-.1-2.6.6-3.8.7-1.1 1.8-2 3.1-2.3l28-7c1.3-.3 2.6-.1 3.8.6 1.1.7 2 1.8 2.3 3.1.3 1.3.1 2.6-.6 3.8-.7 1.1-1.8 2-3.1 2.3l-28 7c-.5.1-.9.1-1.3.1zm28-14c-.2 0-.3 0-.5.1l-28 7c-.5.1-1 .5-1.2.9s-.4 1-.2 1.5c.3 1.1 1.4 1.7 2.4 1.5l28-7c.5-.1 1-.5 1.2-.9s.4-1 .2-1.5c-.1-.5-.5-1-.9-1.2-.3-.3-.6-.4-1-.4zM513.5 33.5h-31c-2.8 0-5-2.2-5-5s2.2-5 5-5h31c2.8 0 5 2.2 5 5s-2.2 5-5 5zm-31-7c-1.1 0-2 .9-2 2s.9 2 2 2h31c1.1 0 2-.9 2-2s-.9-2-2-2h-31zM15.5 33.5h-31c-2.8 0-5-2.2-5-5s2.2-5 5-5h31c2.8 0 5 2.2 5 5s-2.2 5-5 5zm-31-7c-1.1 0-2 .9-2 2s.9 2 2 2h31c1.1 0 2-.9 2-2s-.9-2-2-2h-31zM160.5 129h-.7l-24.5-3.4c-1.3-.2-2.5-.9-3.3-1.9-.8-1.1-1.1-2.4-1-3.7.2-1.3.9-2.5 1.9-3.3 1.1-.8 2.4-1.1 3.7-1l24.5 3.4c1.3.2 2.5.9 3.3 1.9.8 1.1 1.1 2.4 1 3.7-.3 2.4-2.4 4.3-4.9 4.3zM136 118.5c-.4 0-.8.1-1.2.4-.4.3-.7.8-.8 1.3-.1.5.1 1.1.4 1.5.3.4.8.7 1.3.8l24.5 3.4c1.1.2 2.1-.6 2.3-1.7.1-.5-.1-1.1-.4-1.5-.3-.4-.8-.7-1.3-.8l-24.5-3.4h-.3zM105.5 14.8c-.6 0-1.2-.1-1.8-.3-1.2-.5-2.2-1.4-2.8-2.6s-.6-2.6-.1-3.8l7.9-20.5c.5-1.2 1.4-2.2 2.6-2.8 1.2-.5 2.6-.6 3.8-.1 2.6 1 3.9 3.9 2.9 6.5l-7.9 20.5c-.6 1.8-2.5 3.1-4.6 3.1zm8-27.6c-.3 0-.5.1-.8.2-.5.2-.9.6-1.1 1.1L103.7 9c-.2.5-.2 1 0 1.5s.6.9 1.1 1.1c1 .4 2.2-.2 2.6-1.1l7.9-20.5c.4-1-.1-2.2-1.1-2.6-.3-.1-.5-.2-.7-.2zM105.5 515.3c-.6 0-1.2-.1-1.8-.3-2.6-1-3.9-3.9-2.9-6.5l7.9-20.5c.5-1.2 1.4-2.2 2.6-2.8 1.2-.5 2.6-.6 3.8-.1 1.2.5 2.2 1.4 2.8 2.6.5 1.2.6 2.6.1 3.8l-7.9 20.5c-.6 2-2.5 3.3-4.6 3.3zm8-27.6c-.3 0-.5.1-.8.2-.5.2-.9.6-1.1 1.1l-7.9 20.5c-.4 1 .1 2.2 1.1 2.6 1 .4 2.2-.2 2.6-1.1l7.9-20.5c.2-.5.2-1 0-1.5s-.6-.9-1.1-1.1c-.3-.1-.5-.2-.7-.2zM480.5 8.5c-1.1 0-2.2-.5-2.9-1.5l-7-10c-1.1-1.6-.7-3.8.9-4.9 1.6-1.1 3.8-.7 4.9.9l7 10c1.1 1.6.7 3.8-.9 4.9-.6.4-1.3.6-2 .6zM200 435c-1.6 0-3.1-1-3.7-2.5l-4-10c-.8-2.1.2-4.4 2.2-5.2 2.1-.8 4.4.2 5.2 2.2l4 10c.8 2.1-.2 4.4-2.2 5.2-.5.2-1 .3-1.5.3zM233 461c-.9 0-1.9-.3-2.7-1-1.6-1.5-1.8-4-.3-5.6l17-19c1.5-1.6 4-1.8 5.6-.3 1.6 1.5 1.8 4 .3 5.6l-17 19c-.7.8-1.8 1.3-2.9 1.3zM296 512c-1.7 0-3.2-1-3.8-2.7l-7-20c-.7-2.1.4-4.4 2.5-5.1 2.1-.7 4.4.4 5.1 2.5l7 20c.7 2.1-.4 4.4-2.5 5.1-.4.1-.9.2-1.3.2zM296 14c-1.7 0-3.2-1-3.8-2.7l-7-20c-.7-2.1.4-4.4 2.5-5.1 2.1-.7 4.4.4 5.1 2.5l7 20c.7 2.1-.4 4.4-2.5 5.1-.4.1-.9.2-1.3.2zM11 270c-.8 0-1.6-.2-2.3-.7l-28-20c-1.8-1.3-2.2-3.8-.9-5.6 1.3-1.8 3.8-2.2 5.6-.9l28 20c1.8 1.3 2.2 3.8.9 5.6-.8 1-2.1 1.6-3.3 1.6zM512 270c-.8 0-1.6-.2-2.3-.7l-28-20c-1.8-1.3-2.2-3.8-.9-5.6 1.3-1.8 3.8-2.2 5.6-.9l28 20c1.8 1.3 2.2 3.8.9 5.6-.8 1-2.1 1.6-3.3 1.6zM41 211c-1.1 0-2.2-.5-3-1.3l-8-9c-1.5-1.7-1.3-4.2.3-5.6 1.7-1.5 4.2-1.3 5.6.3l8 9c1.5 1.7 1.3 4.2-.3 5.6-.7.7-1.7 1-2.6 1zM261 80c-2.1 0-3.9-1.7-4-3.8l-1-23c-.1-2.2 1.6-4.1 3.8-4.2 2.2-.1 4.1 1.6 4.2 3.8l1 23c.1 2.2-1.6 4.1-3.8 4.2h-.2zM209 39c-.5 0-1.1-.1-1.6-.3-2-.9-3-3.2-2.1-5.3l6-14c.9-2 3.2-3 5.3-2.1 2 .9 3 3.2 2.1 5.3l-6 14c-.7 1.5-2.2 2.4-3.7 2.4zM460 327c-.8 0-1.7-.3-2.4-.8-1.8-1.3-2.1-3.8-.8-5.6l12-16c1.3-1.8 3.8-2.1 5.6-.8 1.8 1.3 2.1 3.8.8 5.6l-12 16c-.8 1-2 1.6-3.2 1.6zM446 182c-1.6 0-3.1-1-3.7-2.6l-3-8c-.8-2.1.3-4.4 2.3-5.1 2.1-.8 4.4.3 5.1 2.3l3 8c.8 2.1-.3 4.4-2.3 5.1-.5.2-.9.3-1.4.3zM466 213c-.9 0-1.7-.3-2.5-.8-1.7-1.4-2.1-3.9-.7-5.6l7-9c1.4-1.7 3.9-2.1 5.6-.7 1.7 1.4 2.1 3.9.7 5.6l-7 9c-.7 1-1.9 1.5-3.1 1.5zM9 391c-1.3 0-2.6-.6-3.3-1.8-1.2-1.8-.7-4.3 1.1-5.5l12-8c1.8-1.2 4.3-.7 5.5 1.1 1.2 1.8.7 4.3-1.1 5.5l-12 8c-.7.5-1.4.7-2.2.7z'/%3E%3C/svg%3E";
			break;
			case 'toast':
				$out = "data:image/svg+xml;charset=utf8,%3C?xml%20version=%271.0%27%20encoding=%27utf-8%27?%3E%3Csvg%20version=%271.1%27%20id=%27Layer_1%27%20xmlns=%27http://www.w3.org/2000/svg%27%20xmlns:xlink=%27http://www.w3.org/1999/xlink%27%20x=%270px%27%20y=%270px%27%20viewBox=%270%200%20500%20500%27%20style=%27enable-background:new%200%200%20500%20500;%27%20xml:space=%27preserve%27%3E%3Cstyle%20type=%27text/css%27%3E%20.st0{fill:" . urlencode( $color ) . ";}%20%3C/style%3E%3Cpath%20class=%27st0%27%20d=%27M205.7,197.9c-4.7,0.6-8-0.6-8.7,1.1c-1,0.8,1.9,8.1,9.5,7.4c7.6-0.7,9-8.5,7.9-9.1%20C213.4,195.8,210.4,197.5,205.7,197.9z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M180.4,171.1c0.8,0.1,1.6-0.4,1.7-1.2c0.1-0.8-0.4-1.6-1.2-1.7c-2.2-0.4-4.5,0.2-6.3,1.5%20c-1.8,1.3-3.1,3.3-3.4,5.5c-0.1,0.8,0.4,1.6,1.2,1.7c0.1,0,0.2,0,0.2,0c0.7,0,1.4-0.5,1.5-1.3c0.1-0.6,0.3-1.2,0.6-1.8l3.8-2.7%20C179.2,171.1,179.8,171,180.4,171.1z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M227.9,163.6c-2.2-0.4-4.5,0.2-6.3,1.5c-0.7,0.5-0.8,1.4-0.3,2.1c0.5,0.7,1.4,0.8,2.1,0.3%20c0.5-0.4,1.1-0.6,1.7-0.8l4.6,0.8c0.5,0.3,1,0.8,1.3,1.3c0.3,0.4,0.8,0.6,1.2,0.6c0.3,0,0.6-0.1,0.9-0.3c0.7-0.5,0.8-1.4,0.3-2.1%20C232.1,165.2,230.2,164,227.9,163.6z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M213.5,289.2c-2.8,0-5,2.2-5,5v7.8c0,2.8,2.2,5,5,5s5-2.2,5-5v-7.8C218.5,291.4,216.3,289.2,213.5,289.2z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M197,239.2c-2.8,0-5,2.2-5,5v1.3c0,2.8,2.2,5,5,5s5-2.2,5-5v-1.3C202,241.4,199.8,239.2,197,239.2z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M324.3,193.9c-0.1,0-0.1,0-0.2-0.1l-0.2-0.1c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-24.3-6.8-42.3-3.3-51.9,2.5%20c-3,1.1-5.5,2.4-7.5,3.8c-0.9-10.3-2-20.6-3.5-32c3.7-1.8,6.8-4.8,5.9-14.2c-1.1-11.3-24.9-29.6-68.5-25.5c-0.1,0-0.1,0-0.2,0%20l-0.5,0c-0.1,0-0.1,0-0.2,0c-28.9,2.9-47.4,13.8-56.2,24.1c-12.3,10.2-14.5,20.4-14.2,23.9c0.9,9.8,4.9,10.7,8.5,11.4%20c1.7,28.9,4.4,50.8,9.6,79.4c1,5.4,6.3,9.4,11.6,8.9c9.5-0.9,25.5-2.5,35.4-3.4V284c0,2.8,2.2,5,5,5s5-2.2,5-5v-12.4%20c1.4-0.1,3.7-0.4,6.5-0.6V281c0,2.8,2.2,5,5,5s5-2.2,5-5v-11c8.9-0.9,19.2-1.9,26.1-2.5c0.4,0,0.8-0.1,1.3-0.2%20c-1.2,5.3-2.3,10.9-3.5,16.8c-0.8,4.4,2,9,6.2,10.2c7.5,2.1,20.2,5.7,28,8l-4.9,15.4c-0.7,2.4,0.6,4.9,2.9,5.6%20c0.4,0.1,0.9,0.2,1.4,0.2c1.9,0,3.7-1.2,4.3-3.2l4.9-15.7c1.3,0.4,3.2,0.9,5.4,1.5l-1.9,6.5c-0.7,2.4,0.6,4.9,3,5.6%20c0.4,0.1,0.9,0.2,1.3,0.2c1.9,0,3.7-1.3,4.3-3.2l2-6.6c6.6,1.9,13.8,3.9,18.7,5.3c3.1,0.9,9,0,12.4-2.3c0.1,0,0.3,0,0.4,0%20c4.4,0,8.7-2.8,10.3-7c8.6-22.7,13.8-39.4,19.1-61.2c3.3-0.3,6.7-1.9,8.8-9.3v0C371.7,225.1,358.9,203.9,324.3,193.9z%20M248.5,256.1%20l-30,2.9v-10.5c0-2.8-2.2-5-5-5s-5,2.2-5,5v11.4l-6.5,0.6V259c0-2.8-2.2-5-5-5s-5,2.2-5,5v2.5l-25.6,2.5c-4.3,0.4-8.6-2.9-9.4-7.3%20c-5.4-29.6-8-51.1-9.6-79.1c-0.1-0.9-0.7-1.7-1.6-1.8c-3.1-0.6-6-1.1-6.8-9.6c-0.7-7.6,16.3-29.6,59-33.9c0,0,0.1,0,0.1,0l0.2,0%20c0,0,0.1,0,0.1,0c42.7-4,63.6,14.3,64.4,21.9h0c0.8,8.5-1.9,9.6-4.9,10.7c-0.9,0.3-1.4,1.2-1.2,2.1c1.7,12.8,3,24.3,3.9,35.8%20c0,0,2.5,31.1,1.5,43.1C261.2,255.9,248.5,256.1,248.5,256.1z%20M262.3,247c-0.1,1.1-0.3,2.3-0.8,3.3C261.7,249.2,262,248.1,262.3,247%20z%20M365.2,233.1c-1.8,6.4-4,6.4-6.6,6.5c-0.9,0-1.7,0.6-1.9,1.5c-5.4,22.3-10.7,39.2-19.3,62.2c-1.2,3.2-5,5.1-8.2,4.2l-27.2-7.7%20l1.3-4.4c0.7-2.4-0.6-4.9-3-5.6c-2.4-0.7-4.9,0.6-5.6,3l-1.4,4.6l-33.6-9.6c-3.2-0.9-5.4-4.5-4.8-7.9c1.5-7.9,3.1-15.1,4.7-21.9%20c4-2.3,6.7-6.6,6.7-11.4c-0.1-4.5-0.1-8.9-0.3-13.1c1.6-5.4,3.3-10.9,5.2-16.7c0.3-0.9-0.1-1.8-0.8-2.3c-2.2-1.3-4-2.5-2.2-8.9%20c1.2-4.3,11.8-11.5,30.3-11.5c7,0,15.1,1,24.2,3.6c0,0,0.1,0,0.1,0c0,0,0.1,0,0.1,0l0.1,0c0,0,0.1,0,0.1,0%20C356.5,207.3,366.9,227.2,365.2,233.1z%27/%3E%3Ccircle%20class=%27st0%27%20cx=%27306%27%20cy=%27226%27%20r=%274%27/%3E%3Cpath%20class=%27st0%27%20d=%27M313.3,245c-4.5-1.3-7.1-3.6-8.4-2.4c-1.2,0.4-1.5,8.2,5.8,10.5c7.3,2.3,11.6-4.2,10.8-5.2%20C321.2,246.2,317.8,246.6,313.3,245z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M290.1,322.6c-2.4-0.6-4.9,0.9-5.5,3.3l-1,4c-0.6,2.4,0.9,4.9,3.3,5.5c0.4,0.1,0.7,0.1,1.1,0.1%20c2,0,3.9-1.4,4.4-3.4l1-4C294,325.7,292.5,323.2,290.1,322.6z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M273.1,326.6c-2.4-0.6-4.9,0.9-5.5,3.3l-1,4c-0.6,2.4,0.9,4.9,3.3,5.5c0.4,0.1,0.7,0.1,1.1,0.1%20c2,0,3.9-1.4,4.4-3.4l1-4C277,329.7,275.5,327.2,273.1,326.6z%27/%3E%3Ccircle%20class=%27st0%27%20cx=%27327%27%20cy=%27231%27%20r=%274%27/%3E%3Cpath%20class=%27st0%27%20d=%27M-3.5,70.5c0,1.9,1.6,3.5,3.5,3.5s3.5-1.6,3.5-3.5v-3.8h3.8c1.9,0,3.5-1.6,3.5-3.5s-1.6-3.5-3.5-3.5H3.5V56%20c0-1.9-1.6-3.5-3.5-3.5s-3.5,1.6-3.5,3.5v3.8h-3.8c-1.9,0-3.5,1.6-3.5,3.5s1.6,3.5,3.5,3.5h3.8V70.5z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M417.5,33.5c-1.4-1.4-3.6-1.4-4.9,0l-6.3,6.3l-6.3-6.3c-1.4-1.4-3.6-1.4-4.9,0c-1.4,1.4-1.4,3.6,0,4.9l6.3,6.3%20l-6.3,6.3c-1.4,1.4-1.4,3.6,0,4.9c0.7,0.7,1.6,1,2.5,1s1.8-0.3,2.5-1l6.3-6.3l6.3,6.3c0.7,0.7,1.6,1,2.5,1s1.8-0.3,2.5-1%20c1.4-1.4,1.4-3.6,0-4.9l-6.3-6.3l6.3-6.3C418.8,37.1,418.8,34.9,417.5,33.5z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M283.1,120.8h2.2v2.2c0,1.4,1.1,2.5,2.5,2.5s2.5-1.1,2.5-2.5v-2.2h2.2c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5%20h-2.2v-2.2c0-1.4-1.1-2.5-2.5-2.5s-2.5,1.1-2.5,2.5v2.2h-2.2c-1.4,0-2.5,1.1-2.5,2.5S281.7,120.8,283.1,120.8z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M88.3,421.2c-1-1-2.6-1-3.5,0l-5.6,5.6l-5.6-5.6c-1-1-2.6-1-3.5,0c-1,1-1,2.6,0,3.5l5.6,5.6l-5.6,5.6%20c-1,1-1,2.6,0,3.5c0.5,0.5,1.1,0.7,1.8,0.7s1.3-0.2,1.8-0.7l5.6-5.6l5.6,5.6c0.5,0.5,1.1,0.7,1.8,0.7s1.3-0.2,1.8-0.7%20c1-1,1-2.6,0-3.5l-5.6-5.6l5.6-5.6C89.2,423.8,89.2,422.2,88.3,421.2z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M429.8,456H427v-2.8c0-1.4-1.1-2.5-2.5-2.5s-2.5,1.1-2.5,2.5v2.8h-2.8c-1.4,0-2.5,1.1-2.5,2.5s1.1,2.5,2.5,2.5%20h2.8v2.8c0,1.4,1.1,2.5,2.5,2.5s2.5-1.1,2.5-2.5V461h2.8c1.4,0,2.5-1.1,2.5-2.5S431.2,456,429.8,456z%27/%3E%3Ccircle%20class=%27st0%27%20cx=%2711%27%20cy=%27314%27%20r=%274%27/%3E%3Cpath%20class=%27st0%27%20d=%27M427.5,245c-2.5,0-4.5,2-4.5,4.5s2,4.5,4.5,4.5s4.5-2,4.5-4.5S430,245,427.5,245z%20M427.5,251%20c-0.8,0-1.5-0.7-1.5-1.5s0.7-1.5,1.5-1.5s1.5,0.7,1.5,1.5S428.3,251,427.5,251z%27/%3E%3Ccircle%20class=%27st0%27%20cx=%27500%27%20cy=%27157%27%20r=%276%27/%3E%3Cpath%20class=%27st0%27%20d=%27M300,390c-3.9,0-7,3.1-7,7s3.1,7,7,7s7-3.1,7-7S303.9,390,300,390z%20M300,401c-2.2,0-4-1.8-4-4s1.8-4,4-4%20s4,1.8,4,4S302.2,401,300,401z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M177,6c3.3,0,6-2.7,6-6s-2.7-6-6-6s-6,2.7-6,6S173.7,6,177,6z%20M177-3c1.7,0,3,1.3,3,3s-1.3,3-3,3s-3-1.3-3-3%20S175.3-3,177-3z%27/%3E%3Ccircle%20class=%27st0%27%20cx=%270%27%20cy=%27157%27%20r=%276%27/%3E%3Cpath%20class=%27st0%27%20d=%27M507.3,59.8h-3.8V56c0-1.9-1.6-3.5-3.5-3.5s-3.5,1.6-3.5,3.5v3.8h-3.8c-1.9,0-3.5,1.6-3.5,3.5s1.6,3.5,3.5,3.5%20h3.8v3.8c0,1.9,1.6,3.5,3.5,3.5s3.5-1.6,3.5-3.5v-3.8h3.8c1.9,0,3.5-1.6,3.5-3.5S509.2,59.8,507.3,59.8z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M177,494c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S180.3,494,177,494z%20M177,503c-1.7,0-3-1.3-3-3s1.3-3,3-3%20s3,1.3,3,3S178.7,503,177,503z%27/%3E%3Cpath%20class=%27st0%27%20d=%27M221.8,175.7c-1.2,0.1-2.3,0.6-3.2,1.4c0.8,0.2,1.5,1,1.5,1.9c0,1.1-0.9,2-2,2c-0.6,0-1.1-0.2-1.4-0.6%20c-0.1,0.6-0.2,1.2-0.1,1.8c0.3,3.2,3.2,5.6,6.4,5.3c3.2-0.3,5.6-3.2,5.3-6.4C227.9,177.8,225,175.4,221.8,175.7z%27/%3E%3Cg%3E%3Cpath%20class=%27st0%27%20d=%27M192.1,184.5c-0.3-3.2-3.2-5.6-6.4-5.3c-1,0.1-2,0.5-2.8,1c0.6,0.3,1.1,1,1.1,1.8c0,1.1-0.9,2-2,2%20c-0.5,0-1-0.2-1.4-0.6c-0.2,0.7-0.3,1.4-0.2,2.2c0.3,3.2,3.2,5.6,6.4,5.3S192.4,187.7,192.1,184.5z%27/%3E%3C/g%3E%3C/svg%3E";
			break;
			default:
				$out = '';
			break;
		}
		return 'url(&quot;' . $out . '&quot;)';
	}
}
