/*-----------------------------------------------------------------------------------

    Theme Name: Goldsmith
    Description: WordPress Theme
    Author: Ninetheme
    Author URI: https://ninetheme.com/
    Version: 1.0

-----------------------------------------------------------------------------------*/
"use strict";

(function(window, document, $) {

    if (goldsmith_wishlist_get_cookie('goldsmith_wishlist_key') == '') {
        goldsmith_wishlist_set_cookie('goldsmith_wishlist_key', goldsmith_wishlist_get_key(), 7);
    }

    function goldsmith_wishlist_get_key() {
        var result = [];
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        var charactersLength = characters.length;

        for (var i = 0; i < 6; i++) {
            result.push(characters.charAt(Math.floor(Math.random() *
            charactersLength)));
        }

        return result.join('');
    }

    function goldsmith_wishlist_set_cookie(cname, cvalue, exdays) {
        var d = new Date();

        d.setTime(d.getTime() + (
            exdays * 24 * 60 * 60 * 1000
        ));

        var expires = 'expires=' + d.toUTCString();

        document.cookie = cname + '=' + cvalue + '; ' + expires + '; path=/';
    }

    function goldsmith_wishlist_get_cookie(cname) {
        var name = cname + '=';
        var ca = document.cookie.split(';');

        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];

            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }

            if (c.indexOf(name) == 0) {
                return decodeURIComponent(c.substring(name.length, c.length));
            }
        }

        return '';
    }

    // add
    $( document.body ).on('click touch', '.goldsmith-wishlist-btn', function(e) {
        var $this = $(this),
            id = $this.attr('data-id');

        var data = {
            action: 'goldsmith_wishlist_add',
            product_id: id,
            beforeSend: function() {
                $this.parent().append('<span class="loading-wrapper"><span class="ajax-loading"></span></span>').addClass('loading');
            }
        };
        $.post(wishlist_vars.ajax_url, data, function(response) {
            response = JSON.parse( response );
            $('.goldsmith-wishlist-count').html(response['count']);
            $('[data-wishlist-count]').attr('data-wishlist-count', response['count']);
            $('.panel-content-item').removeClass('active');
            $('.goldsmith-side-panel').addClass('active');
            $('.wishlist-content').parent().addClass('active');
            $('.goldsmith-wishlist-content-items').html(response['value']);
            $('.goldsmith-wishlist-content-notice').html( response['notice'] );
            $('body').trigger('goldsmith_lazy_load');
            $('body').addClass('goldsmith-overlay-open');
            //$('.wishlist-content').perfectScrollbar();
            setTimeout(function() {
                $('.goldsmith-wishlist-content-notice .goldsmith-small-title').fadeOut( 'fast' );
            }, 3000);
            $this.addClass('added');
            setTimeout(function() {
                $this.parent().removeClass('loading');
                $this.parent().find('.loading-wrapper').remove();
            }, 1000);
        });

        e.preventDefault();
    });
    // remove
    $( document ).on('click touch', '.goldsmith-wishlist-del-icon', function(e) {

        var $this = $(this),
            product_id = $this.parents('.goldsmith-content-item').attr('data-id'),
            data = {
                action: 'goldsmith_wishlist_remove',
                product_id: product_id,
                beforeSend: function() {
                    $this.parent().append('<span class="loading-wrapper"><span class="ajax-loading"></span></span>').addClass('loading');
                }
            };

        $.post(wishlist_vars.ajax_url, data, function(response) {
            $( '.goldsmith-wishlist-item[data-id="'+product_id+'"]' ).remove();
            response = JSON.parse( response );
            var count = response['count'];

            if ( response['status'] == 1 ) {
                $this.parent().removeClass('loading');
                $this.parent().find('.loading-wrapper').remove();
                $('body').trigger('goldsmith_lazy_load');
                if ( response['notice'] != null ) {
                    $('.goldsmith-wishlist-content-notice').html( response['notice'] );
                }
                if ( response['notice_type'] !== 'empty' ) {
                    setTimeout(function() {
                      $('.goldsmith-wishlist-content-notice:not(.goldsmith-empty-content) .goldsmith-small-title').fadeOut( 'fast' );
                    }, 3000);
                }

            } else {
                $('.goldsmith-wishlist-content-items .loading-wrapper').remove();
                if ( response['notice'] != null ) {
                    $('.goldsmith-wishlist-content-notice').html( response['notice'] );
                }
            }

            $('.goldsmith-wishlist-count').html(response['count']);
            $('[data-wishlist-count]').attr('data-wishlist-count', response['count']);

            wishlist_vars.count = response['count'];

            if ( response['count'] != null ) {
                $(document.body).trigger( 'goldsmith_wishlist_count', [count] );
            }

            $('.goldsmith-wishlist-btn[data-id="'+product_id+'"]').removeClass('added');

        });
        e.preventDefault();
    });

    $('.goldsmith-wishlist-count').html(wishlist_vars.count);
    $('[data-wishlist-count]').attr('data-wishlist-count', wishlist_vars.count);

    $( document.body ).on( 'goldsmith_wishlist_count', function( event ) {
        $('.goldsmith-wishlist-count').html(wishlist_vars.count);
        $('[data-wishlist-count]').attr('data-wishlist-count', wishlist_vars.count);
    });

    if ( ( typeof wishlist_vars != 'undefined' ) && wishlist_vars.products ) {
        var ids = wishlist_vars.products;
        for (let i = 0; i < ids.length; i++) {
          $('.goldsmith-wishlist-btn[data-id="'+ids[i]+'"]').addClass('added');
        }
    }


})(window, document, jQuery);
