<?php
/**
 * Utilities
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
	 exit; // Exit if accessed directly
}

/**
 * -----------------------------------------------------------------------------
 * Custom image scrset
 * -----------------------------------------------------------------------------
 */
if ( ! function_exists( 'th90_custom_image_srcset' ) ) {
	function th90_custom_image_srcset( $sources, $size_array, $image_src, $image_meta, $attachment_id ) {
	    $remove = [ '15', '20' ];
	    $sources = array_diff_key( $sources, array_flip( $remove ) );
	    return $sources;
	}
}
add_filter( 'wp_calculate_image_srcset', 'th90_custom_image_srcset', 10, 5);

/**
 * -------------------------------------------------------------------------
 *  Get term array
 * -------------------------------------------------------------------------
 */
if( ! function_exists('th90_custom_search_form') ) {
	function th90_custom_search_form( $placeholder = 'Search...' ) {
		?>
		<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">

			<input type="search" id="<?php echo esc_attr( uniqid( 'search-form-' ) ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" class="search-input" value="<?php echo get_search_query(); ?>" name="s">

			<button type="submit" class="search-button">
				<?php th90_svg_icon( 'search' ); ?>
			</button>

		</form>

		<?php
	}
}
/**
 * -------------------------------------------------------------------------
 *  Get term array
 * -------------------------------------------------------------------------
 */
if( ! function_exists('th90_get_terms') ) {
	function th90_get_terms( $tax = 'category', $key = 'slug' ) {
		$terms = array();
		if( ! taxonomy_exists( $tax ) ) {
			return false;
		}
		if ( $key === 'id' ) {
			foreach ( (array) get_terms( $tax, array( 'hide_empty' => false ) ) as $term ) {
				$terms[$term->term_id] = $term->name;
			}
		} elseif ( $key === 'slug' ) {
			foreach ( (array) get_terms( $tax, array( 'hide_empty' => false ) ) as $term ) {
				$terms[$term->slug] = $term->name;
			}
		}
		return $terms;
	}
}

/**
 * -------------------------------------------------------------------------
 *  Get posts id array
 * -------------------------------------------------------------------------
 */
if( ! function_exists('th90_get_posts_id') ) {
	function th90_get_posts_id( $post_type = 'post' ) {
		$posts = array();

		$post_lists = array(
			'post_type'        => $post_type,
			'numberposts'      => -1,
			'cache_results'  => false,
		);

		foreach ( get_posts( $post_lists ) as $post ) {
			$posts[$post->ID] = $post->post_title;
		}
		wp_reset_postdata();

		return $posts;
	}
}
