<?php
/**
 * Users profile functions
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
	 exit; // Exit if accessed directly
}
/**
 * -------------------------------------------------------------------------
 *  Custom User field ACF
 * -------------------------------------------------------------------------
 */
if ( ! function_exists( 'th90_social_profile_options' ) ) {
	function th90_social_profile_options() {
		$options_array = array();
		foreach ( th90_default_options()['social_networks'] as $key => $value ) {
			/*if ( 'website' != $key ) {
				$options_array[] =array(
					'key' => 'th90_field_user_' . th90_convert_to_id( $key ),
					'label' => ucwords( $key ) . ' ' . esc_html__( 'URL', 'atlas-core' ),
					'name' => 'user_' . th90_convert_to_id( $key ),
					'type' => 'text',
				);
			}*/
			$options_array[] =array(
				'key' => 'th90_field_user_' . th90_convert_to_id( $key ),
				'label' => ucwords( $key ) . ' ' . esc_html__( 'URL', 'atlas-core' ),
				'name' => 'user_' . th90_convert_to_id( $key ),
				'type' => 'text',
			);
		}
		return $options_array;
	}
}

if( function_exists('acf_add_local_field_group') ):
	acf_add_local_field_group(array(
		'key' => 'th90_group_user',
		'title' => 'User',
		'fields' => th90_social_profile_options(),
		'location' => array(
			array(
				array(
					'param' => 'user_form',
					'operator' => '==',
					'value' => 'edit',
				),
			),
		),
		'menu_order' => 2,
		'position' => 'acf_after_title',
		'style' => 'seamless',
		'label_placement' => 'left',
		'instruction_placement' => 'field',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	)
);
endif;


/**
 * -------------------------------------------------------------------------
 *  Author box
 * -------------------------------------------------------------------------
 */
if ( ! function_exists( 'th90_author_box' ) ) {
	function th90_author_box( $user_id, $avatar_size = 80, $echo = false, $class = '' ) {
		$out = '';
		$class = $class ? ' ' . $class : '';
		$socials = array();

		foreach ( th90_default_options()['social_networks'] as $key => $value  ) {
			/*if ( 'website' == $key ) {
				$socials[th90_convert_to_id( $key )] = get_the_author_meta( 'url', $user_id );
			} else {
				$socials[th90_convert_to_id( $key )] = th90_field_single( 'user_' . th90_convert_to_id( $key ), 'user_' . $user_id );
			}*/

			$socials[th90_convert_to_id( $key )] = th90_field_single( 'user_' . th90_convert_to_id( $key ), 'user_' . $user_id );
		}

		$out .= '<div class="desc-author'.$class.'">';
	        $out .= '<div id="author-' . esc_attr( $user_id ) . '" class="vcard" rel="author">';

				$out .= '<div class="author-ava" data-author="' . esc_attr( mb_substr( get_the_author_meta( 'display_name', $user_id ), 0, 1 ) ) . '">';
					$out .= get_avatar( $user_id, $avatar_size );
				$out .= '</div>';

				$out .= '<div class="author-desc">';

					$out .= '<div class="author-text">';

						$out .= get_the_author_meta( 'description', $user_id );

					$out .= '</div>';

					$out .= th90_core_socials( $socials, 'simple' );

				$out .= '</div>';
			$out .= '</div>';
		$out .= '</div>';

		if ( get_the_author_meta( 'description', $user_id ) ) {
			if ( $echo ) {
				echo $out;
			} else {
				return $out;
			}
		}
	}
}

/**
 * -------------------------------------------------------------------------
 *  Author box Article
 * -------------------------------------------------------------------------
 */
if ( ! function_exists( 'th90_author_box_single' ) ) {
	function th90_author_box_single( $user_id, $avatar_size = 80, $echo = false, $class = '' ) {
		$out = '';
		$class = $class ? ' ' . $class : '';
		$socials = array();

		foreach ( th90_default_options()['social_networks'] as $key => $value  ) {
			$socials[th90_convert_to_id( $key )] = th90_field_single( 'user_' . th90_convert_to_id( $key ), 'user_' . $user_id );
		}

		$out .= '<div class="entry-author'.$class.'">';
	        $out .= '<div id="author-' . esc_attr( $user_id ) . '" class="vcard" rel="author">';

				$out .= '<div class="author-head">';

					$out .= '<div class="author-ava" data-author="' . esc_attr( mb_substr( get_the_author_meta( 'display_name', $user_id ), 0, 1 ) ) . '">';
						$out .= get_avatar( $user_id, $avatar_size );
					$out .= '</div>';

					$out .= '<div class="author-name fn">';
						$out .= '<span class="meta-item">' . th90_translate( 'Posted By' ) . '</span><a class="url" href="' . esc_url( get_author_posts_url( $user_id ) ) . '"><strong>' . get_the_author_meta( 'display_name', $user_id ) . '</strong></a>';
					$out .= '</div>';

					$out .= th90_core_socials( $socials, 'simple' );
				$out .= '</div>';

				$out .= '<div class="author-desc">';
					$out .= get_the_author_meta( 'description', $user_id );
				$out .= '</div>';

			$out .= '</div>';
		$out .= '</div>';

		if ( get_the_author_meta( 'description', $user_id ) ) {
			if ( $echo ) {
				echo $out;
			} else {
				return $out;
			}
		}
	}
}
