<?php
/**
 * Speed Optimization
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/*-----------------------------------------------------------------------------------*/
# Init Speed Function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_init_speed' ) ) {
    function th90_init_speed() {
		if ( th90_opt( 'disable_emojis' ) ) {
			// Prevent Emoji from loading on the front-end
			remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
			remove_action( 'wp_print_styles', 'print_emoji_styles' );

			// Remove from admin area also
			remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
			remove_action( 'admin_print_styles', 'print_emoji_styles' );

			// Remove from RSS feeds also
			remove_filter( 'the_content_feed', 'wp_staticize_emoji');
			remove_filter( 'comment_text_rss', 'wp_staticize_emoji');

			// Remove from Embeds
			remove_filter( 'embed_head', 'print_emoji_detection_script' );

			// Remove from emails
			remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );

			// Disable from TinyMCE editor. Currently disabled in block editor by default
			add_filter( 'tiny_mce_plugins', 'th90_disable_emojis_tinymce' );

			/** Finally, prevent character conversion too
		         ** without this, emojis still work
		         ** if it is available on the user's device
			 */

			add_filter( 'option_use_smilies', '__return_false' );
		}

		if ( th90_opt( 'disable_elementor_google_font' ) ) {
			add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );
		}
	}

	add_action('init', 'th90_init_speed');
}

function th90_disable_emojis_tinymce( $plugins ) {
	if( is_array( $plugins ) ) {
		$plugins = array_diff( $plugins, array( 'wpemoji' ) );
	}
	return $plugins;
}

if ( TH90_CF7_IS_ACTIVE ) {
	add_filter( 'wpcf7_load_js', '__return_false' );
	add_filter( 'wpcf7_load_css', '__return_false' );
}

/*-----------------------------------------------------------------------------------*/
# Init Speed Function
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_scripts_speed' ) ) {
    function th90_scripts_speed() {
		wp_dequeue_style( 'redux-extendify-styles' );

		if ( TH90_CF7_IS_ACTIVE ) {
			if ( th90_opt( 'contact7_page' ) ) {
				if ( is_page_template( 'page-contact.php' ) ) {
					wpcf7_enqueue_scripts();
					wpcf7_enqueue_styles();
				}
			} else {
				wpcf7_enqueue_scripts();
				wpcf7_enqueue_styles();
			}
		}

		if ( th90_opt( 'disable_elementor_swiper' ) ) {
			wp_dequeue_style( 'swiper' );
			wp_dequeue_script( 'swiper' );
		}

		if ( ! is_user_logged_in() && th90_opt( 'disable_elementor_jquery' ) ) {
			wp_deregister_script( 'elementor-frontend-modules' );
			wp_deregister_script( 'elementor-webpack-runtime' );
			wp_deregister_script( 'elementor-frontend' );
			wp_deregister_script( 'elementor-dialog' );
			wp_deregister_script( 'share-link' );
			wp_deregister_script( 'elementor-waypoints' );
			wp_deregister_script( 'flatpickr' );
			wp_deregister_script( 'jquery-numerator' );
			wp_deregister_script( 'elementor-gallery' );
			wp_dequeue_style( 'elementor-icons' );
	    	wp_deregister_style( 'elementor-icons' );
		}


		if ( th90_opt( 'disable_woocommerce_assets_out_of_shop' ) ) {

			if ( ! th90_woo_check_pages() ) {

	            // Dequeue WooCommerce styles
	            wp_dequeue_style( 'woocommerce-layout' );
	            wp_dequeue_style( 'woocommerce-general' );
	            wp_dequeue_style( 'woocommerce-smallscreen' );
	            wp_dequeue_style( 'wc-blocks-vendors-style' );
	            wp_dequeue_style( 'wc-blocks-style' );
	            wp_dequeue_style( 'woocommerce-inline' );
	            wp_dequeue_style( 'th90-woocommerce' );

	            // Dequeue WooCommerce scripts
	            wp_dequeue_script( 'wc-cart-fragments' );
	            wp_dequeue_script( 'woocommerce' );
	            wp_dequeue_script( 'wc-add-to-cart' );
	            wp_dequeue_script( 'js-cookie' );

	        }
		}

		if ( th90_opt( 'disable_woocommerce_block' ) ) {
			wp_dequeue_style( 'wc-blocks-packages-style' );
			wp_dequeue_style( 'wc-blocks-style-active-filters' );
			wp_dequeue_style( 'wc-blocks-style-add-to-cart-form' );
			wp_dequeue_style( 'wc-blocks-style-all-products' );
			wp_dequeue_style( 'wc-blocks-style-all-reviews' );
			wp_dequeue_style( 'wc-blocks-style-attribute-filter' );
			wp_dequeue_style( 'wc-blocks-style-breadcrumbs' );
			wp_dequeue_style( 'wc-blocks-style-catalog-sorting' );
			wp_dequeue_style( 'wc-blocks-style-customer-account' );
			wp_dequeue_style( 'wc-blocks-style-featured-category' );
			wp_dequeue_style( 'wc-blocks-style-featured-product' );
			wp_dequeue_style( 'wc-blocks-style-mini-cart' );
			wp_dequeue_style( 'wc-blocks-style-price-filter' );
			wp_dequeue_style( 'wc-blocks-style-product-add-to-cart' );
			wp_dequeue_style( 'wc-blocks-style-product-button' );
			wp_dequeue_style( 'wc-blocks-style-product-categories' );
			wp_dequeue_style( 'wc-blocks-style-product-image' );
			wp_dequeue_style( 'wc-blocks-style-product-image-gallery' );
			wp_dequeue_style( 'wc-blocks-style-product-query' );
			wp_dequeue_style( 'wc-blocks-style-product-results-count' );
			wp_dequeue_style( 'wc-blocks-style-product-reviews' );
			wp_dequeue_style( 'wc-blocks-style-product-sale-badge' );
			wp_dequeue_style( 'wc-blocks-style-product-search' );
			wp_dequeue_style( 'wc-blocks-style-product-sku' );
			wp_dequeue_style( 'wc-blocks-style-product-stock-indicator' );
			wp_dequeue_style( 'wc-blocks-style-product-summary' );
			wp_dequeue_style( 'wc-blocks-style-product-title' );
			wp_dequeue_style( 'wc-blocks-style-rating-filter' );
			wp_dequeue_style( 'wc-blocks-style-reviews-by-category' );
			wp_dequeue_style( 'wc-blocks-style-reviews-by-product' );
			wp_dequeue_style( 'wc-blocks-style-product-details' );
			wp_dequeue_style( 'wc-blocks-style-single-product' );
			wp_dequeue_style( 'wc-blocks-style-stock-filter' );
			wp_dequeue_style( 'wc-blocks-style-mini-cart-contents' );
			wp_dequeue_style( 'wc-blocks-style-cart' );
			wp_dequeue_style( 'wc-blocks-style-checkout' );
		}

		if ( th90_opt( 'disable_gutenberg_assets' ) ) {

			if ( is_home() || is_archive() || is_search() || ( get_the_ID() && class_exists( '\Elementor\Plugin' ) && Elementor\Plugin::instance()->documents->get( get_the_ID() )->is_built_with_elementor() ) ) {

	            wp_dequeue_style( 'wp-block-library' );
	            wp_dequeue_style( 'wp-block-library-theme' );
	            wp_dequeue_style( 'global-styles' );

	            remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' );
	        }
		}
	}

	add_action( 'wp_enqueue_scripts', 'th90_scripts_speed' );
}
