<?php
/**
 * Post Share
 *
 * @package Atlas Core
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! function_exists( 'th90_core_social_shares' ) ) {
	function th90_core_social_shares( $args = '' ) {
		// Defaults ----------
		$args = wp_parse_args( $args, array(
			'classes'       => array(),
			'options_sufix' => 'post',
			'style'          => 'icon',
			'social_more'	=> true,
			'more_limit'	=> 5,
		));
		extract( $args );

		$output = '';
		$url_site = get_permalink();
		$post_title = urlencode(strip_tags( get_the_title() ));

        # Buttons array ----------
		foreach ( th90_default_options()['social_shares'] as $key => $value  ) {
			$url = $url_mobile = '';
			switch ( $key ) {
				case 'facebook':
					$url = 'https://www.facebook.com/sharer/sharer.php?u='. $url_site;
					break;
				case 'twitter':
					$url = 'https://twitter.com/intent/tweet/?url='. $url_site;
					break;
				case 'pinterest':
					$url = 'https://pinterest.com/pin/create/button/?url='. $url_site .'&amp;description='. $post_title .'&amp;media='. th90_post_thumbnail_url();
					break;
				case 'telegram':
					$url = 'https://telegram.me/share/url?text=' . $post_title . '&amp;url=' . $url_site;
					break;
				case 'linkedin':
					$url = 'https://www.linkedin.com/shareArticle?mini=true&amp;url='. $url_site .'&amp;title='. $post_title;
					break;
				case 'tumblr':
					$url = 'https://www.tumblr.com/share/link?url=' . $url_site . '&amp;title=' . $post_title;
					break;
				case 'reddit':
					$url = 'https://www.reddit.com/submit?url=' . $url_site . '&amp;resubmit=true&amp;title=' . $post_title;
					break;
				case 'vkontakte':
					$url =  'https://vk.com/share.php?title='. $post_title . '&amp;url='. $url_site;
					break;
				case 'email':
					$url = 'mailto:?subject=' . $post_title . '&amp;body=' . $url_site;
					break;
				case 'whatsapp':
					$url = 'https://web.whatsapp.com/send?text='. $post_title . ' ' . $url_site;
					$url_mobile = 'https://wa.me/?text='. $post_title . ' ' . $url_site;
					break;
				default:
	                break;
	        }
			$share_buttons[$key] = array(
				'active' => th90_opt_arr( 'social_shares_' . $options_sufix , $key ),
				'text' => $value,
				'url' => $url,
			);
			if ( $url_mobile ) {
				$share_buttons[$key]['url_mobile'] = $url_mobile;
			}
		}

        $counter = $active_count = 0;
        $active_share_buttons = array();

        foreach ( $share_buttons as $network => $button ){
            $counter ++;
			$is_more = '';
			if ( $more_limit < $counter && $social_more ) {
				$is_more = ' collapse';
			}

            if ( $button['active'] ) {
				$active_count ++;
				$active_share_button = '';

				if ( 'w_title' == $style ) {
					$share_icon = th90_get_svg_icon_social( $network );
					$share_text = '<span class="icon-text">' . $button['text'] . '</span>';
				} else {
					$share_icon = th90_get_svg_icon_social( $network );
					$share_text = '';
				}

				if ( 'whatsapp' == $network ) {
					$network = 's-' . $network;
					$active_share_button .= '<a href="'. $button['url'] .'" rel="nofollow" class="flex-desktop-el social-icon ' . $network . $is_more . '">';
					$active_share_button .= $share_icon . $share_text;
					$active_share_button .= '</a>';

					$active_share_button .= '<a href="'. $button['url_mobile'] .'" rel="nofollow" class="flex-mobile-el social-icon ' . $network . $is_more . '">';
					$active_share_button .= $share_icon . $share_text;
					$active_share_button .= '</a>';
				} else {
					$network = 's-' . $network;
					$active_share_button .= '<a href="'. $button['url'] .'" rel="nofollow" target="_blank" class="social-icon ' . $network . $is_more . '">';
					$active_share_button .= $share_icon . $share_text;
					$active_share_button .= '</a>';
				}

                $active_share_buttons[] = $active_share_button;
            }
        }

        if( is_array( $active_share_buttons ) && ! empty( $active_share_buttons ) ){
			$social_classes_def = array(
				'social-shares',
				'social-icons',
				'social-' . $style,
			);
			$social_classes = array_merge( $social_classes_def, $classes );

    		$output .= '<div class="' . esc_attr( implode( ' ', array_filter( $social_classes ) ) ) . '">';

			$output .= implode( '', $active_share_buttons );

			if ( $social_more && $more_limit < $active_count ) {
				$output .= '<a href="#" class="social-icon social-more"></a>';
			}

    		$output .= '</div>';
		}
		return $output;
    }
}

if ( ! function_exists( 'th90_core_the_social_shares' ) ) {
	function th90_core_the_social_shares( $args = '' ) {
		echo th90_core_social_shares( $args );
	}
}
