<?php
/**
 * Social Networks functions
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! function_exists( 'th90_core_socials' ) ) {
	function th90_core_socials( $atts = array(), $style = 'simple') {
		$out = '';
		$target = ' target="_blank"';
		$default_socials = $socials = array();

		foreach ( th90_default_options()['social_networks'] as $key => $value  ) {
			foreach ( $atts as $atts_key => $atts_value ) {
				if( $atts_key == $key ) {
					$socials[$atts_key] = $atts_value;
				}
			}
			$default_socials[$key] = '';
		}
		$socials = wp_parse_args( $socials, $default_socials );

		$show = false;

		foreach ( $socials as $key => $value ) {
		    if ( ! empty( trim( $key ) ) ) {
				$show = true;
			}
		}

		$social_classes = array(
			'social-icons',
			'social-' . $style,
		);

		if ( ! empty( $show ) ) {
			$out .= '<div class="' . esc_attr( implode( ' ', array_filter( $social_classes ) ) ) . '">';

			foreach ( $socials as $key => $value ) {
				if ( $value ) {
					$social_item_classes = array(
						'social-icon',
						's-' . esc_attr( th90_convert_to_id( $key ) ),
					);
					$out .= '<a class="' . esc_attr( implode( ' ', array_filter( $social_item_classes ) ) ) . '" href="' . esc_url( $value ) . '" title="' . esc_attr( $key ) . '"' . $target . '>';
					$out .= th90_get_svg_icon_social( th90_convert_to_id( $key ) );
					$out .= '</a>';
				}
			}

			$out .= '</div>';
		}

		return $out;
	}
}

if ( ! function_exists( 'th90_core_the_socials' ) ) {
	function th90_core_the_socials( $socials = array(), $style = 'simple' ) {
		echo th90_core_socials( $socials, $style );
	}
}
