<?php
/**
 * Social Counters functions
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/*-----------------------------------------------------------------------------------*/
# Create Social Counters Options Page
/*-----------------------------------------------------------------------------------*/
if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title'     => 'Social Counters Settings',
		'menu_title'     => 'Social Counters',
		'menu_slug'      => 'th90-social-counters',
		'capability'     => 'edit_posts',
		'redirect'       => false,
        'icon_url' => 'dashicons-facebook',
        'position' => '41',
        //'parent_slug' => 'th90-atlas',
	));
}

/*-------------------------- ---------------------------------------------------------*/
# Get The Count
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_get_the_count' ) ) {
    function th90_get_the_count( $pattern, $the_request ) {
        $counter = 0;

		preg_match( $pattern, $the_request, $matches );

		if ( is_array( $matches ) && ! empty( $matches[1] ) ) {

			$number  = strip_tags( $matches[1] );
			$counter = '';

			foreach ( str_split( $number ) as $char ) {
				if ( is_numeric( $char ) ){
					$counter .= $char;
				}
			}
		}
		return $counter;
    }
}

/*-----------------------------------------------------------------------------------*/
# Facebook Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_facebook_count' ) ) {
    function th90_facebook_count() {
        $id = th90_field_opt( 'facebook_id' );

        $get_request = wp_remote_get( "https://www.facebook.com/plugins/likebox.php?href=https://facebook.com/$id&show_faces=true&header=false&stream=false&show_border=false&locale=en_US", array( 'timeout' => 20 ) );
        $the_request = wp_remote_retrieve_body( $get_request );

        $pattern = '/_1drq[^>]+>(.*?)<\/a/s';
        $counter = th90_get_the_count( $pattern, $the_request );

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'facebook_count_custom' ) ) ? th90_field_opt( 'facebook_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_facebook_count_redux' ) ) {
    function th90_facebook_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_facebook_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_facebook_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_facebook_count' ) != $count ) {
                update_option( 'th90_facebook_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_facebook_count_redux' );

if ( ! function_exists( 'th90_facebook_count_show' ) ) {
    function th90_facebook_count_show() {
        $count = get_transient( 'th90_facebook_count' );
        if ( empty( $count ) ) {
            $count = th90_facebook_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_facebook_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_facebook_count' ) != $count ) {
                    update_option( 'th90_facebook_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_facebook_count' ) ) {
                $count = get_option( 'th90_facebook_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_facebook_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}

/*-----------------------------------------------------------------------------------*/
# Twitter Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_twitter_count' ) ) {
    function th90_twitter_count() {
        $id = th90_field_opt( 'twitter_id' );
        $token = th90_field_opt( 'twitter_token' );
        $args = array(
            'httpversion' => '1.1',
            'blocking' 		=> true,
            'timeout'     => 10,
            'headers'     => array(
                'Authorization' => "Bearer $token"
            )
        );

        add_filter( 'https_ssl_verify', '__return_false' );
        $api_url  = "https://api.twitter.com/1.1/users/show.json?screen_name=$id";
        $response = th90_remote_get( $api_url, true, $args );

        $counter = ! empty( $response['followers_count'] ) ? $response['followers_count'] : 0;

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'twitter_count_custom' ) ) ? th90_field_opt( 'twitter_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_twitter_count_redux' ) ) {
    function th90_twitter_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_twitter_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_twitter_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_twitter_count' ) != $count ) {
                update_option( 'th90_twitter_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_twitter_count_redux' );

if ( ! function_exists( 'th90_twitter_count_show' ) ) {
    function th90_twitter_count_show() {
        $count = get_transient( 'th90_twitter_count' );
        if ( empty( $count ) ) {
            $count = th90_twitter_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_twitter_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_twitter_count' ) != $count ) {
                    update_option( 'th90_twitter_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_twitter_count' ) ) {
                $count = get_option( 'th90_twitter_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_twitter_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}


/*-----------------------------------------------------------------------------------*/
# Youtube Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_youtube_count' ) ) {
    function th90_youtube_count() {
        $id = th90_field_opt( 'youtube_id' );
        $api = th90_field_opt( 'youtube_key' );
        $type = th90_field_opt( 'youtube_type' );
        try {
            if( ! empty( $type ) && $type == 'channel' ){
                $data = @th90_remote_get("https://www.googleapis.com/youtube/v3/channels?part=statistics&id=$id&key=$api");
            }else{
                $data = @th90_remote_get("https://www.googleapis.com/youtube/v3/channels?part=statistics&forUsername=$id&key=$api");
            }

            $counter = ! empty( $data['items'][0]['statistics']['subscriberCount'] ) ? (int) $data['items'][0]['statistics']['subscriberCount'] : 0;

        } catch (Exception $e) {
            $counter = 0;
        }

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'youtube_count_custom' ) ) ? th90_field_opt( 'youtube_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_youtube_count_redux' ) ) {
    function th90_youtube_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_youtube_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_youtube_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_youtube_count' ) != $count ) {
                update_option( 'th90_youtube_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_youtube_count_redux' );

if ( ! function_exists( 'th90_youtube_count_show' ) ) {
    function th90_youtube_count_show() {
        $count = get_transient( 'th90_youtube_count' );
        if ( empty( $count ) ) {
            $count = th90_youtube_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_youtube_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_youtube_count' ) != $count ) {
                    update_option( 'th90_youtube_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_youtube_count' ) ) {
                $count = get_option( 'th90_youtube_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_youtube_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}

/*-----------------------------------------------------------------------------------*/
# Instagram Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_instagram_count' ) ) {
    function th90_instagram_count() {
        $counter = 0;

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'instagram_count_custom' ) ) ? th90_field_opt( 'instagram_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_instagram_count_redux' ) ) {
    function th90_instagram_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_instagram_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_instagram_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_instagram_count' ) != $count ) {
                update_option( 'th90_instagram_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_instagram_count_redux' );

if ( ! function_exists( 'th90_instagram_count_show' ) ) {
    function th90_instagram_count_show() {
        $count = get_transient( 'th90_instagram_count' );
        if ( empty( $count ) ) {
            $count = th90_instagram_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_instagram_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_instagram_count' ) != $count ) {
                    update_option( 'th90_instagram_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_instagram_count' ) ) {
                $count = get_option( 'th90_instagram_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_instagram_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}

/*-----------------------------------------------------------------------------------*/
# Linkedin Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_linkedin_count' ) ) {
    function th90_linkedin_count() {
        $counter = 0;

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'linkedin_count_custom' ) ) ? th90_field_opt( 'linkedin_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_linkedin_count_redux' ) ) {
    function th90_linkedin_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_linkedin_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_linkedin_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_linkedin_count' ) != $count ) {
                update_option( 'th90_linkedin_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_linkedin_count_redux' );

if ( ! function_exists( 'th90_linkedin_count_show' ) ) {
    function th90_linkedin_count_show() {
        $count = get_transient( 'th90_linkedin_count' );
        if ( empty( $count ) ) {
            $count = th90_linkedin_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_linkedin_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_linkedin_count' ) != $count ) {
                    update_option( 'th90_linkedin_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_linkedin_count' ) ) {
                $count = get_option( 'th90_linkedin_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_linkedin_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}

/*-----------------------------------------------------------------------------------*/
# Behance Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_behance_count' ) ) {
    function th90_behance_count() {
        $id = th90_field_opt( 'behance_id' );
        $api = th90_field_opt( 'behance_key' );

        try {
            $data 	= @th90_remote_get("http://www.behance.net/v2/users/$id?api_key=$api");
            $counter = ! empty( $data['user']['stats']['followers'] ) ? (int) $data['user']['stats']['followers'] : 0;
        } catch (Exception $e) {
            $counter = 0;
        }

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'behance_count_custom' ) ) ? th90_field_opt( 'behance_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_behance_count_redux' ) ) {
    function th90_behance_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_behance_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_behance_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_behance_count' ) != $count ) {
                update_option( 'th90_behance_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_behance_count_redux' );

if ( ! function_exists( 'th90_behance_count_show' ) ) {
    function th90_behance_count_show() {
        $count = get_transient( 'th90_behance_count' );
        if ( empty( $count ) ) {
            $count = th90_behance_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_behance_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_behance_count' ) != $count ) {
                    update_option( 'th90_behance_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_behance_count' ) ) {
                $count = get_option( 'th90_behance_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_behance_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}

/*-----------------------------------------------------------------------------------*/
# Pinterest Counter
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_pinterest_count' ) ) {
    function th90_pinterest_count() {
        $username = th90_field_opt( 'pinterest_id' );
        try {
            $html 	= th90_remote_get( "https://www.pinterest.com/$username/" , false);
            $doc    = new DOMDocument();
            @$doc->loadHTML($html);
            $metas 	= $doc->getElementsByTagName('meta');
            for ($i = 0; $i < $metas->length; $i++){
                $meta = $metas->item($i);
                if($meta->getAttribute('name') == 'pinterestapp:followers'){
                    $counter = $meta->getAttribute('content');
                    break;
                }
            }
        } catch (Exception $e) {
            $counter = 0;
        }

        if( empty( $counter ) ){
            $counter = ! empty( th90_field_opt( 'pinterest_count_custom' ) ) ? th90_field_opt( 'pinterest_count_custom' ) : 0;
        }
        return $counter;
    }
}

if ( ! function_exists( 'th90_pinterest_count_redux' ) ) {
    function th90_pinterest_count_redux() {
        if (strpos( get_current_screen()->id, 'th90-social-counters') != true ) {
            return;
        }
        $count = th90_pinterest_count();
        if ( ! empty( $count ) ) {
            set_transient( 'th90_pinterest_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
            if ( get_option( 'th90_pinterest_count' ) != $count ) {
                update_option( 'th90_pinterest_count', $count );
            }
        }
    }
}
add_action( 'acf/save_post', 'th90_pinterest_count_redux' );

if ( ! function_exists( 'th90_pinterest_count_show' ) ) {
    function th90_pinterest_count_show() {
        $count = get_transient( 'th90_pinterest_count' );
        if ( empty( $count ) ) {
            $count = th90_pinterest_count();
            if ( ! empty( $count ) ) {
                set_transient( 'th90_pinterest_count' , $count , absint( th90_field_opt( 'cache_time' ) ) * 60 * 60 );
                if ( get_option( 'th90_pinterest_count' ) != $count ) {
                    update_option( 'th90_pinterest_count', $count );
                }
            }
            if ( $count == 0 && get_option( 'th90_pinterest_count' ) ) {
                $count = get_option( 'th90_pinterest_count' );
            } elseif ( $count == 0 && ! get_option( 'th90_pinterest_count' ) ) {
                $count = 0;
            }
        }
        return $count;
    }
}


/*-----------------------------------------------------------------------------------*/
# Counters data
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_counters_data' ) ) {
	function th90_counters_data() {
		$out = array();

		# Counters order ----------
        $social_array = array(
            'facebook',
            'twitter',
            'youtube',
            'instagram',
            'linkedin',
            'pinterest',
            'behance',
        );

		# Prepare the Counters data ----------
        if ( is_array( $social_array ) ) {
            foreach ( $social_array as $social ) {

    			# Reset the include variable ----------
    			$include = false;

    			switch ($social) {

    				# Facebook ----------
    				case 'facebook':
    					if ( ! empty( th90_field_opt( 'facebook_id' ) ) ){
    						$include = true;
    						$text    = th90_translate( 'Fans' );
    						$count   = th90_facebook_count_show();
    						$url     = 'https://www.facebook.com/' . th90_field_opt( 'facebook_id' );
    					}
    					break;


    				# Twitter ----------
    				case 'twitter':
    					if ( ! empty( th90_field_opt( 'twitter_id' ) ) ){
    						$include = true;
    						$text    = th90_translate( 'Followers' );
    						$count   = th90_twitter_count_show();
    						$url     = 'https://twitter.com/' . th90_field_opt( 'twitter_id' );
    					}
    					break;


    				# Youtube ----------
    				case 'youtube':
    					if ( ! empty( th90_field_opt( 'youtube_id' ) ) ){
    						$include = true;
    						$text    = th90_translate( 'Subscribers' );
    						$count   = th90_youtube_count_show();
    						$url     = 'http://youtube.com/' . th90_field_opt( 'youtube_type' ) . '/' . th90_field_opt( 'youtube_id' );
    					}
    					break;

    				# Behance ----------
    				case 'behance':
    					if ( ! empty( th90_field_opt( 'behance_id' ) ) ){
    						$include = true;
    						$text    = th90_translate( 'Followers' );
    						$count   = th90_behance_count_show();
    						$url     = 'https://www.behance.net/' . th90_field_opt( 'behance_id' );
    					}
    					break;


    				# Instagram ----------
    				case 'instagram':
                        if ( ! empty( th90_field_opt( 'instagram_id' ) ) ){
                            $include = true;
                            $text    = th90_translate( 'Followers' );
                            $count   = th90_instagram_count_show();
                            $url     = 'https://instagram.com/' . th90_field_opt( 'instagram_id' );
                        }
    					break;

    				# LinkedIn ----------
    				case 'linkedin':
                        if ( ! empty( th90_field_opt( 'linkedin_profile' ) ) ){
                            $include = true;
                            $text    = th90_translate( 'Followers' );
                            $count   = th90_linkedin_count_show();
                            $url     = esc_url( th90_field_opt( 'linkedin_profile' ) );
                        }
    					break;

    				# Pinterest ----------
    				case 'pinterest':
                        if ( ! empty( th90_field_opt( 'pinterest_id' ) ) ){
                            $include = true;
                            $text    = th90_translate( 'Followers' );
                            $count   = th90_pinterest_count_show();
                            $url     = 'https://www.pinterest.com/' . th90_field_opt( 'pinterest_id' );
                        }
                        break;
    			}

    			# Add to the counters Array ----------
    			if ( $include ) {
    				$out[ $social ] = array(
    					'text'  => $text,
    					'count' => $count,
    					'icon'  => th90_get_svg_icon_social( $social ),
    					'url'   => $url,
    				);
    			}

    		} //End Foreach
        }

		return $out;

	}
}
