<?php
Redux::set_section( $opt_name, array(
    'title'            => esc_html__('Speed & Performance', 'atlas-core'),
    'id'               => 'performance_section',
    'desc'	=> sprintf( esc_html__( 'For better performance, we recomended to use the %1$sLiteSpeed Cache%2$s plugin.', 'atlas-core' ), '<a target="_blank" href="https://wordpress.org/plugins/litespeed-cache/"><strong>', '</strong></a>' ),
    'subsection'       => false,
    'icon'             => 'el el-broom',
    'fields'           => array(
        array(
            'id'       => 'disable_lazyload_img_placeholder',
            'type'     => 'switch',
            'default'  => true,
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable lazyload image placeholder', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t show placeholder image before image showing on lazyload process. I will make your document load size be smaller.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_elementor_jquery',
            'type'     => 'switch',
            'default'  => false,
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Frontend Elementor JQuery', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t use the default elementor elements. Make sure you disable this option if you want to use litespeed jquery combining.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_elementor_swiper',
            'type'     => 'switch',
            'default'  => true,
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Swiper Elementor Assets', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t use swiper slider from the elementor, like gallery slider etc.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_elementor_google_font',
            'type'     => 'switch',
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Load Elementor Google Font', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t use google fonts from the elementor, enable this option to prevent loading unused google fonts.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_emojis',
            'type'     => 'switch',
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Emojis', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t use emojis, enable this option to disable emojis.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_woocommerce_assets_out_of_shop',
            'type'     => 'switch',
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Woocommerce Assets out Of Shop', 'atlas-core'),
            'desc'    => esc_html__('By default woocommerce css/js load on all pages. Enable this option to load them just on woocommerce pages.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_woocommerce_block',
            'type'     => 'switch',
            'default'  => true,
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Woocommerce Gutenberg Blocks Assets', 'atlas-core'),
            'desc'    => esc_html__('If you don\'t use the WooCommerce Gutenberg Blocks.', 'atlas-core'),
        ),
        array(
            'id'       => 'disable_gutenberg_assets',
            'type'     => 'switch',
            'on'     => esc_html__('Disable', 'atlas-core'),
            'off'     => esc_html__('Enable', 'atlas-core'),
            'title'    => esc_html__('Disable Gutenberg Assets From Archives, Search & Elementor Pages', 'atlas-core'),
            'desc'    => esc_html__('By default gutenberg css load on all pages. Enable this option to disable load them from homepage, category & tag archives and pages build with Elementor.', 'atlas-core'),
        ),
        array(
            'id'       => 'contact7_page',
            'type'     => 'switch',
            'default'  => true,
            'on'     => esc_html__('Yes', 'atlas-core'),
            'off'     => esc_html__('No', 'atlas-core'),
            'title'    => esc_html__('Only load Contact Form 7 jquery/CSS on contact page template', 'atlas-core'),
            'desc'    => esc_html__('If you want to load jquery/CSS of Contact Form 7 only on contact page template. Disable it if you want to use Contact Form 7 shortcode to anywhere.', 'atlas-core'),
        ),
    )
) );
