<?php
Redux::set_section( $opt_name, array(
	'title'  => esc_html__( 'SEO', 'atlas-core' ),
	'heading' => esc_html__( 'SEO Settings', 'atlas-core' ),
	'id'     => 'section_seo',
	'subsection' => false,
    'icon'             => 'el el-graph',
	'fields' => array(

		array(
			'id'       => 'site_markup',
			'type'     => 'switch',
			'title'    => esc_html__( 'Sitelinks Search Box', 'atlas-core' ),
			'subtitle' => esc_html__( 'Enable or disable website markup, helps to show the Search Box feature for brand SERPs and can help your site name to appear in search results.', 'atlas-core' ),
			'switch'   => true,
			'default'  => $th90_def_options['site_markup'],
		),
		array(
			'id'       => 'site_desc',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Home Description', 'atlas-core' ),
			'subtitle' => esc_html__( 'Short description will display when searching your main site URL. Leave blank if you use 3rd plugins.', 'atlas-core' ),
			'default'  => ''
		),

		array(
			'id'       => 'post_rich_snippet',
			'type'     => 'switch',
			'title'    => esc_html__( 'Article Rich Snippets', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable the Article Rich Snippets.', 'atlas-core' ),
			'default'  => $th90_def_options['post_rich_snippet'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'       => 'post_schema_type',
			'type'     => 'select',
			'title'    => esc_html__( 'Default Schema type', 'atlas-core' ),
			'options'  => array(
				'Article' => 'Article',
				'NewsArticle' => 'NewsArticle',
				'BlogPosting' => 'BlogPosting',
			),
			'default'  => $th90_def_options['post_schema_type'],
			'required' => array(
				'post_rich_snippet',
				'=',
				true,
			),
		),
		array(
			'id'       => 'post_og_cards',
			'type'     => 'switch',
			'title'    => esc_html__( 'Open Graph meta', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable the Post Open Graph.', 'atlas-core' ),
			'default'  => $th90_def_options['post_og_cards'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'       => 'facebook_app_id',
			'type'     => 'text',
			'title'    => esc_html__( 'Facebook APP ID', 'atlas-core' ),
			'subtitle' => esc_html__( 'input your facebook app ID for OG tags.', 'atlas-core' ),
			'default'  => ''
		),
		array(
			'id'       => 'facebook_default_img',
			'type'     => 'media',
			'title'    => esc_html__( 'Facebook Default Image', 'atlas-core' ),
			'subtitle' => esc_html__( 'This image is used if the post/page being shared does not contain featured images.', 'atlas-core' ),
		),
	),
));
