<?php
Redux::set_section( $opt_name, array(
	'title'   => esc_html__( 'Search Page', 'atlas-core' ),
	'heading' => esc_html__( 'Search Page Settings', 'atlas-core' ),
	'id'      => 'search',
	'icon'    => 'el el-search',
	'fields'  => array(
		array(
			'id'       => 'search_template',
			'type'     => 'select',
			'title'    => esc_html__('Search template', 'atlas-core'),
			'subtitle' => esc_html__('Select the search template.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the search template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),
		array(
			'id'      => 'search_sidebar',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Search sidebar layout', 'atlas-core' ),
			'options' => $th90_def_options['sidebar_layouts'],
			'default' => $th90_def_options['search_sidebar'],
		),

		array(
			'id'       => 'search_post_types',
			'type'     => 'select',
			'multi'    => true,
			'title'    => esc_html__('Search post types', 'atlas-core'),
			'subtitle' => esc_html__('Limit search for custom post types.', 'atlas-core'),
			'data'     => 'post_types',
			'desc'     => esc_html__('WordPress search in all post types by default.', 'atlas-core'),
			'args'     => array(
				'exclude_from_search' => false,
			),
		),
	),
) );
