<?php
Redux::set_section( $opt_name, array(
	'title'  => esc_html__( 'Single Post', 'atlas-core' ),
	'heading'  => esc_html__( 'Single Post Settings', 'atlas-core' ),
	'id'     => 'post-settings',
	'icon'   => 'el el-align-left',
	'fields' => array(

		array(
			'id'      => 'post_layout',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Post layout', 'atlas-core' ),
			'options' => $th90_def_options['post_layouts'],
			'default' => $th90_def_options['post_layout'],
		),
		array(
			'id'       => 'featured_disable',
			'type'     => 'switch',
			'title'    => esc_html__( 'Disable featued image?', 'atlas-core' ),
			'subtitle' => esc_html__( 'If you want to disable featured image.', 'atlas-core' ),
			'default'  => false,
			'on'       => 'Yes',
			'off'      => 'No',
			'required' => array(
				array('post_layout', '=', array( '2','5' ) ),
			),
		),
		array(
			'id'               => 'featured_height',
			'type'             => 'slider',
			'title'            => esc_html__('Featured image height', 'atlas-core'),
			'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
			'default'        => $th90_def_options['featured_height'],
		    'min'           => 100,
		    'step'          => 1,
		    'max'           => 1920,
			'required' => array(
				array('post_layout', '=', array( '1','3','4' ) ),
			),
		),
		array(
			'id'       => 'post_sidebar_position',
			'type'     => 'select',
			'title'    => esc_html__( 'Post sidebar position', 'atlas-core' ),
			'options'  => array(
				'right'  => 'Right',
				'left'   => 'Left',
			),
			'default'  => $th90_def_options['post_sidebar_position'],
			'required' => array(
				array('post_layout', '=', array( '1','2','3' ) ),
			),
		),
		array(
			'id'       => 'box_post',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable box style?', 'atlas-core' ),
			'subtitle' => esc_html__( 'If you want to enable box with border on article content.', 'atlas-core' ),
			'default'  => $th90_def_options['box_post'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'breadcrumbs',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable breadcrumbs', 'yollo-core' ),
			'subtitle' => esc_html__( 'If you want to enable breadcrumbs.', 'yollo-core' ),
			'default'  => $th90_def_options['breadcrumbs'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'post_featured_ratio',
			'title'  => esc_html__( 'Featured image ratio', 'atlas-core' ),
			'type'     => 'select',
			'options'   => $th90_def_options['image_ratio'],
			'default'   => $th90_def_options['post_featured_ratio'],
		),
		array(
			'id'       => 'post_title_center',
			'type'     => 'switch',
			'title'    => esc_html__( 'Centered align of title?', 'atlas-core' ),
			'default'  => $th90_def_options['post_title_center'],
			'on'       => 'Yes',
			'off'      => 'No',
		),

		array(
			'id'       => 'post_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__( 'Post info', 'atlas-core' ),
			'subtitle'       => esc_html__( 'Check the post info you are going to show.', 'atlas-core' ),
			'options'  => $th90_def_options['post_infos_single'],
			'mode'		=> 'checkbox',
			'multi_layout' => 'half',
			'default' => $th90_def_options['post_meta'],
		),

		array(
			'id'       => 'post_meta_modern',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post info modern?', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to show modern style of post info.', 'atlas-core' ),
			'default'  => $th90_def_options['post_meta_modern'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),

		array(
			'id'       => 'meta_time_format',
			'title'  => esc_html__( 'Time format', 'atlas-core' ),
			'type'     => 'select',
			'options'  => array(
				'standard' => esc_html__( 'Wordpress Default', 'atlas-core' ),
				'modern'   => esc_html__( 'Relative Date (ago)', 'atlas-core' ),
			),
			'default'  => $th90_def_options['meta_time_format'],
		),

		array(
			'id'       => 'post_cats',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post categories', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the post categories.', 'atlas-core' ),
			'default'  => $th90_def_options['post_cats'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'       => 'post_cats_style',
			'title'  => esc_html__( 'Categories style', 'atlas-core' ),
			'type'     => 'select',
			'options'  => $th90_def_options['cats_style'],
			'default'  => $th90_def_options['post_cats_style'],
			'required' => array(
				'post_cats',
				'=',
				true,
			),
		),

		array(
			'id'       => 'post_tags',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post tags', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the post tags.', 'atlas-core' ),
			'default'  => $th90_def_options['post_tags'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),

		/*array(
			'id'       => 'section-article_nav-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Navigation', 'atlas-core' ),
			'indent'   => true,
		),*/
		array(
			'id'       => 'post_nav',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post navigation', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the post next prev navigation.', 'atlas-core' ),
			'default'  => $th90_def_options['post_nav'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),

		/*array(
			'id'       => 'section-article_author-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Author Box', 'atlas-core' ),
			'indent'   => true,
		),*/
		array(
			'id'       => 'post_author',
			'type'     => 'switch',
			'title'    => esc_html__( 'Author box', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the author info box.', 'atlas-core' ),
			'default'  => $th90_def_options['post_author'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),

		/*array(
			'id'       => 'section-article_comments-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Comments', 'atlas-core' ),
			'indent'   => true,
		),*/
		array(
			'id'       => 'post_comment',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post comment', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the post comment.', 'atlas-core' ),
			'default'  => $th90_def_options['post_comment'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'       => 'post_comment_collapse',
			'type'     => 'switch',
			'title'    => esc_html__( 'Post comment collapse', 'atlas-core' ),
			'subtitle'    => esc_html__( 'If you want make the comments be collapse and showing the toggle button to show it.', 'atlas-core' ),
			//'default'  => $th90_def_options['post_comment_collapse'],
			'on'       => 'Enable',
			'off'      => 'Disable',
			'required' => array(
				'post_comment',
				'=',
				true,
			),
		),

		array(
			'id'       => 'section-article_shares-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Shares', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'social_shares_post',
			'type'     => 'checkbox',
			'title'    => esc_html__( 'Social shares', 'atlas-core' ),
			'subtitle' => esc_html__( 'Check the social shares you are going to show.', 'atlas-core' ),
			'options'  => $th90_def_options['social_shares'],
			'mode'	   => 'checkbox',
			'multi_layout' => 'third',
			'default'  => $th90_def_options['social_shares_post'],
		),
		array(
			'id'       => 'social_shares_pos',
			'title'  => esc_html__( 'Social shares position', 'atlas-core' ),
			'type'     => 'select',
			'options'  => array(
				'sticky' => esc_html__( 'Sticky', 'atlas-core' ),
				'bottom' => esc_html__( 'Bottom', 'atlas-core' ),
				'meta' => esc_html__( 'On Post Meta', 'atlas-core' ),
			),
			'default'  => $th90_def_options['social_shares_pos'],
		),
		array(
			'id'       => 'social_shares_style',
			'title'  => esc_html__( 'Social shares style', 'atlas-core' ),
			'type'     => 'select',
			'options'  => array(
				'simple' => esc_html__( 'Simple', 'atlas-core' ),
				'circle' => esc_html__( 'Circle', 'atlas-core' ),
				'w_title' => esc_html__( 'With Title', 'atlas-core' ),
			),
			'default'  => $th90_def_options['social_shares_style'],
		),

		array(
			'id'       => 'section-article_infinite-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Ajax Infinite', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'single_ajax_post',
			'type'     => 'switch',
			'title'    => esc_html__( 'Infinite Load Next Posts', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable or disable ajax load next posts when scrolling down.', 'atlas-core' ),
			'default'  => $th90_def_options['single_ajax_post'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'       => 'single_ajax_cat',
			'type'     => 'switch',
			'title'    => esc_html__( 'Infinite Load Next Posts - Same Category', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Only load posts has same category with the current posts.', 'atlas-core' ),
			'default'  => $th90_def_options['single_ajax_cat'],
			'on'       => 'Yes',
			'off'      => 'No',
		),

		array(
			'id'       => 'section-reading_indicator-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Reading Indicator', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'reading_indicator',
			'type'     => 'switch',
			'title'    => esc_html__( 'Reading indicator', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable the Post Reading Indicator.', 'atlas-core' ),
			'default'  => $th90_def_options['reading_indicator'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		array(
			'id'               => 'reading_indicator_height',
			'type'             => 'slider',
			'title'            => esc_html__('Reading indicator height', 'atlas-core'),
			'subtitle'         => esc_html__( 'This is for reading indicator height.', 'atlas-core' ),
			'desc'             => esc_html__( 'Value on pixels.', 'atlas-core' ),
			'default'          => $th90_def_options['reading_indicator_height'],
			'min'           => 1,
			'step'          => 1,
			'max'           => 10,
			'output_variables' => true,
			'required' => array(
				'reading_indicator',
				'=',
				true,
			),
		),
		array(
			'id'      => 'reading_indicator_pos',
			'title'   => esc_html__( 'Reading indicator position', 'atlas-core' ),
			'type'    => 'select',
			'options' => array(
				'top'    => 'Top',
				'bottom' => 'Bottom',
			),
			'default' => $th90_def_options['reading_indicator_pos'],
			'required' => array(
				'reading_indicator',
				'=',
				true,
			),
		),

		array(
			'id'       => 'section-related_posts-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Related Posts', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'related_posts',
			'type'     => 'select',
			'title'    => esc_html__('Related Posts', 'atlas-core'),
			'subtitle' => esc_html__('Select the template to show related posts.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the custom template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),

		/*array(
			'id'       => 'post_content_top',
			'type'     => 'select',
			'title'    => esc_html__('Top template', 'atlas-core'),
			'subtitle' => esc_html__('Select the template to show in top of the post. Usually for showing advertisement and others...', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the custom template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),

		array(
			'id'       => 'post_content_bottom',
			'type'     => 'select',
			'title'    => esc_html__('Bottom template', 'atlas-core'),
			'subtitle' => esc_html__('Select the template to show in bottom of the post. Usually for showing related posts, advertisement, and others...', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the custom template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),

		array(
			'id'       => 'lightbox_image_post',
			'type'     => 'switch',
			'title'    => esc_html__( 'Lightbox for Post Images', 'atlas-core' ),
			'subtitle'	=> esc_html__( 'Enable Lightbox automatically for all images linked to an image file in the post content area', 'atlas-core' ),
			'default'  => $th90_def_options['lightbox_image_post'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'lightbox_gallery_post',
			'type'     => 'switch',
			'title'    => esc_html__( 'Lightbox for Post Galleries', 'atlas-core' ),
			'subtitle'	=> esc_html__( 'Enable Lightbox automatically for all images added via [gallery] shortcode in the post content area', 'atlas-core' ),
			'default'  => $th90_def_options['lightbox_gallery_post'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'post_subscribe',
			'type'     => 'switch',
			'title'    => esc_html__( 'Subscribe box', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Enable to display the subscribe box.', 'atlas-core' ),
			'default'  => $th90_def_options['post_subscribe'],
			'on'       => 'Enable',
			'off'      => 'Disable',
		),
		*/

		array(
			'id'       => 'section-article_typo-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Content/Article Fonts', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'      => 'link_content',
			'title'   => esc_html__( 'Hyperlink style', 'atlas-core' ),
			'type'    => 'select',
			'options' => array(
				'none'    => 'None',
				'color' => 'Colored',
				'underline' => 'Underline',
			),
			'default' => 'none',
		),
		array(
			'id'               => 'post_content_typo',
			'type'             => 'typography',
			'title'            => esc_html__( 'Article font', 'atlas-core' ),
			'font-family'      => false,
			'google'           => false,
			'subsets'          => false,
			'preview'          => false,
			'text-align'       => false,
			'color'            => false,
			'font-style'       => false,
			'font-weight'      => false,
			'text-transform'   => false,
			'all_styles'       => false,
			'line-height'      => true,
			'letter-spacing'   => true,
			'font-size'        => true,
			'output_variables' => true,
			'units'            => 'em',
			'output'           => $th90_def_output['post_content_typo'],
			'default'  => $th90_def_options['post_content_typo'],
		),
		array(
			'id'               => 'post_heading_typo',
			'type'             => 'typography',
			'title'            => esc_html__( 'Article Title font', 'atlas-core' ),
			'google'           => true,
			'subsets'          => false,
			'preview'             => array(
				'text'               => $th90_def_options['ipsum_text'],
				'always_display'     => false,
			),
			'text-align'       => false,
			'line-height'      => false,
			'color'            => false,
			'text-transform'   => true,
			'letter-spacing'   => true,
			'letter-spacing-unit' => 'em',
			'output'           => $th90_def_output['post_heading_typo'],
			'default'  => $th90_def_options['post_heading_typo'],
			'output_variables' => false,
		),

		array(
			'id'       => 'post_excerpt_typo',
			'type'     => 'typography',
			'title'    => esc_html__( 'Article Excerpt font', 'atlas-core' ),
			'google'   => true,
			'subsets'  => false,
			'preview'             => array(
				'text'               => $th90_def_options['ipsum_text'],
				'always_display'     => false,
			),
			'text-align' => false,
			'line-height' => false,
			'color'    => false,
			'text-transform' => true,
			'letter-spacing' => true,
			'letter-spacing-unit' => 'em',
			'output'  => $th90_def_output['post_excerpt_typo'],
			'default'  => $th90_def_options['post_excerpt_typo'],
			'output_variables' => false,
		),

		array(
			'id'       => 'section-article_hook-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Hooks', 'atlas-core' ),
			'indent'   => true,
		),

		array(
			'id'       => 'hook_article_before',
			'type'     => 'select',
			'title'    => esc_html__( 'Article before', 'atlas-core' ),
			'subtitle' => esc_html__('Template will execute before the article content.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),
		array(
			'id'       => 'hook_article_after',
			'type'     => 'select',
			'title'    => esc_html__( 'Article after', 'atlas-core' ),
			'subtitle' => esc_html__('Template will execute after the article content.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),
	),
) );
