<?php
Redux::set_section( $opt_name, array(
	'title'   => esc_html__( 'OffCanvas & Mobile Menu', 'atlas-core' ),
	'heading' => esc_html__( 'OffCanvas & Mobile Menu Settings', 'atlas-core' ),
	'id'      => 'offcanvas',
	'icon'    => 'el el-lines',
	'fields' => array_merge(
		array(
			array(
				'id'       => 'offcanvas_template',
				'type'     => 'select',
				'title'    => esc_html__('Offcanvas template', 'atlas-core'),
				'subtitle' => esc_html__('Select the offcanvas template.', 'atlas-core'),
				'desc'	=> sprintf( esc_html__( 'You can create the offcanvas template from %1$ssidebar builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_sidebar') . '"><strong>', '</strong></a>' ),
				'options'  => th90_get_posts_id( 'th90_sidebar' ),
				'placeholder'  => esc_html__('Select sidebar', 'atlas-core'),
			),

			array(
				'id'           => 'offcanvas_width',
				'type'         => 'dimensions',
				'title'         => esc_html__('Offcanvas width', 'atlas-core'),
				'units'        => array('px','%'),
				'height'       => false,
				'default'      => $th90_def_options['offcanvas_width'],
				'output_variables' => true,
			),

			array(
				'id'      => 'offcanvas_bg',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Skin', 'atlas-core' ),
				'subtitle' => esc_html__( 'Control the offcanvas skin.', 'atlas-core' ),
				'desc'	=> sprintf( esc_html__( 'You can customize the skin elements color from %1$sskin colors settings%2$s.', 'atlas-core' ), '<a href="' . admin_url('?page=th90_options&tab=3') . '"><strong>', '</strong></a>' ),
				'options' => $th90_def_options['skins_section'],
				'default' => $th90_def_options['offcanvas_bg'],
			),
			array(
				'id'          => 'off_overlay_light',
				'type'        => 'color_rgba',
				'title'       => esc_html__( 'Overay color - Light Skin', 'atlas-core' ),
				'subtitle' => esc_html__('Custom overlay background color.', 'atlas-core'),
				'transparent' => false,
				'default'   => array(
			        'color'     => '#f5f8fa',
			        'alpha'     => 1
			    ),
				'output_variables'    => true,
			),
			array(
				'id'          => 'off_overlay_dark',
				'type'        => 'color_rgba',
				'title'       => esc_html__( 'Overay color - Dark Skin', 'atlas-core' ),
				'subtitle' => esc_html__('Custom overlay background color.', 'atlas-core'),
				'transparent' => false,
				'default'   => array(
			        'color'     => '#161617',
			        'alpha'     => 1
			    ),
				'output_variables'    => true,
			),
			array(
				'id'       => 'show_offcanvas_logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show offcanvas logo?', 'atlas-core' ),
				'default'  => $th90_def_options['show_offcanvas_logo'],
				'on'       => 'Yes',
				'off'      => 'No',
			),
		),


		array(
			array(
				'id' 	=> 'section-offCanvas_menu-start',
				'type' 	=> 'section',
				'title' 	=> esc_html__( 'Mobile Menu & AMP Menu Settings', 'atlas-core' ),
				'indent' 	=> true,
			),
			array(
				'id'                  => 'mobile_menu_typo',
				'type'                => 'typography',
				'title'               => esc_html__( 'Mobile menu item typography', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'line-height'         => true,
				'color'               => false,
				'text-transform'      => true,
				'letter-spacing'      => true,
				'letter-spacing-unit' => 'em',
				'default' => $th90_def_options['mobile_menu_typo'],
				'output'              => $th90_def_output['mobile_menu_typo'],
				'output_variables'    => false,
			),
		)
	),
) );
