<?php
/* Header */
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'Header', 'atlas-core' ),
	'heading'    => '',
	'id'         => 'header_section',
	'subtitle'   => '',
	'icon'     => 'el el-caret-up',
	'fields'   => array_merge(
		array(
			array(
				'id'       => 'header_template',
				'type'     => 'select',
				'title'    => esc_html__('Main Header - Template', 'atlas-core'),
				'subtitle' => esc_html__('Select the main header template.', 'atlas-core'),
				'desc'	=> sprintf( esc_html__( 'You can create the main header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
				'options'  => th90_get_posts_id( 'th90_block' ),
				'placeholder'  => esc_html__('Select main header', 'atlas-core'),
			),

			array(
				'id'       => 'topheader_template',
				'type'     => 'select',
				'title'    => esc_html__('Top Header - Template', 'atlas-core'),
				'subtitle' => esc_html__('Select the top header template.', 'atlas-core'),
				'desc'	=> sprintf( esc_html__( 'You can create the top header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
				'options'  => th90_get_posts_id( 'th90_block' ),
				'placeholder'  => esc_html__('Select top header', 'atlas-core'),
			),
			array(
				'id'               => 'header_space',
				'type'             => 'slider',
				'title'            => esc_html__('Header space', 'atlas-core'),
				'subtitle'         => esc_html__('Space between header & content. Not used for frontpage page template.', 'atlas-core'),
				'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
				'default'          => $th90_def_options['header_space'],
			    'min'           => 0,
			    'step'          => 1,
			    'max'           => 100,
				'output_variables' => true,
			),
			array(
		        'id' 	=> 'section-header_mobile-start',
		        'type' 	=> 'section',
		        'title' 	=> esc_html__( 'Mobile Header', 'atlas-core' ),
				'indent' 	=> true,
		    ),
			array(
				'id'       => 'mob_header_template',
				'type'     => 'select',
				'title'    => esc_html__('Mobile Header - Template', 'atlas-core'),
				'subtitle' => esc_html__('Select the mobile header template.', 'atlas-core'),
				'desc'	=> sprintf( esc_html__( 'You can create the mobile header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
				'options'  => th90_get_posts_id( 'th90_block' ),
				'placeholder'  => esc_html__('Select mobile header', 'atlas-core'),
			),
			array(
				'id'               => 'mheader_space',
				'type'             => 'slider',
				'title'            => esc_html__('Mobile header space', 'atlas-core'),
				'subtitle'         => esc_html__('Space between mobile header & content. Not used for frontpage page template.', 'atlas-core'),
				'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
				'default'          => $th90_def_options['mheader_space'],
			    'min'           => 0,
			    'step'          => 1,
			    'max'           => 100,
				'output_variables' => true,
			),
			array(
		        'id' 	=> 'section-header_sticky-start',
		        'type' 	=> 'section',
		        'title' 	=> esc_html__( 'Sticky Header', 'atlas-core' ),
				'indent' 	=> true,
		    ),
			array(
				'id'       => 'sticky_behaviour',
				'type'     => 'select',
				'title'    => esc_html__('Sticky Header Showing', 'atlas-core'),
				'subtitle' => esc_html__('Select sticky header showing behaviour.', 'atlas-core'),
				'options'  => array(
					'both' => esc_html__('When Scroll Up & Down', 'atlas-core'),
					'up' => esc_html__('When Scroll Up', 'atlas-core'),
					'down' => esc_html__('When Scroll Down', 'atlas-core'),
					'disable' => esc_html__('Disable', 'atlas-core'),
				),
				'default'  => $th90_def_options['sticky_behaviour'],
			),
			array(
				'id'       => 'sticky_template',
				'type'     => 'select',
				'title'    => esc_html__('Sticky Header Template', 'atlas-core'),
				'subtitle' => esc_html__('Select the sticky header template.', 'atlas-core'),
				'desc'	=> sprintf( esc_html__( 'You can create the sticky header template from %1$sblock builder%2$s. Leave blank if you want like main header.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
				'options'  => th90_get_posts_id( 'th90_block' ),
				'placeholder'  => esc_html__('Select sticky header', 'atlas-core'),
			),
		),
	),
));
