<?php
Redux::set_section( $opt_name, array(
	'title'   => esc_html__( 'General', 'atlas-core' ),
	'heading' => esc_html__( 'Site Layout', 'atlas-core' ),
	'id'      => 'section_general',
	'icon'    => 'el el-cog',
) );

/* Sub - Site Layout */
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'General', 'atlas-core' ),
	'heading'    => esc_html__( 'Site Layout Settings', 'atlas-core' ),
	'id'         => 'section_general_layout',
	'subtitle'   => '',
    'subsection' => true,
	'fields'  => array(
		array(
			'id'               => 'site_width',
			'type'             => 'slider',
			'title'            => esc_html__('Container width', 'atlas-core'),
			'subtitle'         => esc_html__('Set the maximum width of site container.', 'atlas-core'),
			'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
			'default'          => $th90_def_options['site_width'],
		    'min'           => 800,
		    'step'          => 1,
		    'max'           => 1920,
			'output_variables' => true,
		),
		array(
			'id'               => 'content_width',
			'type'             => 'slider',
			'title'            => esc_html__('Content width', 'atlas-core'),
			'subtitle'         => esc_html__('Set the content width. The sidebar width will adapted.', 'atlas-core'),
			'desc'             => esc_html__( 'Value on percentages (%)', 'atlas-core' ),
			'default'          => $th90_def_options['content_width'],
		    'min'           => 50,
		    'step'          => 1,
		    'max'           => 80,
			'output_variables' => true,
		),
		array(
			'id'       => 'sidebar_sticky',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable sticky sidebar', 'atlas-core' ),
			'default'  => $th90_def_options['sidebar_sticky'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		/*array(
			'id'       => 'section-box-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Box Settings', 'atlas-core' ),
			'indent'   => true,
		),*/
		array(
			'id'       => 'box_active',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable box style', 'atlas-core' ),
			'subtitle' => esc_html__( 'If you want to enable box on elements.', 'atlas-core' ),
			'default'  => $th90_def_options['box_active'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'box_style',
			'type'     => 'select',
			'title'    => esc_html__('Box style', 'atlas-core'),
			'subtitle' => esc_html__('Select style of element & container box style.', 'atlas-core'),
			'options'  => array(
				'solid' => esc_html__('Solid', 'atlas-core'),
				'outline' => esc_html__('Outline', 'atlas-core'),
			),
			'default'  => $th90_def_options['box_style'],
		),
		array(
			'id'               => 'box_radius',
			'type'             => 'slider',
			'title'            => esc_html__('Box border radius', 'atlas-core'),
			'default' 		=> $th90_def_options['box_radius'],
		    'min'           => 0,
		    'step'          => 1,
			'resolution' 	=> 1,
		    'max'           => 100,
			'output_variables' => true,
		),
		array(
			'id'               => 'button_radius',
			'type'             => 'slider',
			'title'            => esc_html__('Button & Input radius', 'atlas-core'),
			'default' 		=> $th90_def_options['button_radius'],
		    'min'           => 0,
		    'step'          => 1,
			'resolution' 	=> 1,
		    'max'           => 100,
			'output_variables' => true,
		),
		array(
			'id'               => 'image_radius',
			'type'             => 'slider',
			'title'            => esc_html__('Image radius', 'atlas-core'),
			'default' 		=> $th90_def_options['image_radius'],
		    'min'           => 0,
		    'step'          => 1,
			'resolution' 	=> 1,
		    'max'           => 100,
			'output_variables' => true,
		),

		array(
			'id'       => 'section-widget_heading-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Widget Heading Settings', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wheading_style',
			'type'     => 'select',
			'title'    => esc_html__('Heading style', 'atlas-core'),
			'subtitle' => esc_html__('Select style of element & container box style.', 'atlas-core'),
			'options'  => array(
				'simple' => esc_html__('Simple', 'atlas-core'),
				'brd' => esc_html__('With Border', 'atlas-core'),
				'bg' => esc_html__('With Background', 'atlas-core'),
			),
			'default'  => $th90_def_options['wheading_style'],
		),
		array(
			'id'       => 'wheading_center',
			'type'     => 'switch',
			'title'    => esc_html__( 'Center align', 'atlas-core' ),
			'subtitle' => esc_html__('Centered alignment of widget heading.', 'atlas-core'),
			'default'  => $th90_def_options['wheading_center'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'          => 'wheading_bg',
			'type'        => 'color',
			'title'       => esc_html__( 'Background color', 'atlas-core' ),
			'subtitle' => esc_html__('Custom background color of widget heading.', 'atlas-core'),
			'transparent' => false,
			'default'     => '',
			'output'      => $th90_def_output['wheading_bg'],
			'required' => array(
				array('wheading_style', '=', 'bg'),
			),
		),
		array(
			'id'          => 'wheading_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Text color', 'atlas-core' ),
			'subtitle' => esc_html__('Custom text color of widget heading.', 'atlas-core'),
			'transparent' => false,
			'default'     => '',
			'output'      => $th90_def_output['wheading_color'],
			'required' => array(
				array('wheading_style', '=', 'bg'),
			),
		),



		/*array(
			'id'          => 'site_bg',
			'type'        => 'color',
			'title'       => esc_html__( 'Site background color', 'atlas-core' ),
			'transparent' => false,
			'output_variables' => true,
			'default'      => $th90_def_options['site_bg'],
		),
		array(
			'id'       => 'site_decor',
			'type'     => 'select',
			'title'    => esc_html__('Site decoration', 'atlas-core'),
			'subtitle' => esc_html__('Select site decoration background.', 'atlas-core'),
			'options'  => $th90_def_options['bg_decors'],
			'default'  => $th90_def_options['site_decor'],
		),
		array(
			'id'               => 'decor_color',
			'type'             => 'color_rgba',
			'title'            => esc_html__( 'Decoration - color', 'atlas-core' ),
			'transparent'      => false,
			'default'          => $th90_def_options['decor_color'],
			'output_variables' => true,
			'required' => array(
				array('site_decor', '!=', 'none'),
			),
		),
		array(
			'id'               => 'decor_size',
			'type'             => 'slider',
			'title'            => esc_html__('Decoration - size', 'atlas-core'),
			'default' 		=> 50,
		    'min'           => 1,
		    'step'          => 1,
			'resolution' 	=> 1,
		    'max'           => 100,
			'output_variables' => true,
			'required' => array(
				array('site_decor', '!=', 'none'),
			),
		),

		array(
		    'id'       => 'site_docor_custom',
		    'type'     => 'background',
		    'title'    => esc_html__('Site custom background', 'weekz-core'),
		   	'default' => $th90_def_options['site_bg_custom'],
			'output'      => $th90_def_output['site_bg_custom'],
			'required' => array(
				array( 'site_bg', '=', array( 'custom' ) ),
			),
		),


		array(
			'id'       => 'noise_bg',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable noise background', 'atlas-core' ),
			'subtitle' => esc_html__('Add noise background on site.', 'atlas-core'),
			'default'  => $th90_def_options['noise_bg'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'               => 'noise_bg_opacity',
			'type'             => 'slider',
			'title'            => esc_html__('Noise - opacity', 'atlas-core'),
			'default' 		=> 0.2,
		    'min'           => 0,
		    'step'          => .1,
			'resolution' 	=> 0.1,
		    'max'           => 1,
			'output_variables' => true,
			'required' => array(
				array('noise_bg', '=', true),
			),
		),

		array(
			'id'       => 'image_grayscale',
			'type'     => 'switch',
			'title'    => esc_html__( 'Grayscale image?', 'atlas-core' ),
			'subtitle' => esc_html__( 'If you want to make post image be grayscale and hover to normal colors.', 'atlas-core' ),
			'default'  => $th90_def_options['image_grayscale'],
			'on'       => 'Yes',
			'off'      => 'No',
		),*/
		array(
			'id'       => 'section-util-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Utilities', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'scroll_top',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable scroll to top?', 'atlas-core' ),
			'subtitle' => esc_html__( 'If you want to enable scroll to top button.', 'atlas-core' ),
			'default'  => $th90_def_options['scroll_top'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
		array(
			'id'       => 'cat_colors',
			'type'     => 'switch',
			'title'    => esc_html__( 'Category colors?', 'katerio-core' ),
			'subtitle' => esc_html__( 'If you want to show categories color. If not, the categories will show the accent color.', 'katerio-core' ),
			'default'  => $th90_def_options['cat_colors'],
			'on'       => 'Yes',
			'off'      => 'No',
		),
	),
) );

/* Sub - Skin Colors */
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'Skin Settings', 'atlas-core' ),
	'heading'    => esc_html__( 'Skin Colors Settings', 'atlas-core' ),
	'id'         => 'section_general_skins',
	'subtitle'   => '',
    'subsection' => true,
	'fields'  => array_merge(
		array(
			array(
				'id'      => 'site_skin',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Site skin', 'atlas-core' ),
				'desc'	=> sprintf( esc_html__( 'You can customize the skin elements color from %1$sskin colors settings%2$s.', 'atlas-core' ), '<a href="' . admin_url('?page=th90_options&tab=3') . '"><strong>', '</strong></a>' ),
				'options' => $th90_def_options['skins'],
				'default' => $th90_def_options['site_skin'],
			),
			array(
				'id'       => 'skin_switcher',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable skin switcher?', 'katerio-core' ),
				'subtitle' => esc_html__( 'Check if you want to show flyout skin dark/light switcher.', 'katerio-core' ),
				'on'       => 'Yes',
				'off'      => 'No',
				'default'  => $th90_def_options['skin_switcher'],
				'required' => array(
					array('site_skin', '=', 'light'),
				),
			),
		),
		th90_skin_redux_options( 'light', $th90_def_options, $th90_def_output ),
		th90_skin_redux_options( 'dark', $th90_def_options, $th90_def_output ),
		array(
			array(
				'id'        => 'accent-start',
				'type'      => 'accordion',
				'title'     => 'Accent colors settings',
				'subtitle'  => '',
				'position'  => 'start',
			),
			array(
				'id'               => 'color-accent',
				'type'             => 'color',
				'title'            => esc_html__( 'Accent color', 'atlas-core' ),
				'subtitle'         => esc_html__( 'Used for some elements.', 'atlas-core' ),
				'transparent'      => false,
				'default'          => $th90_def_options['color-accent'],
				'output_variables' => true,
			),
			array(
				'id'               => 'color-accent-text',
				'type'             => 'color',
				'title'            => esc_html__( 'Text accent color', 'atlas-core' ),
				'subtitle'         => esc_html__( 'Used for text if that have accent color background.', 'atlas-core' ),
				'transparent'      => false,
				'default'          => $th90_def_options['color-accent-text'],
				'output_variables' => true,
			),
			/*array(
				'id'               => 'sec-color-accent',
				'type'             => 'color',
				'title'            => esc_html__( 'Accent color - Secondary', 'atlas-core' ),
				'subtitle'         => esc_html__( 'Used for some elements.', 'atlas-core' ),
				'transparent'      => false,
				'default'          => $th90_def_options['color-accent'],
				'output_variables' => true,
			),
			array(
				'id'               => 'sec-color-accent-text',
				'type'             => 'color',
				'title'            => esc_html__( 'Text accent color - Secondary', 'atlas-core' ),
				'subtitle'         => esc_html__( 'Used for text if that have secondary accent color background.', 'atlas-core' ),
				'transparent'      => false,
				'default'          => $th90_def_options['color-accent-text'],
				'output_variables' => true,
			),*/
			array(
			    'id'        => 'accent-end',
			    'type'      => 'accordion',
			    'position'  => 'end'
			),
		)
	),
));

/* Sub - Typography */
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'Fonts', 'atlas-core' ),
	'heading'    => esc_html__( 'General Font', 'atlas-core' ),
	'desc' => esc_html__( 'This is general font settings. Some elements font isn\'t included here. You can found the font settings on their section settings.', 'atlas-core' ),
	'id'         => 'section_general_font',
	'subtitle'   => '',
    'subsection' => true,
	'fields'  => array_merge(
		array(
			array(
				'id'                  => 'primary_text',
				'type'                => 'typography',
				'title'               => esc_html__( 'Primary font', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'color'               => false,
				'text-transform'      => false,
				'all_styles'          => true,
				'letter-spacing'      => true,
				'line-height-unit'    => '',
				'letter-spacing-unit' => 'em',
				'default'             => $th90_def_options['primary_text'],
				'output_variables'    => false,

			),
			array(
				'id'                  => 'second_text',
				'type'                => 'typography',
				'title'               => esc_html__( 'Secondary font', 'atlas-core' ),
				'subtitle'            => esc_html__( 'Used for elements & info', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'color'               => false,
				'text-transform'      => true,
				'all_styles'          => false,
				'letter-spacing'      => true,
				'line-height-unit'    => '',
				'letter-spacing-unit' => 'em',
				'default'             => $th90_def_options['second_text'],
				'output_variables'    => false,
			),
			array(
				'id'       => 'section-typo_heading-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading Font', 'atlas-core' ),
				'indent'   => true,
			),
			array(
				'id'               => 'font_heading',
				'type'             => 'typography',
				'title'            => esc_html__( 'Headings font', 'atlas-core' ),
				'subtitle'         => esc_html__( 'Used for H1, H2, H3, H4, H5, and H6', 'atlas-core' ),
				'google'           => true,
				'subsets'          => false,
				'preview'          => array(
					'text'            => $th90_def_options['ipsum_text'],
					'always_display'  => false,
					'font-size'		=> '30px',
				),
				'text-align'       => false,
				'color'            => false,
				'font-size'        => false,
				'text-transform'   => true,
				'all_styles'       => false,
				'line-height'      => true,
				'letter-spacing'   => true,
				'units'            => 'em',
				'line-height-unit'    => '',
				'default'          => $th90_def_options['font_heading'],
				'output_variables' => false,
			),
			array(
				'id'                  => 'widget_head_typo',
				'type'                => 'typography',
				'title'               => esc_html__( 'Widget heading typography', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'line-height'         => false,
				'letter-spacing-unit' => 'em',
				'preview'             => array(
					'text'               => 'Widget Heading',
					'always_display'     => false,
				),
				'text-align'       => false,
				'color'            => false,
				'text-transform'   => true,
				'letter-spacing'   => true,
				'default'          => $th90_def_options['widget_head_typo'],
				'output'           => $th90_def_output['widget_head_typo'],
				'output_variables' => false,
			),
		),

		th90_heading_size_opt( 'desktop', $th90_def_options, $th90_def_output ),
		th90_heading_size_opt( 'tablet', $th90_def_options, $th90_def_output ),
		th90_heading_size_opt( 'mobile', $th90_def_options, $th90_def_output )

		/*array(
			array(
				'id'       => 'section-typo_util-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Utility Typography', 'atlas-core' ),
				'indent'   => true,
			),
			array(
				'id'                  => 'input_typo',
				'type'                => 'typography',
				'title'               => esc_html__( 'Form input font', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'line-height'         => false,
				'letter-spacing-unit' => 'em',
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'color'               => false,
				'text-transform'      => true,
				'letter-spacing'      => true,
				'default'             => $th90_def_options['input_typo'],
				'output'              => $th90_def_output['input_typo'],
				'output_variables'    => false,
			),
			array(
				'id'                  => 'button_typo',
				'type'                => 'typography',
				'title'               => esc_html__( 'Button font', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'line-height'         => false,
				'letter-spacing-unit' => 'em',
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'color'               => false,
				'text-transform'      => true,
				'letter-spacing'      => true,
				'default'             => $th90_def_options['button_typo'],
				'output'              => $th90_def_output['button_typo'],
				'output_variables'    => false,
			),
			array(
				'id'                  => 'excerpt_typo',
				'type'                => 'typography',
				'title'               => esc_html__( 'Blog excerpt font', 'atlas-core' ),
				'google'              => true,
				'subsets'             => false,
				'line-height'         => false,
				'letter-spacing-unit' => 'em',
				'preview'             => array(
					'text'               => $th90_def_options['ipsum_text'],
					'always_display'     => false,
				),
				'text-align'          => false,
				'color'               => false,
				'text-transform'      => true,
				'letter-spacing'      => true,
				'default' => $th90_def_options['excerpt_typo'],
				'output'              => $th90_def_output['excerpt_typo'],
				'output_variables'    => false,
			),
		)*/
	),
));

/* Box Settings
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'Box Settings', 'atlas-core' ),
	'heading'    => esc_html__( 'Box Settings', 'atlas-core' ),
	'id'         => 'section_box_settings',
	'subtitle'   => '',
    'subsection' => true,
	'fields'  => array(

	),
) );
*/
/* Sub - Form & Button
Redux::set_section( $opt_name, array(
	'title'      => esc_html__( 'Form & Button', 'atlas-core' ),
	'heading'    => esc_html__( 'Form & Button Settings', 'atlas-core' ),
	'id'         => 'section_general_form_button',
	'subtitle'   => '',
    'subsection' => true,
	'fields'  => array(
		array(
			'id'               => 'form_radius',
			'type'             => 'slider',
			'title'            => esc_html__('Form border radius', 'atlas-core'),
			'subtitle'         => esc_html__('Set the form fields border radius.', 'atlas-core'),
			'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
			'default'          => $th90_def_options['form_radius'],
		    'min'           => 0,
		    'step'          => 1,
		    'max'           => 100,
			'output_variables' => true,
		),
		array(
			'id'               => 'button_radius',
			'type'             => 'slider',
			'title'            => esc_html__('Button border radius', 'atlas-core'),
			'subtitle'         => esc_html__('Set the button border radius.', 'atlas-core'),
			'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
			'default'          => $th90_def_options['button_radius'],
		    'min'           => 0,
		    'step'          => 1,
		    'max'           => 100,
			'output_variables' => true,
		),
	),
) );*/

/* Sub - Preloader
Redux::set_section( $opt_name, array(
	'title'  => esc_html__( 'Preloader', 'atlas-core' ),
	'heading' => esc_html__( 'Preloader Settings', 'atlas-core' ),
	'id'     => 'preloader_settings',
	'subsection' => true,
	'fields' => array(
		array(
			'id'       => 'preloader_all',
			'type'     => 'switch',
			'title'    => esc_html__( 'Activate preloader on all pages?', 'atlas-core' ),
			'subtitle' => esc_html__( 'Check if you want to show preloader on all pages.', 'atlas-core' ),
			'on'       => 'Yes',
			'off'      => 'No',
			'default'  => $th90_def_options['preloader_all'],
		),
		array(
			'id'          => 'preloader_bg_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Background color', 'atlas-core' ),
			'transparent' => false,
			'output_variables' => true,
			'default' => $th90_def_options['preloader_bg_color'],
		),
		array(
			'id'       => 'preloader_text',
			'type'     => 'text',
			'title'    => esc_html__( 'Preloader text', 'atlas-core' ),
			'default'  => 'Loading',
		),
		array(
			'id'                  => 'preloader_font',
			'type'                => 'typography',
			'title'               => esc_html__( 'Preloader font', 'atlas-core' ),
			'google'              => true,
			'subsets'             => false,
			'preview'             => array(
				'text'               => 'LOADING',
				'always_display'     => false,
			),
			'text-align'          => false,
			'color'               => true,
			'text-transform'      => true,
			'all_styles'          => false,
			'letter-spacing'      => true,
			'line-height-unit'    => '',
			'letter-spacing-unit' => 'em',
			'text-shadow'         => true,

			'default'             => array(
				'shadow-color'        => '',
				'shadow-horizontal'   => 4,
				'shadow-vertical'     => 4,
				'shadow-blur'         => 0,
			),
			'output'              => $th90_def_output['preloader_font'],
			'output_variables'    => false,

		),
	),
));*/

/* Sub - Subscribe Popup
Redux::set_section( $opt_name, array(
    'title'  => esc_html__( 'Subscribe Popup', 'atlas-core' ),
    'heading' => esc_html__( 'Subscribe Popup Settings', 'atlas-core' ),
    'id'     => 'section_utils_newsletter',
    'subsection' => true,
    'fields' => array(
		array(
			'id'      => 'newsletter_skin',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Newsletter skin', 'atlas-core' ),
			'subtitle' => esc_html__( 'Control the newsletter skin.', 'atlas-core' ),
			'desc'	=> sprintf( esc_html__( 'You can customize the skin elements color from %1$sskin colors settings%2$s.', 'atlas-core' ), '<a href="' . admin_url('?page=th90_options&tab=3') . '"><strong>', '</strong></a>' ),
			'options' => $th90_def_options['skins_section'],
			'default' => $th90_def_options['newsletter_skin'],
		),

		array(
		    'id'            => 'newsletter_bg_custom',
		    'type'          => 'color',
		    'title'         => esc_html__( 'Background color', 'atlas-core' ),
			'subtitle'       => esc_html__( 'Custom background color', 'atlas-core' ),
			'transparent'	=> false,
			'output'  => $th90_def_output['newsletter_bg_custom'],
			'default' => $th90_def_options['newsletter_bg_custom'],
		),
        array(
            'id'       => 'newsletter_form',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Mailchimp Form Shortcode', 'atlas-core' ),
            'default'  => $th90_def_options['newsletter_form'],
        ),
        array(
			'id'               => 'newsletter_width',
			'type'             => 'slider',
			'title'            => esc_html__('Newsletter popup width', 'atlas-core'),
			'desc'             => esc_html__( 'Value on pixels (px)', 'atlas-core' ),
			'default'          => $th90_def_options['newsletter_width'],
		    'min'             => 200,
		    'step'            => 1,
		    'max'             => 1000,
			'output_variables' => true,
		),

        array(
            'id'       => 'newsletter_popup_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Newsletter Title', 'atlas-core' ),
            'subtitle' => esc_html__( 'Input newsletter form title.', 'atlas-core' ),
            'default'  => $th90_def_options['newsletter_popup_title'],
        ),
        array(
            'id'       => 'newsletter_popup_desc',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Newsletter Description', 'atlas-core' ),
            'subtitle' => esc_html__( 'Input newsletter form description.', 'atlas-core' ),
            'default'  => $th90_def_options['newsletter_popup_desc'],
        ),
        array(
            'id'       => 'newsletter_popup_center',
            'type'     => 'switch',
            'title'    => esc_html__( 'Newsletter Content Center?', 'atlas-core' ),
            'subtitle' => esc_html__( 'If you want to make content be centered.', 'atlas-core' ),
            'default'  => $th90_def_options['newsletter_popup_center'],
            'on'       => 'Yes',
            'off'      => 'No',
        ),
        array(
			'id'                  => 'newsletter_popup_title_typo',
			'type'                => 'typography',
			'title'               => esc_html__( 'Newsletter title font', 'atlas-core' ),
			'google'              => true,
			'subsets'             => false,
			'preview'             => array(
				'text'               => $th90_def_options['ipsum_text'],
				'always_display'     => false,
			),
			'text-align'          => false,
			'line-height'         => false,
			'color'               => false,
			'text-transform'      => true,
			'letter-spacing'      => true,
			'letter-spacing-unit' => 'em',
			'output'              => $th90_def_output['newsletter_popup_title_typo'],
			'default' => $th90_def_options['newsletter_popup_title_typo'],
			'output_variables'    => false,
			'font-size'           => false,
		),
        array(
			'id'                  => 'newsletter_popup_desc_typo',
			'type'                => 'typography',
			'title'               => esc_html__( 'Newsletter description font', 'atlas-core' ),
			'google'              => true,
			'subsets'             => false,
			'preview'             => array(
				'text'               => $th90_def_options['ipsum_text'],
				'always_display'     => false,
			),
			'text-align'          => false,
			'line-height'         => false,
			'color'               => false,
			'text-transform'      => true,
			'letter-spacing'      => true,
			'letter-spacing-unit' => 'em',
			'output'              => $th90_def_output['newsletter_popup_desc_typo'],
			'default' => $th90_def_options['newsletter_popup_desc_typo'],
			'output_variables'    => false,
		),

    ),
) ); */
