<?php
Redux::set_section( $opt_name, array(
	'title'  => esc_html__( 'Blog & Archives', 'atlas-core' ),
	'desc' => esc_html__( 'This settings used for blog, category, tag, author, date, custom post type, and custom taxonomy based archives', 'atlas-core' ),
	'id'     => 'archives-settings',
	'icon'   => 'el el-folder',
	'fields' => array(
		array(
			'id'       => 'archive_template',
			'type'     => 'select',
			'title'    => esc_html__('Archive template', 'atlas-core'),
			'subtitle' => esc_html__('Select the archive template.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create the archive template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_block' ),
			'placeholder'  => esc_html__('Select block', 'atlas-core'),
		),
		array(
			'id'      => 'archive_sidebar',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Archive sidebar layout', 'atlas-core' ),
			'options' => $th90_def_options['sidebar_layouts'],
			'default' => $th90_def_options['archive_sidebar'],
		),
	),
) );
