<?php
Redux::set_section( $opt_name, array(
	'title'  => esc_html__( 'Advertisement', 'atlas-core' ),
	'heading' => esc_html__( 'Advertisement Settings', 'atlas-core' ),
	'desc'	=> esc_html__( 'You can insert others ads into more various places using the Elementor builder.', 'atlas-core' ),
	'id'     => 'ads',
	'icon'   => 'el el-filter',
	'fields' => array(
		array(
			'id'       => 'section-ads_post-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Article/Post Ads', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'ads_article_before',
			'type'     => 'select',
			'title'    => esc_html__( 'Ads before article', 'atlas-core' ),
			'subtitle' => esc_html__('Ads will showing before the article content.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create ads from %1$sadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_adv' ),
			'placeholder'  => esc_html__('Select ads', 'atlas-core'),
		),
		array(
			'id'       => 'ads_article_after',
			'type'     => 'select',
			'title'    => esc_html__( 'Ads after article', 'atlas-core' ),
			'subtitle' => esc_html__('Ads will showing after the article content.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create ads from %1$sadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_adv' ),
			'placeholder'  => esc_html__('Select ads', 'atlas-core'),
		),

		array(
			'id'       => 'ads_article_ajax',
			'type'     => 'select',
			'title'    => esc_html__( 'Ads between articles ajax', 'atlas-core' ),
			'subtitle' => esc_html__('Ads will showing between the article when you activate Infinite Load Next Posts.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create ads from %1$ssadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_adv' ),
			'placeholder'  => esc_html__('Select ads', 'atlas-core'),
		),

		array(
			'id'       => 'section-ads_general-start',
			'type'     => 'section',
			'title'    => esc_html__( 'Floating Ads', 'atlas-core' ),
			'subtitle'    => esc_html__( 'Only showing on desktop.', 'atlas-core' ),
			'indent'   => true,
		),
		array(
			'id'       => 'ads_left_site',
			'type'     => 'select',
			'title'    => esc_html__( 'Floating ads on left website', 'atlas-core' ),
			'subtitle' => esc_html__('Ads will showing on the left side of the website.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create ads from %1$sadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_adv' ),
			'placeholder'  => esc_html__('Select ads', 'atlas-core'),
		),
		array(
		    'id'             => 'ads_left_site_space',
		    'type'           => 'spacing',
		    'output'         => array('.hook-left'),
		    'mode'           => 'margin',
		    'units'          => array('px'),
		    'units_extended' => 'false',
		    'title'          => esc_html__('Floating ads on left space', 'atlas-core'),
		),
		array(
			'id'       => 'ads_right_site',
			'type'     => 'select',
			'title'    => esc_html__( 'Floating ads on right website', 'atlas-core' ),
			'subtitle' => esc_html__('Ads will showing on the right side of the website.', 'atlas-core'),
			'desc'	=> sprintf( esc_html__( 'You can create ads from %1$sadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
			'options'  => th90_get_posts_id( 'th90_adv' ),
			'placeholder'  => esc_html__('Select ads', 'atlas-core'),
		),
		array(
		    'id'             => 'ads_right_site_space',
		    'type'           => 'spacing',
		    'output'         => array('.hook-right'),
		    'mode'           => 'margin',
		    'units'          => array('px'),
		    'units_extended' => 'false',
		    'title'          => esc_html__('Floating ads on right space', 'atlas-core'),
		),
	),
) );
