<?php
/**
 * Redux Section
 *
 * @package Atlas Core
 */

if ( ! class_exists( 'Redux' ) ) {
	return;
}
$redux_sections_dir = plugin_dir_path( __FILE__ ) . 'redux-sections/';
$th90_def_options = th90_default_options();
$th90_def_output = th90_default_output();

if ( ! function_exists( 'th90_social_networks_options' ) ) {
	function th90_social_networks_options( $th90_def_options = array() ) {
		$options_array = array();
		foreach ($th90_def_options['social_networks'] as $key => $value) {
			$options_array[] = array(
				'id'       => 'social_' . th90_convert_to_id( $key ),
				'type'     => 'text',
				'title'    => $value . ' ' . esc_html__( 'URL', 'atlas-core' ),
			);
		}
		return $options_array;
	}
}

if ( ! function_exists( 'th90_skin_redux_options' ) ) {
	function th90_skin_redux_options( $prefix, $th90_def_options = array(), $th90_def_output = array() ) {
		return array(
			array(
				'id'        => 'skin-start' . $prefix,
				'type'      => 'accordion',
				'title'     => 'Skin ' . $prefix . ' colors settings',
				'subtitle'  => '',
				'position'  => 'start',
			),
			array(
				'id'       => $prefix . '-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Background color', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-bg-color'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-sec-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Background color - Box & Secondary', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-sec-bg-color'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-text-color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Text color', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-text-color'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-text-color-heavier',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Text color - heavier', 'atlas-core' ),
				'subtitle'    => esc_html__( 'Used for links and bigger font like heading, etc.', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-text-color-heavier'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-text-color-lighter',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Text color - lighter', 'atlas-core' ),
				'subtitle'    => esc_html__( 'Used for small or secondary font, etc.', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-text-color-lighter'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-line-color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Border & line color', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-line-color'],
				'output_variables' => true,
			),
			array(
				'id'       => $prefix . '-submenu-bg',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Submenu background color', 'atlas-core' ),
				'transparent' => false,
				'default'  => $th90_def_options[$prefix . '-submenu-bg'],
				'output_variables' => true,
			),

			array(
			    'id'        => 'skin-end' . $prefix,
			    'type'      => 'accordion',
			    'position'  => 'end'
			),
		);
	}
}

if ( ! function_exists( 'th90_heading_size_opt' ) ) {
	function th90_heading_size_opt( $device = 'desktop', $th90_def_options = array(), $th90_def_output = array() ) {
		$out = array();
		$out[] = array(
			'id'        => 'font-heading-size-start' . $device,
			'type'      => 'accordion',
			'title'     => 'Heading size of ' . $device . ' device',
			'subtitle'  => '',
			'position'  => 'start',
		);
		for ($i=1; $i <= 6 ; $i++) {
			$out[] = array(
				'id'       => 'h' . $i . '_' . $device,
				'type'     => 'typography',
				'title'    => 'H' . $i . ' - ' . $device,
				'font-family' => false,
				'google'   => false,
				'subsets'  => false,
				'preview'  => false,
				'text-align' => false,
				'color'    => false,
				'font-style' => false,
				'font-weight' => false,
				'text-transform' => false,
				'all_styles' => false,
				'line-height' => false,
				'letter-spacing' => false,
				'font-size' => true,
				'output_variables' => true,
				'default' => $th90_def_options['h' . $i . '_' . $device],
			);
		}
		$out[] = array(
		    'id'        => 'font-heading-size-end' . $device,
		    'type'      => 'accordion',
		    'position'  => 'end'
		);
		return $out;
	}
}

if ( ! function_exists( 'th90_logo_array_options' ) ) {
	function th90_logo_array_options( $prefix, $name, $th90_def_options = array(), $th90_def_output = array(), $req = array() ) {
		return array(
			array(
				'id'       => 'logo' . $prefix . '_type',
				'type'     => 'button_set',
				'title'    => esc_html__( $name . ' - Logo type', 'atlas-core' ),
				'subtitle' => esc_html__( 'Select the logo type.', 'atlas-core' ),
				'options'  => array(
					'image'  => esc_html__( 'Image', 'atlas-core' ),
					'svg'   => esc_html__( 'SVG codes', 'atlas-core' ),
				),
				'default'  => $th90_def_options['logo' . $prefix . '_type'],
				'required' => $req,
			),
			array(
				'id' => 'logo' . $prefix,
				'type' => 'media',
				'default' => array(),
				'title' => esc_html__( $name . ' - Logo', 'atlas-core' ),
				'subtitle' => esc_html__( 'Upload the footer logo.', 'atlas-core' ),
				'default'  => $th90_def_options['logo' . $prefix],
				'url' => false,
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'image'),
				),
			),
			array(
				'id' => 'logo' . $prefix . '_retina',
				'type' => 'media',
				'title' => esc_html__( $name . ' - Retina Logo', 'atlas-core' ),
				'subtitle' => esc_html__( 'Upload the retina version of the logo. It should be exactly 2x the size of the main logo.', 'atlas-core' ),
				'url' => false,
				'default'  => $th90_def_options['logo' . $prefix . '_retina'],
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'image'),
				),
			),
			array(
				'id' => 'logo_dark' . $prefix,
				'type' => 'media',
				'default' => array(),
				'title' => esc_html__( $name . ' - Logo (Dark Skin)', 'atlas-core' ),
				'subtitle' => esc_html__( 'Upload the logo for dark skin.', 'atlas-core' ),
				'url' => false,
				'default'  => $th90_def_options['logo_dark' . $prefix],
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'image'),
				),
			),
			array(
				'id' => 'logo_dark' . $prefix . '_retina',
				'type' => 'media',
				'title' => esc_html__( $name . ' - Retina Logo (Dark Skin)', 'atlas-core' ),
				'subtitle' => esc_html__( 'Upload the retina version of the logo for dark skin. It should be exactly 2x the size of the main logo.', 'atlas-core' ),
				'url' => false,
				'default'  => $th90_def_options['logo_dark' . $prefix . '_retina'],
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'image'),
				),
			),
			array(
				'id'      => 'logo' . $prefix . '_width',
				'type'    => 'dimensions',
				'title'   => esc_html__( $name . ' - Logo width', 'atlas-core'),
				'units'   => array('em','px','%','vw'),
				'height'  => false,
				//'default' => $th90_def_options['logo' . $prefix . '_width'],
				'output_variables' => true,
				'required'     => array(
					array('logo' . $prefix . '_type', '=', 'image'),
				),
			),

			array(
				'id'       => 'logo' . $prefix . '_svg',
				'type'     => 'textarea',
				'title'    => esc_html__( $name . ' - Logo SVG codes', 'atlas-core' ),
				'subtitle' => esc_html__( 'Put the svg codes here.', 'atlas-core' ),
				'default'  => $th90_def_options['logo' . $prefix . '_svg'],
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'svg'),
				),
			),

			array(
				'id'       => 'logo_dark' . $prefix . '_svg',
				'type'     => 'textarea',
				'title'    => esc_html__( $name . ' - Logo SVG codes ( Dark Skin)', 'atlas-core' ),
				'subtitle' => esc_html__( 'Put the svg codes here.', 'atlas-core' ),
				'default'  => $th90_def_options['logo_dark' . $prefix . '_svg'],
				'required' => array(
					array('logo' . $prefix . '_type', '=', 'svg'),
				),
			),

			array(
				'id'      => 'logo' . $prefix . '_svg_width',
				'type'    => 'dimensions',
				'title'   => esc_html__( $name . ' - Logo SVG width', 'atlas-core'),
				'units'   => array('em','px','%','vw'),
				'height'  => false,
				'default' => $th90_def_options['logo' . $prefix . '_svg_width'],
				'output_variables' => true,
				'required'     => array(
					array('logo' . $prefix . '_type', '=', 'svg'),
				),
			),
		);
	}
}

require $redux_sections_dir . 'general.php';
require $redux_sections_dir . 'logo.php';
require $redux_sections_dir . 'header.php';
require $redux_sections_dir . 'footer.php';
require $redux_sections_dir . 'sidebar.php';
require $redux_sections_dir . 'post.php';
require $redux_sections_dir . 'page.php';
require $redux_sections_dir . 'archives.php';
require $redux_sections_dir . 'search.php';
require $redux_sections_dir . 'offcanvas.php';
require $redux_sections_dir . 'speed.php';
require $redux_sections_dir . 'seo.php';
require $redux_sections_dir . 'ads.php';
require $redux_sections_dir . 'woocommerce.php';
require $redux_sections_dir . 'import-export.php';
