<?php
/**
 * Menu item custom fields
 *
 * @package Atlas Core
 */

class TH90_Menu_Item_Custom_Fields_Show {

	protected static $fields = array();


	/**
	 * Initialize plugin
	 */
	public static function init() {
		add_action( 'wp_nav_menu_item_custom_fields', array( __CLASS__, '_fields' ), 10, 4 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, '_save' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, '_columns' ), 99 );

		self::$fields = array(
			'th90_posts_cat' => esc_html__( 'Add category posts megamenu?', 'atlas-core' ),
			'th90_posts_cat_style' => esc_html__( 'Category posts style', 'atlas-core' ),
			'th90_menu_note' => esc_html__( 'Menu note', 'atlas-core' ),
			'th90_menu_note_bg' => esc_html__( 'Note background color', 'atlas-core' ),
			'th90_menu_note_color' => esc_html__( 'Note text color', 'atlas-core' ),
			'th90_menu_template' => esc_html__( 'Menu dropdown template', 'atlas-core' ),
		);
	}


	/**
	 * Save custom field value
	 *
	 * @wp_hook action wp_update_nav_menu_item
	 *
	 * @param int   $menu_id         Nav menu ID
	 * @param int   $menu_item_db_id Menu item ID
	 * @param array $menu_item_args  Menu item data
	 */
	public static function _save( $menu_id, $menu_item_db_id, $menu_item_args ) {
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}

		//check_admin_referer( 'update-nav_menu', 'update-nav-menu-nonce' );

		foreach ( self::$fields as $_key => $label ) {
			$key = sprintf( 'menu-item-%s', $_key );

			// Sanitize
			if ( ! empty( $_POST[ $key ][ $menu_item_db_id ] ) ) {
				// Do some checks here...
				$value = $_POST[ $key ][ $menu_item_db_id ];
			} else {
				$value = null;
			}

			// Update
			if ( ! is_null( $value ) ) {
				update_post_meta( $menu_item_db_id, $key, $value );
			} else {
				delete_post_meta( $menu_item_db_id, $key );
			}
		}
	}


	/**
	 * Print field
	 *
	 * @param object $item  Menu item data object.
	 * @param int    $depth  Depth of menu item. Used for padding.
	 * @param array  $args  Menu item args.
	 * @param int    $id    Nav menu ID.
	 *
	 * @return string Form fields
	 */
	public static function _fields( $id, $item, $depth, $args ) {
		foreach ( self::$fields as $_key => $label ) :
			$key   = sprintf( 'menu-item-%s', $_key );
			$id    = sprintf( 'edit-%s-%s', $key, $item->ID );
			$name  = sprintf( '%s[%s]', $key, $item->ID );
			$value = get_post_meta( $item->ID, $key, true );
			$class = sprintf( 'field-%s', $_key );
			switch ( $_key ) {
				case 'th90_megamenu':
					if ( 0 === $depth ):
					?>
					<p class="description description-wide <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<select id="<?php echo esc_attr( $id ) ?>" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>">
								<option value="" <?php selected( $value, '' ); ?>><?php esc_html_e( 'Unable', 'atlas-core' ); ?></option>
								<option value="2" <?php selected( $value, '2' ); ?>><?php esc_html_e( '2 Columns', 'atlas-core' ); ?></option>
								<option value="3" <?php selected( $value, '3' ); ?>><?php esc_html_e( '3 Columns', 'atlas-core' ); ?></option>
								<option value="4" <?php selected( $value, '4' ); ?>><?php esc_html_e( '4 Columns', 'atlas-core' ); ?></option>
								<option value="5" <?php selected( $value, '5' ); ?>><?php esc_html_e( '5 Columns', 'atlas-core' ); ?></option>
								<option value="6" <?php selected( $value, '6' ); ?>><?php esc_html_e( '6 Columns', 'atlas-core' ); ?></option>
							</select>
						</label>
					</p>
					<?php
					endif;
					break;

				case 'th90_posts_cat':
					if ( 'category' == $item->object && 0 === $depth ):
					?>
					<p class="description description-wide <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<input type="checkbox"  id="<?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>"<?php checked( $value, 'Yes' ); ?> value='Yes' />
							<?php echo esc_html( $label ); ?>
						</label>
						<br/><span class="description"><em><?php esc_html_e( 'Make sure this menu item haven\'t childrens.', 'atlas-core' ); ?></em></span>
					</p>
					<?php
					endif;
					break;
				case 'th90_posts_cat_style':
					if ( 'category' == $item->object && 0 === $depth ):
					?>
					<p class="description description-wide <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<select id="<?php echo esc_attr( $id ) ?>" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>">
								<option value="small" <?php selected( $value, 'small' ); ?>><?php esc_html_e( 'Small Post', 'atlas-core' ); ?></option>
								<option value="medium" <?php selected( $value, 'medium' ); ?>><?php esc_html_e( 'Medium Post', 'atlas-core' ); ?></option>
							</select>
						</label>
					</p>
					<?php
					endif;
					break;
				case 'th90_menu_template':
					if ( 0 === $depth ):
					?>
					<p class="description description-wide <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<select id="<?php echo esc_attr( $id ) ?>" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>">
								<option value="" <?php selected( $value, '' ); ?>><?php esc_html_e( 'None', 'atlas-core' ); ?></option>
								<?php
								$post_lists = array(
									'post_type'        => 'th90_block',
									'numberposts'      => -1,
								);
								foreach ( get_posts( $post_lists ) as $post ) {
								?>
									<option value="<?php echo $post->ID; ?>" <?php selected( $value, $post->ID ); ?>><?php echo esc_html( $post->post_title ); ?></option>
								<?php
								}
								wp_reset_postdata();
								?>
							</select>
							<span class="description"><em><?php echo sprintf( esc_html__( 'If you want to show dropdown content with custom template. You can create the dropdown template from %1$sblock builder%2$s. Make sure this menu item haven\'t childrens.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' ); ?></em></span>
						</label>
					</p>
					<?php
					endif;
					break;
				case 'th90_menu_note':
					?>
					<p class="description description-wide <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<input type="text" id="<?php echo esc_attr( $id ) ?>" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>" value="<?php echo esc_attr( $value ) ?>" />
						</label>
					</p>
					<?php
					break;
				case 'th90_menu_note_bg':
					?>
					<p class="description description-thin <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<input type="text" id="<?php echo esc_attr( $id ) ?>" placeholder="#" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>" value="<?php echo esc_attr( $value ) ?>" />
						</label>
					</p>
					<?php
					break;
				case 'th90_menu_note_color':
					?>
					<p class="description description-thin <?php echo esc_attr( $class ) ?>">
						<label for="<?php echo esc_attr( $id ) ?>">
							<?php echo esc_html( $label ); ?>
							<input type="text" id="<?php echo esc_attr( $id ) ?>" placeholder="#" class="widefat <?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $name ) ?>" value="<?php echo esc_attr( $value ) ?>" />
						</label>
					</p>
					<?php
					break;

				default:
					echo '';
			}
		endforeach;
	}


	/**
	 * Add our fields to the screen options toggle
	 *
	 * @param array $columns Menu item columns
	 * @return array
	 */
	public static function _columns( $columns ) {
		$columns = array_merge( $columns, self::$fields );

		return $columns;
	}
}
TH90_Menu_Item_Custom_Fields_Show::init();
