<?php
/**
 * Import
 *
 * @package Atlas Core
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( ! class_exists( 'OCDI_Plugin' ) ) {
    return;
}

/*-----------------------------------------------------------------------------------*/
# Sites
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_site_demos' ) ) {
	function th90_site_demos() {
		return array(
			'default' => 'Default',
			'two'     => 'Home 2',
			'three'   => 'Home 3',
			'four'    => 'Home 4',
			'five'    => 'Home 5',
			'six'     => 'Home 6',
			'seven'   => 'Home 7',
			'rtl'     => 'RTL',
			'eight'   => 'Home 8',
			'ads'     => 'Ads',
		);
	}
}
/*-----------------------------------------------------------------------------------*/
# Import Sites
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'th90_import_demos' ) ) {
	function th90_import_demos() {
		$output = array();

		foreach ( th90_site_demos() as $key => $value ) {
			if ( strpos( $key, '_' ) !== false ) {
				$demo_name = explode( '_', $key )[0];
				$demo_preview = str_replace( '_', '/', $key );
			} else {
				$demo_name = $key;
				$demo_preview = $key;
			}
			$demo_preview_img = $key;

			$output[] = array(
				'import_file_name'           => $value,
				'preview_url'                => 'https://tmrwstudio.me/atlas/' . $demo_preview,
				'import_file_url'            => 'https://tmrwstudio.me/files/atlas/content/' . $demo_name . '.xml',
				'import_preview_image_url'   => 'https://tmrwstudio.me/files/atlas/preview/' . $demo_preview_img . '.png',
				'import_redux'               => array(
					array(
						'file_url'    => 'https://tmrwstudio.me/files/atlas/redux/' . $demo_name . '.json',
						'option_name' => 'th90_options',
					),
				),
				'import_notice'				=> sprintf( esc_html__( 'IMPORTANT! After import finished, please regenerate all images using %1$sRegenerate Thumbnails%2$s plugin.', 'atlas-core' ), '<a target="_blank" href="https://wordpress.org/plugins/regenerate-thumbnails/"><strong>', '</strong></a>' ),
			);
		}

		return $output;
	}
	add_filter( 'ocdi/import_files', 'th90_import_demos' );
}


/*-----------------------------------------------------------------------------------*/
# Import Menu & Assign front page and posts page (blog page).
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'th90_after_import' ) ){

	function th90_after_import( $selected_import ) {
		// Assign menus to their locations.
    	$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    	set_theme_mod(
    		'nav_menu_locations', array(
    			'main_menu' => $main_menu->term_id,
    		)
    	);

    	// Assign front page and posts page (blog page).
		if ( strpos( $selected_import['import_file_name'], '-' ) !== false ) {
	        $title = substr( $selected_import['import_file_name'], strpos( $selected_import['import_file_name'], '-' ) + 2);
	    } else {
			$title = 'Homepage';
		}

		$front_page_id = get_page_by_title( $title );
		$blog_page_id = get_page_by_title( 'Blog' );

    	update_option( 'show_on_front', 'page' );
    	update_option( 'page_on_front', $front_page_id->ID );
		update_option( 'page_for_posts', $blog_page_id->ID );
	}
	add_action( 'ocdi/after_import', 'th90_after_import' );

}

/*-----------------------------------------------------------------------------------*/
# Required & Recomended Plugins
/*-----------------------------------------------------------------------------------*/
if( ! function_exists( 'th90_import_register_plugins' ) ){

	function th90_import_register_plugins( $plugins ) {
		return array_merge( $plugins, th90_required_plugins_list() );
	}
	add_action( 'ocdi/register_plugins', 'th90_import_register_plugins' );

}


/*-----------------------------------------------------------------------------------*/
# Filter Imported Image - Only Download Full Size
/*-----------------------------------------------------------------------------------*/
add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
