<?php
/**
 * Acf fields default options & filters
 *
 * @package Atlas
 */

if ( ! defined( 'ABSPATH' ) ) {
	 exit; // Exit if accessed directly
}

if ( ! TH90_ACF_IS_ACTIVE ) {
    return;
}

/**
 * -----------------------------------------------------------------------------
 *  Hide the ACF Admin UI
 * -----------------------------------------------------------------------------
 */
//add_filter( 'acf/settings/show_admin', '__return_false' );

/**
 * -----------------------------------------------------------------------------
 *  Contact Form 7 list for ACF fields
 * -----------------------------------------------------------------------------
 */
if ( ! function_exists( 'th90_acf_cf7_list_options' ) ) {
	function th90_acf_cf7_list_options( $field ) {
		$field['choices'] = th90_get_posts_id( 'wpcf7_contact_form' );
		return $field;
	}
}
add_filter( 'acf/load_field/name=contact_form7', 'th90_acf_cf7_list_options' );

/**
 * -----------------------------------------------------------------------------
 *  Social Counters Cache Time
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=cache_time', function ( $field ) {
	$cache_array = array();
	for ( $i=4; $i <= 24 ; $i++ ) {
		$cache_array[$i] = $i . ' Hours';
	}
	$field['choices'] = $cache_array;
	return $field;
} );

/**
 * -----------------------------------------------------------------------------
 *  Gallery Image Ratios for ACF fields
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=gallery_ratio', function ( $field ) {
	$image_ratio = th90_default_options()['image_ratio'];
	unset( $image_ratio['custom'] );
	$field['choices'] = $image_ratio;
	return $field;
} );

/**
 * -----------------------------------------------------------------------------
 *  Article/Post layouts
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=post_layout', function ( $field ) {
	$arr = array();
	foreach (th90_default_options()['post_layouts'] as $key => $value) {
		$arr[$key] = '<img src="'. $value['img'] .'" style="max-width: 100%;"/>';
	}
	$field['choices'] = $arr;
	$field['default_value'] = th90_default_options()['post_layout'];
	return $field;
} );

/**
 * -----------------------------------------------------------------------------
 *  Article/Post Featured Image Ratio
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=post_featured_ratio', function( $field ) {
	$image_ratio = th90_default_options()['image_ratio'];
	unset( $image_ratio['custom'] );
	$field['choices'] = $image_ratio;
	$field['default_value'] = th90_default_options()['post_featured_ratio'];
	return $field;
} );


/**
 * -----------------------------------------------------------------------------
 *  Sidebars
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=page_sidebar', function ( $field ) {
	$arr = array();
	foreach (th90_default_options()['sidebar_layouts'] as $key => $value) {
		$arr[$key] = '<img src="'. $value['img'] .'" style="max-width: 100%;"/>';
	}
	$field['choices'] = $arr;
	return $field;
} );
add_filter( 'acf/load_field/name=archive_sidebar', function ( $field ) {
	$arr = array();
	foreach (th90_default_options()['sidebar_layouts'] as $key => $value) {
		$arr[$key] = '<img src="'. $value['img'] .'" style="max-width: 100%;"/>';
	}
	$field['choices'] = $arr;
	return $field;
} );


/**
 * -----------------------------------------------------------------------------
 * Instructions
 * -----------------------------------------------------------------------------
 */
add_filter( 'acf/load_field/name=header_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the header template. You can create the header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=sticky_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the sticky header template. You can create the sticky header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=mob_header_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the mobile header template. You can create the mobile header template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=footer_widgets_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the footer widgets template. You can create the footer widgets template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=footer_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the footer template. You can create the footer template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );


add_filter( 'acf/load_field/name=post_sidebar_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the post sidebar template. You can create the post sidebar template from %1$ssidebar builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_sidebar') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=page_sidebar_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the page sidebar template. You can create the page sidebar template from %1$ssidebar builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_sidebar') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=archive_sidebar_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the archive sidebar template. You can create the archive sidebar template from %1$ssidebar builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_sidebar') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=archive_template', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Select the archive template. You can create the archive template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );
/*
add_filter( 'acf/load_field/name=hook_header_before', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Template will execute before the header. You can create the header before template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=hook_header_after', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Template will execute after the header. You can create the header after template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=hook_footer_before', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Template will execute before the footer. You can create the footer before template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );

add_filter( 'acf/load_field/name=hook_footer_after', function( $field ) {
	$field['instructions'] = sprintf( esc_html__( 'Template will execute after the footer. You can create the footer after template from %1$sblock builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_block') . '"><strong>', '</strong></a>' );
	return $field;
} );
*/
