<?php
add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
	'key' => 'group_5f4cf30e7fafe',
	'title' => 'Advertisement',
	'fields' => array(
		array(
			'key' => 'field_62f5f521c74b0',
			'label' => 'Activate advertisement?',
			'name' => 'ad_activate',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'You can showing the advertisement frome <strong>Advertisement Theme Options</strong> or <strong>Advertisement elementor block</strong>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_5f4cf503f4830',
			'label' => 'Advertisement type',
			'name' => 'ad_type',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'image' => 'Image Upload',
				'codes' => 'Custom Codes',
			),
			'default_value' => 'image',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 1,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5f4cf3dea2177',
			'label' => 'Advertisement image',
			'name' => 'ad_image',
			'aria-label' => '',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5f4cf503f4830',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_5f4cf5a606029',
			'label' => 'Advertisement Custom Codes',
			'name' => 'ad_codes',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5f4cf503f4830',
						'operator' => '==',
						'value' => 'codes',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => '',
			'new_lines' => '',
		),
		array(
			'key' => 'field_5f4cf329a2174',
			'label' => 'Advertisement title',
			'name' => 'ad_title',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Leave blank if you don\'t want show the title',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_5f4cf428a2178',
			'label' => 'Advertisement URL',
			'name' => 'ad_url',
			'aria-label' => '',
			'type' => 'url',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5f4cf503f4830',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
		),
		array(
			'key' => 'field_5f4cf392a2175',
			'label' => 'Open links in new window',
			'name' => 'ad_new_window',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5f4cf503f4830',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5f4cf3c7a2176',
			'label' => 'Nofollow?',
			'name' => 'ad_nofollow',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5f4cf503f4830',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'th90_adv',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_631cb73eb5693',
	'title' => 'Archive Settings',
	'fields' => array(
		array(
			'key' => 'field_5e757da34d1b8',
			'label' => 'Featured Image',
			'name' => 'term_image',
			'aria-label' => '',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_631d6655e58b7',
			'label' => 'Archive Template',
			'name' => 'archive_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the archive template. You can create the archive template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'taxonomy' => '',
			'allow_null' => 1,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_631cb73ebb8cf',
			'label' => 'Archive Sidebar Layout',
			'name' => 'archive_sidebar',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => 'Leave blank if you want to use global settings from theme options.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'right' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/1.png" style="max-width: 100%;"/>',
				'left' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/2.png" style="max-width: 100%;"/>',
				'one_column' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/3.png" style="max-width: 100%;"/>',
				'full' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/4.png" style="max-width: 100%;"/>',
			),
			'allow_null' => 1,
			'other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_631cc5d8fa6a1',
			'label' => 'Archive Sidebar Template',
			'name' => 'archive_sidebar_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the archive sidebar template. You can create the archive sidebar template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_sidebar"><strong>sidebar builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_631cb73ebb8cf',
						'operator' => '!=',
						'value' => '',
					),
					array(
						'field' => 'field_631cb73ebb8cf',
						'operator' => '!=',
						'value' => 'one_column',
					),
					array(
						'field' => 'field_631cb73ebb8cf',
						'operator' => '!=',
						'value' => 'full',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_sidebar',
			),
			'taxonomy' => '',
			'allow_null' => 1,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'category',
			),
		),
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'post_tag',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_5b8dea52825ab',
	'title' => 'Category Color',
	'fields' => array(
		array(
			'key' => 'field_62e22cc08eb21',
			'label' => 'Color',
			'name' => 'category_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'category',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6484c19616779',
	'title' => 'Contact	7 Settings',
	'fields' => array(
		array(
			'key' => 'field_6484c197adba2',
			'label' => 'Contact Form 7',
			'name' => 'contact_form_7',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'wpcf7_contact_form',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'page-contact.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_563f63bb9dd56',
	'title' => 'Featured Audio',
	'fields' => array(
		array(
			'key' => 'field_5a07ccc5added',
			'label' => 'Audio embed',
			'name' => 'audio_embed',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => 4,
			'new_lines' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_format',
				'operator' => '==',
				'value' => 'audio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_563f19ff6cd9b',
	'title' => 'Featured Gallery',
	'fields' => array(
		array(
			'key' => 'field_563f1a131b9b6',
			'label' => 'Upload images',
			'name' => 'post_gallery',
			'aria-label' => '',
			'type' => 'gallery',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'array',
			'preview_size' => 'thumbnail',
			'insert' => 'append',
			'library' => 'all',
			'min' => '',
			'max' => '',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array(
			'key' => 'field_61f241038c11d',
			'label' => 'Images ratio',
			'name' => 'gallery_ratio',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'ori' => 'Original',
				'1_1' => '1:1 (square)',
				'16_9' => '16:9 (Panoramic)',
				'3_2' => '3:2 (Rectangle)',
				'4_3' => '4:3 (Rectangle)',
				'2_1' => '2:1 (Landscape)',
				'4_5' => '4:5 (portrait)',
				'2_3' => '2:3 (portrait)',
				'3_4' => '3:4 (portrait)',
			),
			'default_value' => 'ori',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_61f2417e5a524',
			'label' => 'Gallery autoplay',
			'name' => 'gallery_autoplay',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Yes',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_format',
				'operator' => '==',
				'value' => 'gallery',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_563f3b55bc8d9',
	'title' => 'Featured Video',
	'fields' => array(
		array(
			'key' => 'field_563f3c6f73e83',
			'label' => 'Video embed',
			'name' => 'video_embed',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => 'Just only put iframe codes',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => '',
			'new_lines' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_format',
				'operator' => '==',
				'value' => 'video',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_62017032e5172',
	'title' => 'Page Settings',
	'fields' => array(
		array(
			'key' => 'field_6201703dbd9bb',
			'label' => 'Page Sidebar Layout',
			'name' => 'page_sidebar',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => 'Leave blank if you want to use global settings from theme options.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'right' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/1.png" style="max-width: 100%;"/>',
				'left' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/2.png" style="max-width: 100%;"/>',
				'one_column' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/3.png" style="max-width: 100%;"/>',
				'full' => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/sidebar/4.png" style="max-width: 100%;"/>',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 1,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_631cc50c8f80e',
			'label' => 'Page Sidebar Template',
			'name' => 'page_sidebar_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the page sidebar template. You can create the page sidebar template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_sidebar"><strong>sidebar builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6201703dbd9bb',
						'operator' => '==',
						'value' => 'right',
					),
				),
				array(
					array(
						'field' => 'field_6201703dbd9bb',
						'operator' => '==',
						'value' => 'left',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_sidebar',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'default',
			),
		),
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'elementor_theme',
			),
		),
		array(
			array(
				'param' => 'post_template',
				'operator' => '==',
				'value' => 'page-contact.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_59c5f9fa4fbd3',
	'title' => 'Review Settings',
	'fields' => array(
		array(
			'key' => 'field_64e7534c178d6',
			'label' => 'Activate review',
			'name' => 'review_show',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'If you want to showing review on this post',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_59c71299b7b2a',
			'label' => 'Text of total scores',
			'name' => 'review_total_text',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64e7534c178d6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 'Good',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_59c5fe6b6bb44',
			'label' => 'Review criteria',
			'name' => 'review_criteria',
			'aria-label' => '',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64e7534c178d6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'table',
			'pagination' => 0,
			'min' => 1,
			'max' => 0,
			'collapsed' => '',
			'button_label' => 'Add Review Criteria',
			'rows_per_page' => 20,
			'sub_fields' => array(
				array(
					'key' => 'field_59c5ff4dd853d',
					'label' => 'Criteria Name',
					'name' => 'review_criteria_name',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
					'parent_repeater' => 'field_59c5fe6b6bb44',
				),
				array(
					'key' => 'field_59c5fe726bb45',
					'label' => 'Criteria Score',
					'name' => 'review_criteria_score',
					'aria-label' => '',
					'type' => 'range',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => '',
					'max' => '',
					'step' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_59c5fe6b6bb44',
				),
			),
		),
		array(
			'key' => 'field_64e826623e6f4',
			'label' => 'Custom review color',
			'name' => 'review_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64e7534c178d6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_5a115ddfaad08',
	'title' => 'Post Settings',
	'fields' => array(
		array(
			'key' => 'field_61ff4768436fc',
			'label' => 'Override post layout?',
			'name' => 'override_post_layout',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'This settings will override the post global setting from theme options.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Override',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_61fec9e19cd7e',
			'label' => 'Post Layout',
			'name' => 'post_layout',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/article/1.png" style="max-width: 100%;"/>',
				2 => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/article/2.png" style="max-width: 100%;"/>',
				3 => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/article/3.png" style="max-width: 100%;"/>',
				4 => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/article/4.png" style="max-width: 100%;"/>',
				5 => '<img src="http://localhost/atlas/default/wp-content/themes/atlas/images/admin/article/5.png" style="max-width: 100%;"/>',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'default_value' => '1',
			'layout' => 'horizontal',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_655cb93a279f4',
			'label' => 'Disable featured image?',
			'name' => 'featured_disable',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '1',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '3',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '4',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Yes',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_6507fcb0c94a0',
			'label' => 'Featured image height',
			'name' => 'featured_height',
			'aria-label' => '',
			'type' => 'range',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '==',
						'value' => '3',
					),
				),
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '==',
						'value' => '4',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 450,
			'min' => 100,
			'max' => 2000,
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_61ff3a276091f',
			'label' => 'Sidebar Position',
			'name' => 'post_sidebar_position',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '4',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '5',
					),
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => 'Left',
				'right' => 'Right',
			),
			'default_value' => 'right',
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_631cc39774585',
			'label' => 'Sidebar Template',
			'name' => 'post_sidebar_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the post sidebar template. You can create the post sidebar template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_sidebar"><strong>sidebar builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '4',
					),
					array(
						'field' => 'field_61fec9e19cd7e',
						'operator' => '!=',
						'value' => '5',
					),
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_sidebar',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'bidirectional' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_6417557e2eff3',
			'label' => 'Enable box style?',
			'name' => 'box_post',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Yes',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_61ff3a9a60925',
			'label' => 'Featured image ratio',
			'name' => 'post_featured_ratio',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'ori' => 'Original',
				'1_1' => '1:1 (square)',
				'16_9' => '16:9 (Panoramic)',
				'3_2' => '3:2 (Rectangle)',
				'4_3' => '4:3 (Rectangle)',
				'2_1' => '2:1 (Landscape)',
				'4_5' => '4:5 (portrait)',
				'2_3' => '2:3 (portrait)',
				'3_4' => '3:4 (portrait)',
			),
			'default_value' => '16_9',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_61ff3b5f60930',
			'label' => 'Centered align of title?',
			'name' => 'post_title_center',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ff4768436fc',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Yes',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_631c531eb17b7',
	'title' => 'Site Layout Settings',
	'fields' => array(
		array(
			'key' => 'field_64f4172f4e159',
			'label' => 'Site skin',
			'name' => 'site_skin',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'light' => 'Light',
				'dark' => 'Dark',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_638d5a6fe8e9b',
			'label' => 'Disable Templates',
			'name' => 'disable_templates',
			'aria-label' => '',
			'type' => 'checkbox',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'footer' => 'Disable Footer?',
				'top_header' => 'Disable Top Header?',
			),
			'default_value' => array(
			),
			'return_format' => 'value',
			'allow_custom' => 0,
			'layout' => 'vertical',
			'toggle' => 0,
			'save_custom' => 0,
			'custom_choice_button_text' => 'Add new choice',
		),
		array(
			'key' => 'field_631c5333244bc',
			'label' => 'Main Header Template',
			'name' => 'header_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the header template. You can create the header template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_64c8dfd617c53',
			'label' => 'Top Header Template',
			'name' => 'topheader_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the header template. You can create the header template from <a target="_blank" href="http://localhost/mooda/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_638d5a6fe8e9b',
						'operator' => '!=',
						'value' => 'top_header',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'bidirectional' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_631c921e34f65',
			'label' => 'Mobile Header Template',
			'name' => 'mob_header_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the mobile header template. You can create the mobile header template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_631c91dc8774b',
			'label' => 'Sticky Header Template',
			'name' => 'sticky_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the sticky header template. You can create the sticky header template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_631c925c34f66',
			'label' => 'Footer Template',
			'name' => 'footer_template',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Select the footer template. You can create the footer template from <a target="_blank" href="http://localhost/atlas/default/wp-admin/edit.php?post_type=th90_block"><strong>block builder</strong></a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_638d5a6fe8e9b',
						'operator' => '!=',
						'value' => 'footer',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'th90_block',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'bidirectional' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'category',
			),
		),
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'post_tag',
			),
		),
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'product_cat',
			),
		),
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'product_tag',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'product',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
} );
