<?php

/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.redux.io/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require plugin_dir_path( __FILE__ ) . 'redux-core/framework.php';

if ( ! class_exists( 'Redux' ) ) {
	return;
}

Redux::disable_demo();

// This is your option name where all the Redux data is stored.
$opt_name = 'th90_options';

$theme = wp_get_theme();

if ( ! function_exists( 'th90_redux_enqueue_scripts' ) ) {
	function th90_redux_enqueue_scripts() {
		wp_enqueue_style( 'th90-redux-custom-css', plugin_dir_url( __FILE__ ) . 'assets/css/redux-style.css', array(), false, false );
	}
}
add_action( 'redux/page/' . $opt_name . '/enqueue', 'th90_redux_enqueue_scripts' );

$args = array(
	// This is where your data is stored in the database and also becomes your global variable name.
	'opt_name'                  => $opt_name,

	// Name that appears at the top of your panel.
	'display_name'              => $theme->get( 'Name' ),

	// Version that appears at the top of your panel.
	'display_version'           => $theme->get( 'Version' ),

	// Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only).
	'menu_type'                 => 'menu',

	//'intro_text'				=> esc_html__( 'Intro', 'atlas-core' ),

	// Show the sections below the admin menu item or not.
	'allow_sub_menu'            => true,

	// The text to appear in the admin menu.
	'menu_title'                => esc_html__( 'Theme Options', 'atlas-core' ),

	// The text to appear on the page title.
	'page_title'                => esc_html__( 'Theme Options', 'atlas-core' ),

	// Disable to create your own google fonts loader.
	'disable_google_fonts_link' => false,

	// Show the panel pages on the admin bar.
	'admin_bar'                 => true,

	// Icon for the admin bar menu.
	'admin_bar_icon'            => 'dashicons-admin-generic',

	// Priority for the admin bar menu.
	'admin_bar_priority'        => 50,

	// Sets a different name for your global variable other than the opt_name.
	'global_variable'           => '',

	// Show the time the page took to load, etc (forced on while on localhost or when WP_DEBUG is enabled).
	'dev_mode'                  => false,

	// Enable basic customizer support.
	'customizer'                => true,

	// Allow the panel to opened expanded.
	'open_expanded'             => false,

	// Disable the save warning when a user changes a field.
	'disable_save_warn'         => false,

	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_priority'             => '39.6',

	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters.
	'page_parent'               => 'themes.php',

	// Permissions needed to access the options panel.
	'page_permissions'          => 'manage_options',

	// Specify a custom URL to an icon.
	//'menu_icon'                 => 'dashicons-admin-generic',

	// Force your panel to always open to a specific tab (by id).
	'last_tab'                  => '',

	// Icon displayed in the admin panel next to your menu_title.
	'page_icon'                 => 'icon-themes',

	// Page slug used to denote the panel, will be based off page title, then menu title, then opt_name if not provided.
	'page_slug'                 => $opt_name,

	// On load save the defaults to DB before user clicks save.
	'save_defaults'             => true,

	// Display the default value next to each field when not set to the default value.
	'default_show'              => false,

	// What to print by the field's title if the value shown is default.
	'default_mark'              => '*',

	// Shows the Import/Export panel when not used as a field.
	'show_import_export'        => true,

	// The time transinets will expire when the 'database' arg is set.
	'transient_time'            => 60 * MINUTE_IN_SECONDS,

	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output.
	'output'                    => true,

	// Allows dynamic CSS to be generated for customizer and google fonts,
	// but stops the dynamic CSS from going to the page head.
	'output_tag'                => true,

	// Disable the footer credit of Redux. Please leave if you can help it.
	'footer_credit'             => '',

	// If you prefer not to use the CDN for ACE Editor.
	// You may download the Redux Vendor Support plugin to run locally or embed it in your code.
	'use_cdn'                   => true,

	// Set the theme of the option panel.  Use 'wp' to use a more modern style, default is classic.
	'admin_theme'               => 'wp',

	// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
	'output_location'           => array( 'frontend', 'admin' ),

	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'database'                  => '',
	'network_admin'             => true,
);

Redux::set_args( $opt_name, $args );

if( !function_exists('th90_redux_register_custom_extension_loader') ) {
	function th90_redux_register_custom_extension_loader($ReduxFramework) {
        $path = dirname( __FILE__ ) . '/redux-extensions/';
            $folders = scandir( $path, 1 );
            foreach ( $folders as $folder ) {
                if ( $folder === '.' or $folder === '..' or ! is_dir( $path . $folder ) ) {
                    continue;
                }
                $extension_class = 'ReduxFramework_Extension_' . $folder;
                if ( ! class_exists( $extension_class ) ) {
                    // In case you wanted override your override, hah.
                    $class_file = $path . $folder . '/extension_' . $folder . '.php';
                    $class_file = apply_filters( 'redux/extension/' . $ReduxFramework->args['opt_name'] . '/' . $folder, $class_file );
                    if ( $class_file ) {
                        require_once( $class_file );
                    }
                }
                if ( ! isset( $ReduxFramework->extensions[ $folder ] ) ) {
                    $ReduxFramework->extensions[ $folder ] = new $extension_class( $ReduxFramework );
                }
            }
    }
    add_action("redux/extensions/{$opt_name}/before", 'th90_redux_register_custom_extension_loader', 0);
}


/*function th90_redux_custom_fonts( $custom_fonts ) {
    return array(
        'Typekit Fonts' => array(
			'coquette,sans-serif' => "Coquette",
			'proxima-nova,sans-serif' => "Proxima Nova",
			'felt-tip-woman,sans-serif' => "Felt Tip Woman"
        )
    );
}
add_filter( "redux/{$opt_name}/field/typography/custom_fonts", "th90_redux_custom_fonts" );*/
