<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Verticalmenu extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-verticalmenu';
	}

	public function get_title() {
		return __( 'Vertical/Mobile Menu', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-navigation-vertical th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_menu',
			[
				'label' => __( 'Menu Settings', 'atlas-core' ),
			]
		);

		$this->add_control(
			'menu',
			[
				'label'     => esc_html__( 'Menu', 'atlas-core' ),
				'description' => sprintf( esc_html__( 'Default menu is main menu. Create custom menus from %1$shere%2$s.', 'atlas-core' ), '<a href="' . admin_url('nav-menus.php?action=edit&menu=0') . '" target="_blank"><strong>', '</strong></a>' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => array_merge(
					array(
						'' => 'Default',
					),
					th90_get_terms( 'nav_menu', 'slug' )
				),
				'label_block' => true,
			]
		);

		$this->add_control(
			'depth',
			[
				'label'     => esc_html__( 'Menu level/depth', 'atlas-core' ),
				'description'     => esc_html__( 'How many levels of the menu are to be included.', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'menu_item_space',
			[
				'label' => esc_html__( 'Menu item space', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'vh' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'vw' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.nav-mobile > li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'menu_typo',
				'label'       => esc_html__( 'Menu typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} ul.nav-mobile > li > a',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_mobile_submenu',
			[
				'label' => __( 'Sub Menu Settings', 'atlas-core' ),
			]
		);

		$this->add_control(
			'submenu_item_space',
			[
				'label' => esc_html__( 'Submenu item space', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'vh' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'vw' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.nav-mobile ul.sub-menu > li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'submenu_typo',
				'label'       => esc_html__( 'Submenu typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} ul.nav-mobile ul.sub-menu > li > a',
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this, 'no' );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-vmenu',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );
			get_template_part( 'template-parts/header/navigation', 'mobile', $atts );
			?>

		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
