<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Taxcloud extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-taxcloud';
	}

	public function get_title() {
		return __( 'Taxonomy Cloud', 'atlas-core' );
	}

	public function get_keywords() {
		return [ 'tags', 'category', 'categories' ];
	}

	public function get_icon() {
		return 'eicon-tags th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	public function controls_general() {
		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'view',
			[
				'label' => esc_html__( 'Layout', 'elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'inline',
				'options' => [
					'inline' => [
						'title' => esc_html__( 'Inline', 'elementor' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'inline2' => [
						'title' => esc_html__( 'Inline Two', 'elementor' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'block' => [
						'title' => esc_html__( 'Block', 'elementor' ),
						'icon' => 'eicon-editor-list-ul',
					],
				],

				'prefix_class' => 'tax-',
			]
		);
		$this->add_control(
			'show_count',
			[
				'label' => esc_html__('Show total posts count?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);
		$this->add_responsive_control(
			'item_space',
			[
				'label' => esc_html__( 'Taxonomy item space', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tax-cloud' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'tax_radius',
			[
				'label' => esc_html__( 'Cloud radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} a.term-cloud' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		/*$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_tax_title_typo',
				'label' => esc_html__( 'Taxonomy title typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .cloud-title',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_tax_count_typo',
				'label' => esc_html__( 'Taxonomy count typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .cloud-count',
			]
		);*/

		$this->end_controls_section();

	}

	public function controls_query() {

		$controls = new TH90_Controls();
		$controls->tax_query_default( $this );

	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_query();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$atts['categories'] = ! empty( $atts['categories'] ) ? implode( ',', $atts['categories'] ) : '';
		$atts['tags'] = ! empty( $atts['tags'] ) ? implode( ',', $atts['tags'] ) : '';
		$count = 0;

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-taxcloud',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );

			/* Term Query */
			if ( 'category' == $atts['taxonomy'] ) {
				if( 'yes' == $atts['selected_cats'] ) {
					$terms = get_terms( array(
						'taxonomy' => 'category',
						'include' => $atts['categories'],
						'hide_empty' => $atts['hide_empty'] ? true : false,
					) );
				} else {
					$terms = get_terms( array(
						'taxonomy' => 'category',
						'orderby' => $atts['orderby'],
						'order' => $atts['order'],
						'number' => absint( $atts['number'] ),
						'hide_empty' => 'yes' == $atts['hide_empty'] ? true : false,
					) );
				}
			} else {
				if( 'yes' == $atts['selected_tags'] ) {
					$terms = get_terms( array(
						'taxonomy' => 'post_tag',
						'include' => $atts['tags'],
						'hide_empty' => $atts['hide_empty'] ? true : false,
					) );
				} else {
					$terms = get_terms( array(
						'taxonomy' => 'post_tag',
						'orderby' => $atts['orderby'],
						'order' => $atts['order'],
						'number' => absint( $atts['number'] ),
						'hide_empty' => 'yes' == $atts['hide_empty'] ? true : false,
					) );
				}
			}

			if ( ! empty( $terms ) ) {
				?>
				<div class="tax-cloud">
					<?php
					foreach ( $terms as $term ) {
						?>
						<a class="term-cloud" href="<?php echo esc_url( get_term_link( $term->term_id ) ); ?>" title="<?php echo esc_attr( $term->name ); ?>">
							<?php
							echo '<div class="cloud-title">';
								echo esc_html( $term->name );
								if ( 'yes' == $atts['show_count'] ) {
									echo ' (' . absint( $term->count  ) . ')';
								}
							echo '</div>';
							?>
						</a>
						<?php
					}
					?>
				</div>
			<?php
			}
			?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {

	}
}
