<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Subscribebox extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return[];
	}

	public function get_name() {
		return 'w-subscribebox';
	}

	public function get_title() {
		return __( 'Subscribe Box', 'atlas-core' );
	}

	public function get_keywords() {
		return [ 'mailchimp' ];
	}

	public function get_icon() {
		return 'eicon-mailchimp th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'form',
			[
				'label' => esc_html__( 'Mailchimp Form Shortcode', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '[mc4wp_form]',
				'label_block' => true,
			]
		);
		/*$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('Subscribe To Our Weekly Newsletter', 'atlas-core'),
				'label_block' => true,
			]
		);*/
		$this->add_control(
			'desc',
			[
				'label' => esc_html__( 'Description', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__('Get the latest creative news from Atlas magazine', 'atlas-core'),
			]
		);
		/*$this->add_control(
			'content_center',
			[
				'label' => esc_html__('Centered content?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'yes',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'newsletter_icon',
			[
				'label' => esc_html__('Add newsletter icon?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);*/
		$this->add_responsive_control(
			'form_width',
			[
				'label' =>esc_html__( 'Form width', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .block-newsletter .mc4wp-form-fields' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();
	}

	public function controls_style() {
		$this->start_controls_section(
			'section_style_newsletter',
			[
				'label' => __( 'Newsletter Style', 'atlas-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		/*$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
			   'name' => 'title_typography',
			   'label' => esc_html__( 'Title typography', 'atlas-core' ),
			   'selector' => '{{WRAPPER}} .block-newsletter h3.newsletter-title',
			]
		);*/
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'label' => esc_html__( 'Description typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .block-newsletter .newsletter-desc',
			]
		);
		/*$this->add_control(
			'head_icon_style',
			[
				'label' => __( 'Icon style', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .block-newsletter .newsletter-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
		   'icon_color',
		   [
			  'label' => esc_html__('Icon Color', 'atlas-core'),
			  'type' => \Elementor\Controls_Manager::COLOR,
			  'default' => '',
			  'selectors' => [
				  '{{WRAPPER}} .block-newsletter .newsletter-icon' => 'color: {{VALUE}};',
			  ],
		   ]
	   );*/

		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_style();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-subscribe',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );

			$classes = array(
				'block-newsletter',
			);
			?>

			<div class="<?php echo esc_attr( implode( ' ', array_filter( $classes ) ) ); ?>">
				<?php if ( ! empty( $atts['desc'] ) ): ?>
					<p class="newsletter-desc">
						<?php echo do_shortcode( $atts['desc'] ); ?>
					</p>
				<?php endif; ?>

				<div class="newsletter-form">
					<?php
					if ( $atts['form'] ) {
						echo do_shortcode( $atts['form'] );
					} else {
						echo do_shortcode( '[mc4wp_form]' );
					}
					?>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
