<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Socialcounters extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-socialcounters';
	}

	public function get_title() {
		return __( 'Social Counters', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-social-icons th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Style', 'elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'inline',
				'options' => [
					'inline' => [
						'title' => esc_html__( 'Inline', 'elementor' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'block' => [
						'title' => esc_html__( 'Block', 'elementor' ),
						'icon' => 'eicon-editor-list-ul',
					],
					'grid' => [
						'title' => esc_html__( 'Grid', 'elementor' ),
						'icon' => 'eicon-gallery-grid',
					],
				],
			]
		);
		$this->add_responsive_control(
			'columns',
			[
				'label' => __( 'Columns', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 15,
					],
				],
				'selectors' => [
                    '{{WRAPPER}} .counters-grid .social-counters, {{WRAPPER}} .counters-block .social-counters' => 'grid-template-columns: repeat({{SIZE}}, 1fr);',
				],
			]
		);
		$this->add_responsive_control(
			'space',
			[
				'label' => esc_html__( 'Space between icon', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .counters-grid .social-counters, {{WRAPPER}} .counters-block .social-counters' => 'grid-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .counters-inline .social-counters' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		foreach ( th90_default_options()['social_counters'] as $key => $value  ) {
			if ( 'facebook' == $key || 'twitter' == $key || 'linkedin' == $key || 'youtube' == $key || 'instagram' == $key ) {
				$default_url = '#';
				$default_count = '10000';
			} else {
				$default_url = '';
				$default_count = '';
			}
			$this->add_control(
				th90_convert_to_id( $key ),
				[
					'label' => $value . ' URL',
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => $default_url,
					'label_block' => true,
				]
			);
			$this->add_control(
				th90_convert_to_id( $key ) . '_count',
				[
					'label' => $value . ' count',
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => $default_count,
					'label_block' => true,
					'separator' => 'after',
				]
			);
		}

		/*$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'counter_typo',
				'label'       => esc_html__( 'Counter typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .counter-desc',
			]
		);*/

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-counters',
				'counters-' . $atts['layout'],
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );

			# Open links in a new tab? ----------
			$new_window = ' target="_blank" ';

			# Get the counters data ----------
			$default_socials_c = $socials_c = array();

			foreach ( th90_default_options()['social_counters'] as $key => $value  ) {
				foreach ( $atts as $atts_key => $atts_value ) {
					if( $atts_key == $key ) {
						$socials_c[$atts_key] = $atts_value;
					}

					if ( $atts_key == $key . '_count' ) {
						$socials_c_count[$atts_key] = $atts_value;
					}
				}
				$default_socials_c[$key] = '';
			}
			$socials_c = wp_parse_args( $socials_c, $default_socials_c );

	        $social_classes = array(
	            'social-counters',
			);

			?>
			<div class="<?php echo esc_attr( implode( ' ', array_filter( $social_classes ) ) ); ?>">
				<?php
				foreach ( $socials_c as $key => $value ) {
					if ( $value ) {
						?>
						<a class="social-counter<?php echo esc_attr( 'block' == $atts['layout'] ? ' counter-' . $key : '' ); ?>" href="<?php echo $value; ?>"<?php echo $new_window ?>>
							<span class="counter-icon social-icon<?php echo esc_attr( 'grid' == $atts['layout'] ? ' counter-' . $key : '' ); ?>">
								<?php
								th90_svg_icon_social( $key );
								if ( 'grid' !== $atts['layout'] ) {
									echo '<span class="counter-text">' . th90_default_options()['social_counters'][$key] . '</span>';
								}
								?>
							</span>
							<span class="counter-desc">
								<?php
								if ( 'grid' == $atts['layout'] ) {
									echo '<span class="counter-text">' . th90_default_options()['social_counters'][$key] . '</span>';
								}
								?>
								<span class="cmeta<?php echo esc_attr( 'grid' == $atts['layout'] ? ' cmeta-' . $key : '' ); ?>">
									<?php echo th90_number_format_short( absint( $atts[$key . '_count'] ) ); ?>
								</span>
							</span>
						</a>
						<?php
					}
				}
				?>
			</div>

		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
