<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Searchform extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-searchform';
	}

	public function get_title() {
		return __( 'Search Form', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-site-search th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_control(
			'placeholder',
			[
				'label' => esc_html__( 'Placeholder', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Search...', 'atlas-core' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'radius',
			[
				'label' => esc_html__( 'Form radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .search-form input[type=search]' =>'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this, 'no' );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-search',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );
			get_search_form();
			?>

		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
