<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Quotes extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return [ 'slick', 'th90-front' ];
	}

	public function get_name() {
		return 'w-quotes';
	}

	public function get_title() {
		return __( 'Quotes', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-blockquote th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_custom_list',
			[
				'label' => __( 'Quotes Lists', 'atlas-core' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( 'Quote', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'author',
			[
				'label' => esc_html__( 'Author', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'quotes',
			[
				'label' => esc_html__( 'Quotes', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'text' => 'This is where I have wasted the best years of my life.',
						'author' => 'Greta Garbo',
					],
					[
						'text' => 'This is where I have wasted the best years of my life.',
						'author' => 'Greta Garbo',
					],
					[
						'text' => 'This is where I have wasted the best years of my life.',
						'author' => 'Greta Garbo',
					],
				],
				'title_field' => '{{{ text }}}',
			]
		);

		$controls = new TH90_Controls();

		/* Controls Slider */
		$this->add_control(
			'_head_slider_setting', [
				'separator' => 'before',
				'label' => __( 'Slider Settings', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$controls->slider_settings( $this );

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this, 'yes' );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-quotes',
				'box-solid',
			),
			th90_box_class( $atts )
		);

		/* Slider Classes */
		$slider_classes = array(
			'block-slider',
			'yes' == $atts['slider_nav'] ? 'nav-' . $atts['nav_position'] : '',
			'yes' == $atts['slider_pagi'] ? 'dots-' . $atts['pagi_dot_align'] : '',
		);

		/* Slider Config */
		$slider_config = array(
			'loop' => 'yes' == $atts['slider_loop'] ? true : false,
			'autoHeight' => 'yes' == $atts['slider_autoHeight'] ? true : false,
			'center' => 'yes' == $atts['slider_center'] ? true : false,
			'autoplay' => 'yes' == $atts['slider_auto'] ? true : false,
			'nav' => 'yes' == $atts['slider_nav'] ? true : false,
			'dots' => 'yes' == $atts['slider_pagi'] ? true : false,
			'fade' => 'yes' == $atts['slider_fade'] ? true : false,
		);
		if ( ! empty( $atts['slider_speed'] ) ) {
			$slider_config['speed'] = $atts['slider_speed'];
		}
		if ( ! empty( $atts['slider_delay'] ) ) {
			$slider_config['delay'] = $atts['slider_delay'];
		}
		/* Responsive Settings */
		$slider_config['view'] = $slider_config['t_view'] = $atts['columns']['size'];
		$slider_config['m_view'] = $slider_config['ms_view'] = 1;
		if ( isset( $atts['columns_tablet']['size'] ) && $atts['columns_tablet']['size'] ) {
			$slider_config['t_view'] = $atts['columns_tablet']['size'];
		}
		if ( isset( $atts['columns_mobile_extra']['size'] ) && $atts['columns_mobile_extra']['size'] ) {
			$slider_config['m_view'] = $atts['columns_mobile_extra']['size'];
		} else {
			if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
				$slider_config['m_view'] = $atts['columns_mobile']['size'];
			}
		}
		if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
			$slider_config['ms_view'] = $atts['columns_mobile']['size'];
		}

		/* Slider Atts */
		$slider_atts = array(
			'class' => 'th90-slider th90-quotes',
			'id'    => 'slider-' . absint( $block_id ),
		);

		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<div class="<?php echo esc_attr( implode( ' ', array_filter( $slider_classes ) ) ); ?>">
				<div <?php echo th90_stringify_attributes( $slider_atts ); ?> data-settings='<?php echo esc_attr( wp_json_encode( th90_slider_config_default( $slider_config ) ) ); ?>'>
					<?php
					/* Box Heading */
					$atts['_heading_nav'] = $atts['slider_nav'] && 'on_heading' == $atts['nav_position'] ? true : false;
					th90_box_heading( $atts );

					/* Render Posts */
					if ( ! empty( $atts['quotes'] ) ) {
						echo '<div class="slick-slider">';
							foreach ( $atts['quotes'] as $quote ) {
								?>
								<div class="slider-item">
									<?php
									get_template_part( 'template-parts/quote', '', array(
										'text'   => $quote['text'],
										'author' => $quote['author'],
									) );
									?>
								</div>
								<?php
							}
						echo '</div>';
						if ( 'yes' == $atts['slider_nav'] && 'on_heading' !== $atts['nav_position'] ) {
							echo '<div class="slider-arrow"></div>';
						}
					}
					?>
				</div>
				<?php  if ( 'yes' == $atts['slider_pagi'] ) { ?>
					<div class="slider-dots"></div>
				<?php } ?>
			</div>
			<?php  if ( 'yes' == $atts['slider_progress'] ) { ?>
				<div class="slick-progress"><span></span></div>
			<?php } ?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
