<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Imagelightbox extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-imagelightbox';
	}

	public function get_title() {
		return __( 'Image/Video Lightbox', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-image-rollover th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_responsive_control(
			'_image_radius',
			[
				'label' => esc_html__( 'Image radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .lightbox-box' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => '_overlay_bg',
				'label' => esc_html__( 'Background Overlay', 'atlas-core' ),
				'types' => [ 'classic', 'gradient'],
				'selector' => '{{WRAPPER}} .lightbox-box .bg-inside:before',
			]
		);
		$this->add_control(
			'type',
			[
				'label'   => esc_html__( 'Lightbox Type', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image' => esc_html__( 'Image', 'atlas-core' ),
					'youtube'   => esc_html__( 'Youtube', 'atlas-core' ),
					'vimeo'  => esc_html__( 'Vimeo', 'atlas-core' ),
				],
			]
		);
		$this->add_control(
			'youtube_url',
			[
				'label' => esc_html__( 'Youtube URL', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => 'http://youtu.be/xxx',
				'condition'   => [
					 'type' => ['youtube'],
				],
			]
		);
		$this->add_control(
			'vimeo_url',
			[
				'label' => esc_html__( 'Vimeo URL', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => 'http://vimeo.com/xxx',
				'condition'   => [
					 'type' => ['vimeo'],
				],
			]
		);
		$this->add_control(
			'video_autoplay',
			[
				'label'     => esc_html__('Video autoplay?', 'atlas-core'),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default'   => 'yes',
				'condition'   => [
					 'type' => ['vimeo','youtube'],
				],
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-lightbox',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );

			if ( empty( $atts['image'] ) ) { return; }
			?>
			<div class="lightbox-box">

			        <?php th90_the_add_lazyload( wp_get_attachment_image( $atts['image']['id'], 'full' ), $atts['image']['id'] ); ?>

					<?php

					if ( 'youtube' == $atts['type'] ) {
						$this->add_render_attribute( 'lightbox', 'class', 'f-icon f-video venobox' );
						$this->add_render_attribute( 'lightbox', 'data-vbtype', 'video' );
						$this->add_render_attribute( 'lightbox', 'href', $atts['youtube_url'] );
						if ( 'yes' == $atts['video_autoplay'] ) {
							$this->add_render_attribute( 'lightbox', 'data-autoplay', 'true' );
						}
						?>
						<a <?php $this->print_render_attribute_string( 'lightbox' ); ?>><?php th90_svg_icon( 'video' ); ?></a>
						<?php
					}  elseif ( 'vimeo' == $atts['type'] ) {
						$this->add_render_attribute( 'lightbox', 'class', 'f-icon f-video venobox' );
						$this->add_render_attribute( 'lightbox', 'data-vbtype', 'video' );
						$this->add_render_attribute( 'lightbox', 'href', $atts['vimeo_url'] );
						if ( 'yes' == $atts['video_autoplay'] ) {
							$this->add_render_attribute( 'lightbox', 'data-autoplay', 'true' );
						}
						?>
						<a <?php $this->print_render_attribute_string( 'lightbox' ); ?>><?php th90_svg_icon( 'video' ); ?></a>
						<?php
					} else {
						$this->add_render_attribute( 'lightbox', 'href', wp_get_attachment_image_src( $atts['image']['id'], 'full' )[0] );
						$this->add_render_attribute( 'lightbox', 'class', 'box-url venobox' );
						?>
						 <a <?php $this->print_render_attribute_string( 'lightbox' ); ?>></a>
						<?php
					}
					?>
				</div>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
