<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Gallery extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-gallery';
	}

	public function get_title() {
		return __( 'Gallery & Instagram', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid th90-widget-icon';
	}

	public function get_keywords() {
		return [ 'gallery', 'instagram', 'images' ];
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		/* Section General */
		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_control(
			'gallery_img',
			[
				'label' => esc_html__( 'Add Images', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$this->add_responsive_control(
			'gallery_columns',
			[
				'label' => __( 'Gallery Columns', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 15,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .block-egallery .egallery-item' => 'width: calc(100%/{{SIZE}});',
				],

			]
		);

		$this->add_responsive_control(
			'gallery_gap',
			[
				'label' =>esc_html__( 'Gallery Gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .block-egallery' => 'margin: calc(({{SIZE}}{{UNIT}}/2) * -1);',
					'{{WRAPPER}} .block-egallery .egallery-item' => 'padding: calc({{SIZE}}{{UNIT}}/2);',
				],
			]
		);

		$this->add_control(
			'gallery_link',
			[
				'label' => esc_html__( 'Link', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'lightbox',
				'options' => [
					'lightbox' => esc_html__( 'Lightbox', 'atlas-core' ),
					'custom' => esc_html__( 'Custom', 'atlas-core' ),
				],
			]
		);

		$this->add_control(
			'gallery_custom_link',
			[
				'label' => esc_html__( 'Link', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'https://your-link.com', 'atlas-core' ),
				'default' => [
					'url' => '#',
				],
				'condition'   => [
					 'gallery_link' => 'custom',
				],
			]
		);

		$this->add_responsive_control(
			'gallery_radius',
			[
				'label' => esc_html__( 'Image radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .block-egallery .thumb-container' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
				],
			]
		);

		$this->add_control(
			'add_instagram',
			[
				'label'       => esc_html__('Add instagram link button?', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label_on'    => esc_html__('Yes', 'atlas-core'),
				'label_off'   => esc_html__('No', 'atlas-core'),
				'default'     => 'yes',
			]
		);
		$this->add_control(
			'instagram_text',
			[
				'label' => esc_html__( 'Instagram button text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);
		$this->add_control(
			'instagram_link',
			[
				'label'       => __( 'Instagram button link', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'atlas-core' ),
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$instagram_link = isset( $atts['instagram_link']['url'] ) ? $atts['instagram_link']['url'] : '';
		if ( ! empty( $instagram_link ) ) {
			$this->add_link_attributes( 'link-instagram', $atts['instagram_link'] );
		}

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-gallery',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php th90_box_heading( $atts ); ?>
			<div class="block-egallery-wrap">
				<?php
				if ( 'yes' == $atts['add_instagram'] ) {
					if ( ! empty( $instagram_link ) ) { ?>
						<a class="instagram-galbtn button btn-small btn-accent" <?php echo wp_kses_post( $this->get_render_attribute_string( 'link-instagram' ) ); ?>>
					<?php } else {?>
						<div class="instagram-galbtn button btn-small btn-accent">
					<?php } ?>
						<?php th90_svg_icon_social( 'instagram' );?>
						<?php
						if ( $atts['instagram_text'] ) {
							esc_html_e( $atts['instagram_text'] );
						} else {
							th90_translate_p( 'Follow Me' );
						}
						?>
					<?php if ( ! empty( $instagram_link ) ) { ?>
						</a>
					<?php } else {?>
						</div>
					<?php }
				}
				?>
				<div class="block-egallery">
					<?php
					foreach ( $atts['gallery_img'] as $image ) {
						if ( 'lightbox' == $atts['gallery_link'] ) {
							?>
							<div class="egallery-item">
								<a class="venobox" data-gall="egallery-<?php echo esc_attr( $block_id ); ?>" href="<?php echo esc_url( wp_get_attachment_image_src( $image['id'], 'full' )[0] ); ?>">
									<div class="thumb-container thumb-100">
										<?php
										th90_the_add_lazyload( wp_get_attachment_image( $image['id'], 'large' ), $image['id'] );
										?>
									</div>
								</a>
							</div>
							<?php
						} else {
							if ( ! empty( $atts['gallery_link']['url'] ) ) {
								$this->add_link_attributes( 'image', $atts['gallery_link'] );
							}
							?>
							<div class="egallery-item">
								<a <?php $this->print_render_attribute_string( 'image' ); ?>>
									<div class="thumb-container thumb-100">
										<?php
										th90_the_add_lazyload( wp_get_attachment_image( $image['id'], 'large' ), $image['id'] );
										?>
									</div>
								</a>
							</div>
							<?php
						}
					}
					?>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
