<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Customlist extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-customlist';
	}

	public function get_title() {
		return __( 'Custom List', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ul th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_custom_list',
			[
				'label' => __( 'Text List or Custom Menu', 'atlas-core' ),
			]
		);

		$this->add_control(
			'menu',
			[
				'label'     => esc_html__( 'Show a menu', 'atlas-core' ),
				'description' => sprintf( esc_html__( 'Select if you want to show a menu. The menu items only showed on 1 level. Create menus from %1$sa here%2$s.', 'atlas-core' ), '<a href="' . admin_url('nav-menus.php?action=edit&menu=0') . '" target="_blank"><strong>', '</strong></a>' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => array_merge(
					array( '' => esc_html__( 'None', 'atlas-core' ) ),
					th90_get_terms( 'nav_menu', 'slug' )
				),
				'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => 'Lorem ipsum',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'link',
			[
				'label' => __( 'Text link', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '',
				],
			]
		);

		$this->add_control(
			'custom_list',
			[
				'label' => esc_html__( 'Custom Text List', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'text' => 'Lorem ipsum',
						'link' => [
							'url' => '',
						],
					],
					[
						'text' => 'Lorem ipsum',
						'link' => [
							'url' => '',
						],
					],
					[
						'text' => 'Lorem ipsum',
						'link' => [
							'url' => '',
						],
					],
				],
				'title_field' => '{{{ text }}}',
				'condition'   => [
					 'menu' => '',
				],
			]
		);

		$this->add_control(
			'item_view',
			[
				'label' => esc_html__( 'Layout', 'elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'block',
				'options' => [
					'inline' => [
						'title' => esc_html__( 'Inline', 'elementor' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'block' => [
						'title' => esc_html__( 'Block', 'elementor' ),
						'icon' => 'eicon-editor-list-ul',
					],
				],

				'prefix_class' => 'custom-list-',
			]
		);
		$this->add_responsive_control(
			'column',
			[
				'label' => esc_html__( 'Columns', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}}.custom-list-block ul.custom-list > li' => 'width: calc(100%/{{SIZE}});',
				],
				'default' => [],
				'condition'   => [
					 'item_view' => 'block',
				],
			]
		);

		$this->add_control(
			'item_align',
			[
				'label' => esc_html__( 'Alignments', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'options' => [
					'flex-start'    => [
						'title' => esc_html__( 'Left', 'atlas-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlas-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'atlas-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}.custom-list-block ul.custom-list li, {{WRAPPER}}.custom-list-inline ul.custom-list' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_space',
			[
				'label' => esc_html__( 'Item space', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'vh' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
					],
					'vw' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}}.custom-list-block ul.custom-list > li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}.custom-list-inline ul.custom-list > li' => 'margin-right: {{SIZE}}{{UNIT}};',
					'.rtl {{WRAPPER}}.custom-list-inline ul.custom-list > li' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'item_typo',
				'label'       => esc_html__( 'Item typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .custom-list ul li, {{WRAPPER}} ul.custom-list li',
			]
		);


		$this->add_control(
			'list_icon',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'   => esc_html__( 'Add icon?', 'atlas-core' ),
				'label_on'    => esc_html__('Yes', 'atlas-core'),
				'label_off'   => esc_html__('No', 'atlas-core'),
				'default'     => 'no',
				'prefix_class' => 'list-icon-',
				'condition'   => [
					 'item_view' => 'block',
				],
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-customlist',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );
			if ( $atts['menu'] ) {
				wp_nav_menu( array(
					'menu' => $atts['menu'],
					'container' => false,
					'menu_id' => 'custom-' . $atts['menu'],
					'menu_class' => 'custom-list',
					'depth' => 1,
				) );
			} else {
				if ( ! empty( $atts['custom_list'] ) ) {
					echo '<ul class="custom-list">';
					foreach ( $atts['custom_list'] as $text ) {
						if ( $text['text'] ) {
							echo '<li>';
							if ( ! empty( $text['link']['url'] ) ) {
								$this->add_link_attributes( 'item', $text['link'] );
								?>
								<a <?php $this->print_render_attribute_string( 'item' ); ?>>
									<?php echo do_shortcode( $text['text'] ); ?>
								</a>
								<?php
							} else {
								echo do_shortcode( $text['text'] );;
							}
							echo '</li>';
						}
					}
					echo '</ul>';
				}
			}
			?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
