<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Contact7 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-contact7';
	}

	public function get_title() {
		return __( 'Contact Form 7', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-mail th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		/* Section General */
		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_control(
			'form',
			[
				'label'     => esc_html__( 'Contact Form 7', 'atlas-core' ),
				'description' => esc_html__( 'Select the contact form.', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => th90_get_posts_id( 'wpcf7_contact_form' ),
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-contact7',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );
			echo do_shortcode( '[contact-form-7  id="' . $atts['form'] . '"]' );
			?>

		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
