<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Comments extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-comments';
	}

	public function get_title() {
		return __( 'Recent Comments', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-comments th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$controls = new TH90_Controls();

		/* Section General */
		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_responsive_control(
			'_post_hspace',
			[
				'label' =>esc_html__( 'Comments space(gap)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'size' => 20,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .posts-list' => 'margin-bottom: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .posts-list > *' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .post-item:not(:first-child) > *::before' => 'top: calc(({{SIZE}}{{UNIT}} / 2) * -1);',
				],
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => esc_html__( 'Number', 'atlas-core' ),
				'description' => esc_html__('Number of comments', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => '3',
			]
		);

		$this->end_controls_section();

		/* Widget Boxed */
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-comments',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );

			$args = array(
				'number'    => $atts['number'],
				'status'    => 'approve',
				'type'      => 'comment',
				'orderby'   => 'comment_date',
				'post_type' => array( 'post', 'page' ),
			);

			$comments_query = new WP_Comment_Query;
			$comments = $comments_query->query( $args );
			?>
			<div class="rcomments posts-list clearfix post-list-columns">
				<?php
				foreach ( $comments as $comment ) {
					get_template_part( 'template-parts/comment', '', array(
						'comment'   => $comment,
						'attr'		=> $atts,
					) );
				}
				?>
			</div>
		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
