<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Bannerbox extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-bannerbox';
	}

	public function get_title() {
		return __( 'Banner/Advertisement', 'atlas-core' );
	}

	public function get_keywords() {
		return [ 'ads', 'monetize', 'adsense' ];
	}

	public function get_icon() {
		return 'eicon-banner th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$controls = new TH90_Controls();
		$this->start_controls_section(
			'b_section',
			[
				'label' => __( 'Banner/Advertisement Settings', 'atlas-core' ),
			]
		);
		$controls->banner_default( $this );

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array(
			'th90-block',
			'block-banner',
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			if ( 'yes' == $atts['b_ads_custom'] ) {
				get_template_part( 'template-parts/banner', '', array(
					'block' => $atts,
				) );
			} else {
				th90_render_ads( $atts['b_ads'] );
			}
			?>
		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
