<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_W_Aboutus extends \Elementor\Widget_Base {

	public function get_name() {
		return 'w-aboutus';
	}

	public function get_title() {
		return __( 'About Us', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-person th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$controls = new TH90_Controls();

		/* Section General */
		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'phone',
			[
				'label' => esc_html__( 'Phone', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'You phone', 'atlas-core' ),
			]
		);
		$this->add_control(
			'email',
			[
				'label' => esc_html__( 'Email', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'You email', 'atlas-core' ),
			]
		);
		$this->add_control(
			'address',
			[
				'label' => esc_html__( 'Address', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
				'rows' => 5,
				'default' => esc_html__( 'You address', 'atlas-core' ),
			]
		);
		$this->add_control(
			'desc',
			[
				'label' => esc_html__( 'Description', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
				'rows' => 5,
				'default' => esc_html__( 'You description', 'atlas-core' ),
			]
		);
		$controls->logo_settings( $this );


		$this->end_controls_section();

		/* Widget Boxed */
		$controls->box_settings( $this );

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-aboutus',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">

			<?php
			th90_box_heading( $atts );
			?>
			<div class="about-us">
				<?php
				$atts['logo_id']             = ! empty( $atts['logo'] ) ? $atts['logo']['id'] : '';
				$atts['logo_retina_id']      = ! empty( $atts['logo_retina'] ) ? $atts['logo_retina']['id'] : '';
				$atts['logo_dark_id']        = ! empty( $atts['logo_dark'] ) ? $atts['logo_dark']['id'] : '';
				$atts['logo_dark_retina_id'] = ! empty( $atts['logo_dark_retina'] ) ? $atts['logo_dark_retina']['id'] : '';

				if ( ! empty( $atts['custom_link']['url'] ) ) {
					$this->add_link_attributes( 'logo_link', $atts['custom_link'] );
					$atts['link'] = $this->get_render_attribute_string( 'logo_link' );
				}
				if ( 'default' !== $atts['logo_type'] ) {
					th90_logo( $atts );
				} else {
					th90_logo();
				}
				?>

				<div class="aboutus-desc">
					<?php
					if ( $atts['desc'] ) {
						?>
						<div class="desc">
							<?php echo do_shortcode( $atts['desc'] ); ?>
						</div>
						<?php
					}
					?>
					<?php
					if ( $atts['phone'] ) {
						?>
						<div class="phone">
							<?php th90_svg_icon( 'phone' ); ?>
							<?php echo do_shortcode( $atts['phone'] ); ?>
						</div>
						<?php
					}
					?>
					<?php
					if ( $atts['email'] ) {
						?>
						<div class="email">
							<?php th90_svg_icon_social( 'email' ); ?>
							<?php echo do_shortcode( $atts['email'] ); ?>
						</div>
						<?php
					}
					?>

					<?php
					if ( $atts['address'] ) {
						?>
						<div class="address">
							<?php th90_svg_icon( 'location' ); ?>
							<?php echo do_shortcode( $atts['address'] ); ?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
