<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_T_Block extends \Elementor\Widget_Base {

	public function get_name() {
		return 't-block';
	}

	public function get_title() {
		return __( 'Block Template', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-layout-settings th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-templates' ];
	}

	protected function register_controls() {

		/* Section General */
		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'Block Template', 'atlas-core' ),
			]
		);

		$this->add_control(
			'note',
			[
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => sprintf( esc_html__( 'You can add and edit the block template from %1$shere%2$s.', 'atlas-core' ), '<a href="' . admin_url('edit.php?post_type=th90_block') . '" target="_blank"><strong>', '</strong></a>' ),
				//'content_classes' => 'elementor-descriptor',
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);

		$this->add_control(
			'block',
			[
				'label'       => esc_html__('Block Template', 'atlas-core'),
				'description' => esc_html__('Select the block template', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => th90_get_posts_id( 'th90_block' ),
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		if ( $atts['block'] ) {
			echo th90_display_elementor_content( $atts['block'] );
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
