<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_S_Ticker extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return [ 'th90-front' ];
	}

	public function get_name() {
		return 's-ticker';
	}

	public function get_title() {
		return __( 'NewsTicker', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-animation-text th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-sliders' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'speed',
			[
				'label' => __( 'Speed', 'atlas-core' ),
				'description' => __( 'Specify the time (in milliseconds)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 10000,
				'step' => 1,
				'default' => 3000,
			]
		);
		$this->add_control(
            'head',
            [
                'label'     => esc_html__('Show heading?', 'atlas-core'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default'   => 'yes',
            ]
        );
		$this->add_control(
			'head_text',
			[
				'label'       => esc_html__( 'Heading text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => 'Popular',
				'label_block' => true,
				'condition'   => [ 'head' => ['yes'] ],
			]
		);
		$this->add_control(
			'head_icon',
			[
				'label'       => esc_html__( 'Custom heading SVG icon', 'atlas-core' ),
				'placeholder' => '<svg ...> ... </svg>',
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => '',
				'label_block' => true,
				'condition'   => [ 'head' => ['yes'] ],
			]
		);
		$this->add_control(
            'first_cat',
            [
                'label'     => esc_html__('Show first category?', 'atlas-core'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default'   => 'no',
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_content_t',
				'label' => esc_html__( 'Content typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .post-ticker .entry-title',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_heading_t',
				'label' => esc_html__( 'Heading typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .ticker-head h4',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'_section_box',
			[
				'label' => __( 'Box Ticker', 'atlas-core' ),
			]
		);
		$this->add_responsive_control(
			'_box_padding',
			[
				'label' => esc_html__( 'Box ticker padding', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .block-tickerwrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'_box_bg_light',
			[
				'label' => esc_html__('Ticker background color - Light Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'.site-light {{WRAPPER}} .block-tickerwrap' => 'background: linear-gradient(to top left, {{VALUE}} -2500%,#0000 300%);',
				],
			]
		);
        $this->add_control(
			'_box_bg_dark',
			[
				'label' => esc_html__('Ticker background color - Dark Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'.site-dark {{WRAPPER}} .block-tickerwrap' => 'background: linear-gradient(to top left, {{VALUE}} -2500%,#0000 300%);',
				],
			]
		);
		/*$this->add_control(
			'_head_light_box', [
				'separator' => 'before',
				'label' => esc_html__('Ticker background color - Light Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
        $element->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'light_box_color',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-light',
			]
		);
        $element->add_control(
			'_head_dark_box', [
				'separator' => 'before',
				'label' => esc_html__('Ticker background color - Dark Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::HEADING,

			]
		);
        $element->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'dark_box__color',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-dark',
			]
		);
		/*$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_content_typography',
				'label' => esc_html__( 'Content typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .ticker-content',
			]
		);
		$this->add_control(
			'_content_color',
			[
				'label' => esc_html__('Content color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ticker-content, {{WRAPPER}} .ticker-content a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
		   '_content_hv_color',
		   [
			  'label' => esc_html__('Content hover color', 'atlas-core'),
			  'type' => \Elementor\Controls_Manager::COLOR,
			  'default' => '',
			  'selectors' => [
				  '{{WRAPPER}} .ticker-content a:hover' => 'color: {{VALUE}};',
			  ],
		   ]
	   );*/

		$this->end_controls_section();

	}

	public function controls_query() {
		/* Section Query */
		$this->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Posts Query', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->general_query_default( $this );
		$controls->query_default( $this );
		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_query();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		/* Module Classes */
		$wrapper_classes = array(
			'th90-block',
			'th90-blockticker',
		);

		/* Render HTML */
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<?php
			echo '<div class="block-tickerwrap">';
				if ( $atts['head'] && $atts['head_text'] ) {
					echo '<div class="ticker-head">';
						if ( $atts['head_icon'] ) {
			                th90_svg_icon_custom( $atts['head_icon'] );
			            } else {
			                th90_svg_icon( 'hot' );
			            }
						echo '<h4 class="h6">' . esc_html( $atts['head_text'] ) . '</h4>';
					echo '</div>';
				}
			    echo '<div class="th90-ticker block-newsticker" data-speed="' . absint( $atts['speed'] ? $atts['speed'] : 3000 ) . '">';
			        echo '<div class="posts">';
						$block_query = th90_query( $atts );
						while ( $block_query->have_posts() ) {
							$block_query->the_post();
							?>
							<div class="itemWrap">
								<?php
								get_template_part( 'template-parts/posts/post', 'ticker', array(
									'block'     => $atts,
									'count'     => '',
								) );
								?>
							</div>
							<?php
						} wp_reset_postdata();

					echo '</div>';

			    echo '</div>';
			echo '</div>';
			?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {

	}
}
