<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_S_Sliderthumb extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return [ 'slick', 'th90-front' ];
	}

	public function get_name() {
		return 's-sliderthumb';
	}

	public function get_title() {
		return __( 'Slider with Thumbnail', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-thumbnails-right th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-sliders' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$controls = new TH90_Controls();
		$controls->general_query_default( $this );

		$this->add_responsive_control(
			'columns',
			[
				'label' => __( 'Thumbnails Columns', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 15,
					],
				],
				'default' => [
					'size' => 4,
					'unit' => 'px',
				],
			]
		);

		$this->add_control(
			'slider_speed',
			[
				'label' => __( 'Slider speed', 'atlas-core' ),
				'description' => __( 'Speed in milliseconds', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 200,
				'max' => 3000,
				'step' => 1,
				'default' => 500,
			]
		);

		/* Default Post Options */
		$this->add_control(
			'post_style',
			[
				'label' => esc_html__( 'Big Post Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HIDDEN,
				'default' => 'hero',
			]
		);

		$controls->post_default( $this, '', '', true );

		$this->end_controls_section();
	}

	public function controls_query() {
		/* Section Query */
		$this->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Posts Query', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->query_default( $this );
		$this->end_controls_section();
	}

	public function style_controls_posts() {

		$this->start_controls_section(
			'_section_style_post',
			[
				'label' => __( 'Post Style', 'atlas-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$controls = new TH90_Controls();
		$controls->post_style_default( $this );

		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_query();

		$this->style_controls_posts();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$atts['categories'] = ! empty( $atts['categories'] ) ? implode( ',', $atts['categories'] ) : '';
		$atts['tags'] = ! empty( $atts['tags'] ) ? implode( ',', $atts['tags'] ) : '';
		$atts['posts'] = ! empty( $atts['posts'] ) ? implode( ',', $atts['posts'] ) : '';
		$atts['formats'] = ! empty( $atts['formats'] ) ? implode( ',', $atts['formats'] ) : '';
		$atts = th90_archive_related_atts( $atts );

		/* Module Classes */
		$wrapper_classes = array(
			'th90-block',
		);

		/* Slider Classes */
		$slider_classes = array(
			'block-slider',
			'slider-thumbs',
			'nav-bottom_left',
		);

		/* Slider Config */
		$slider_config = array(
			'loop' => true,
			'fade' => true,
			'autoplay' => true,
			'delay' => 5000,
			'asNavFor' => '.slickthumb-' . absint( $block_id ),
		);

		$slider_config['view'] = 1;
		$slider_config['t_view'] = 1;
		$slider_config['m_view'] = 1;
		$slider_config['ms_view'] = 1;

		$slider_thumb_config = array(
			'loop' => true,
			'autoplay' => true,
			'asNavFor' => '.slick-' . absint( $block_id ),
			'autoHeight' => false,
			'vertical' => true,
			'focusOnSelect' => true,
			'nav' => false,
			'delay' => 5000,
		);
		/* Responsive Settings */
		$slider_thumb_config['view'] = $slider_thumb_config['t_view'] = $atts['columns']['size'];
		$slider_thumb_config['m_view'] = $slider_thumb_config['ms_view'] = 1;
		if ( isset( $atts['columns_tablet']['size'] ) && $atts['columns_tablet']['size'] ) {
			$slider_thumb_config['t_view'] = $atts['columns_tablet']['size'];
		}
		if ( isset( $atts['columns_mobile_extra']['size'] ) && $atts['columns_mobile_extra']['size'] ) {
			$slider_thumb_config['m_view'] = $atts['columns_mobile_extra']['size'];
		} else {
			if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
				$slider_thumb_config['m_view'] = $atts['columns_mobile']['size'];
			}
		}
		if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
			$slider_thumb_config['ms_view'] = $atts['columns_mobile']['size'];
		}

		if ( ! empty( $atts['slider_speed'] ) ) {
			$slider_config['speed'] = $atts['slider_speed'];
			$slider_thumb_config['speed'] = $atts['slider_speed'];
		}

		/* Slider Atts */
		$slider_atts = array(
			'class' => 'th90-slider slider-main',
			'id'    => 'slider-' . absint( $block_id ),
		);

		$slider_thumb_atts = array(
			'class' => 'th90-slider navFor',
			'id'    => 'slider-thumb-' . absint( $block_id ),
		);

		$atts = th90_blog_atts_convert( $atts );

		/* Render HTML */
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<div class="<?php echo esc_attr( implode( ' ', array_filter( $slider_classes ) ) ); ?>">

				<div <?php echo th90_stringify_attributes( $slider_atts ); ?> data-settings='<?php echo esc_attr( wp_json_encode( th90_slider_config_default( $slider_config ) ) ); ?>'>
					<?php
					/* Render Posts */
					echo '<div class="slider-wrap">';
					$count = 0;
					$block_query = th90_query( $atts );
					if ( $block_query->have_posts() ) {
						echo '<div class="slick-slider slick-' . absint( $block_id ) . '">';
							while ( $block_query->have_posts() ) {
								$block_query->the_post();
								$count++;
								?>
								<div class="slider-item">
									<?php
									get_template_part( 'template-parts/posts/post', $atts['post_style'], array(
										'block'     => $atts,
										'count'     => $count,
									) );
									?>
								</div>
								<?php
								// Do not duplicate posts ----------
								if ( isset( $atts['not_show_duplicate'] ) && 'yes' == $atts['not_show_duplicate'] ) {
									th90_do_not_duplicate( get_the_ID() );
								}
							} wp_reset_postdata();
						echo '</div>';
						echo '<div class="slider-arrow"></div>';
					}
					echo '</div>';
					?>
				</div>

				<div <?php echo th90_stringify_attributes( $slider_thumb_atts ); ?> data-settings='<?php echo esc_attr( wp_json_encode( th90_slider_config_default( $slider_thumb_config ) ) ); ?>'>
					<?php
					/* Render Posts */
					echo '<div class="slider-wrap">';
					$count = 0;
					$block_query = th90_query( $atts );
					if ( $block_query->have_posts() ) {
						echo '<div class="slick-slider slickthumb-' . absint( $block_id ) . '">';
							while ( $block_query->have_posts() ) {
								$block_query->the_post();
								$count++;
								?>
								<div class="slider-item">
									<?php get_template_part( 'template-parts/posts/slider', 'thumb' ); ?>
								</div>
								<?php
								// Do not duplicate posts ----------
								if ( isset( $atts['not_show_duplicate'] ) && 'yes' == $atts['not_show_duplicate'] ) {
									th90_do_not_duplicate( get_the_ID() );
								}
							} wp_reset_postdata();
						echo '</div>';
					}
					echo '</div>';
					?>
				</div>

			</div>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
