<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_S_Postssmallslider extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return [ 'slick', 'th90-front' ];
	}

	public function get_name() {
		return 's-postssmallslider';
	}

	public function get_title() {
		return __( 'Post Small Slider', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-carousel th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-sliders' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$controls = new TH90_Controls();
		$controls->general_query_default( $this );

		/* Controls Slider */
		$this->add_control(
			'_head_slider_setting', [
				'separator' => 'before',
				'label' => __( 'Slider Settings', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$controls->slider_settings( $this );
		$this->end_controls_section();
	}

	public function controls_posts() {
		$this->start_controls_section(
			'_section_posts_setting', [
				'label' => __( 'Posts Settings', 'atlas-core' ),
			]
		);

		/* Post Count */
		$this->add_control(
			'_head_posts_count', [
				'separator' => 'before',
				'label' => __( 'Posts Count', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_control(
			'have_number',
			[
				'label'       => esc_html__('Show post count?', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label_on'    => esc_html__('Yes', 'atlas-core'),
				'label_off'   => esc_html__('No', 'atlas-core'),
				'default'     => 'no',
			]
		);

		/* Default Post Options */
		$controls = new TH90_Controls();
		$controls->post_default( $this, 'small' );

		$this->end_controls_section();
	}

	public function controls_query() {
		/* Section Query */
		$this->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Posts Query', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->query_default( $this );
		$this->end_controls_section();
	}

	public function style_controls_posts() {

		$this->start_controls_section(
			'_section_style_post',
			[
				'label' => __( 'Post Style', 'atlas-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$controls = new TH90_Controls();
		$controls->post_style_default( $this, 'small' );

		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_posts();

		$this->controls_query();

		$this->style_controls_posts();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this, 'no' );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$atts['categories'] = ! empty( $atts['categories'] ) ? implode( ',', $atts['categories'] ) : '';
		$atts['tags'] = ! empty( $atts['tags'] ) ? implode( ',', $atts['tags'] ) : '';
		$atts['posts'] = ! empty( $atts['posts'] ) ? implode( ',', $atts['posts'] ) : '';
		$atts['formats'] = ! empty( $atts['formats'] ) ? implode( ',', $atts['formats'] ) : '';
		$atts = th90_archive_related_atts( $atts );

		/* Module Classes */
		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'posts-slider',
			),
			th90_box_class( $atts )
		);

		/* Slider Classes */
		$slider_classes = array(
			'block-slider',
			'yes' == $atts['slider_nav'] ? 'nav-' . $atts['nav_position'] : '',
			'yes' == $atts['slider_pagi'] ? 'dots-' . $atts['pagi_dot_align'] : '',
		);

		/* Slider Config */
		$slider_config = array(
			'loop' => 'yes' == $atts['slider_loop'] ? true : false,
			'autoHeight' => 'yes' == $atts['slider_autoHeight'] ? true : false,
			'center' => 'yes' == $atts['slider_center'] ? true : false,
			'autoplay' => 'yes' == $atts['slider_auto'] ? true : false,
			'nav' => 'yes' == $atts['slider_nav'] ? true : false,
			'dots' => 'yes' == $atts['slider_pagi'] ? true : false,
			'fade' => 'yes' == $atts['slider_fade'] ? true : false,
		);
		if ( ! empty( $atts['slider_speed'] ) ) {
			$slider_config['speed'] = $atts['slider_speed'];
		}
		if ( ! empty( $atts['slider_delay'] ) ) {
			$slider_config['delay'] = $atts['slider_delay'];
		}

		/* Responsive Settings */
		$slider_config['view'] = $slider_config['t_view'] = $atts['columns']['size'];
		$slider_config['m_view'] = $slider_config['ms_view'] = 1;
		if ( isset( $atts['columns_tablet']['size'] ) && $atts['columns_tablet']['size'] ) {
			$slider_config['t_view'] = $atts['columns_tablet']['size'];
		}
		if ( isset( $atts['columns_mobile_extra']['size'] ) && $atts['columns_mobile_extra']['size'] ) {
			$slider_config['m_view'] = $atts['columns_mobile_extra']['size'];
		} else {
			if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
				$slider_config['m_view'] = $atts['columns_mobile']['size'];
			}
		}
		if ( isset( $atts['columns_mobile']['size'] ) && $atts['columns_mobile']['size'] ) {
			$slider_config['ms_view'] = $atts['columns_mobile']['size'];
		}

		/* Slider Atts */
		$slider_atts = array(
			'class' => 'th90-slider',
			'id'    => 'slider-' . absint( $block_id ),
		);

		$atts = th90_blog_atts_convert( $atts );

		/* Render HTML */
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<div class="<?php echo esc_attr( implode( ' ', array_filter( $slider_classes ) ) ); ?>">
				<div <?php echo th90_stringify_attributes( $slider_atts ); ?> data-settings='<?php echo esc_attr( wp_json_encode( th90_slider_config_default( $slider_config ) ) ); ?>'>
					<?php
					/* Box Heading */
					$atts['_heading_nav'] = $atts['slider_nav'] && 'on_heading' == $atts['nav_position'] ? true : false;
					th90_box_heading( $atts );

					/* Render Posts */
					echo '<div class="slider-wrap">';
					$count = 0;
					$block_query = th90_query( $atts );
					if ( $block_query->have_posts() ) {
						echo '<div class="slick-slider">';
							while ( $block_query->have_posts() ) {
								$block_query->the_post();
								$count++;
								?>
								<div class="slider-item">
									<?php
									get_template_part( 'template-parts/posts/post', $atts['post_style'], array(
										'block'     => $atts,
										'count'     => $count,
									) );
									?>
								</div>
								<?php
								// Do not duplicate posts ----------
								if ( isset( $atts['not_show_duplicate'] ) && 'yes' == $atts['not_show_duplicate'] ) {
									th90_do_not_duplicate( get_the_ID() );
								}
							} wp_reset_postdata();
						echo '</div>';
						if ( 'yes' == $atts['slider_nav'] && 'on_heading' !== $atts['nav_position'] ) {
							echo '<div class="slider-arrow"></div>';
						}
					}
					echo '</div>';
					?>
				</div>
				<?php  if ( 'yes' == $atts['slider_pagi'] ) { ?>
					<div class="slider-dots"></div>
				<?php } ?>
			</div>
			<?php  if ( 'yes' == $atts['slider_progress'] ) { ?>
				<div class="slick-progress"><span></span></div>
			<?php } ?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
