<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_P_Grid1 extends \Elementor\Widget_Base {

	public function get_script_depends() {
		return [ 'viewportchecker', 'th90-front' ];
	}

	public function get_name() {
		return 'p-grid1';
	}

	public function get_title() {
		return __( 'Posts Grid 1', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-posts-justified th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-posts' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$controls = new TH90_Controls();
		$controls->general_query_default( $this );

		/*$this->add_control(
			'_post_sep',
			[
                'label'        => esc_html__( 'Add Post Separator?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
			]
		);*/

		$this->add_responsive_control(
			'_post_hspace',
			[
				'label' =>esc_html__( 'Horizontal posts space(gap)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'size' => 20,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-list-grids' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'_post_vspace',
			[
				'label' =>esc_html__( 'Vertical posts space(gap)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'size' => 20,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-list-grids' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		/* Default Post Options */
		$this->add_control(
			'post_style',
			[
				'label' => esc_html__( 'Big Post Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HIDDEN,
				'default' => 'medium1',
			]
		);
		$controls->post_default( $this, '', '', true );

		$this->end_controls_section();

	}

	public function controls_query() {
		/* Section Query */
		$this->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Posts Query', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->query_default( $this );
		$this->end_controls_section();
		/* Posts Sort */
		$controls->sort_default( $this );
	}

	public function controls_pagination() {
		/* Section Pagination */
		$this->start_controls_section(
			'_section_pagination',
			[
				'label' => __( 'Pagination', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->pagination_default( $this );
		$this->end_controls_section();
	}

	public function controls_banner() {
		/* Section Banner */
		$this->start_controls_section(
			'_section_banner',
			[
				'label' => __( 'Posts Banner/Ads', 'atlas-core' ),
			]
		);
		$this->add_control(
			'post_ads',
			[
				'label' => esc_html__('Add banner between posts?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => false,
			]
		);
		$this->add_control(
			'post_ads_pos',
			[
				'label' => esc_html__( 'Banner position', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'condition' => [
                    'post_ads' => ['yes'],
                ],
			]
		);
		$controls = new TH90_Controls();
		$controls->banner_default( $this );

		$this->end_controls_section();
	}

	public function style_controls_posts() {

		$this->start_controls_section(
			'_section_style_post',
			[
				'label' => __( 'Post Style', 'atlas-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$controls = new TH90_Controls();
		$controls->post_style_default( $this );
		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_query();

		$this->controls_pagination();

		$this->controls_banner();

		$this->style_controls_posts();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this, 'no' );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$atts['categories'] = ! empty( $atts['categories'] ) ? implode( ',', $atts['categories'] ) : '';
		$atts['tags'] = ! empty( $atts['tags'] ) ? implode( ',', $atts['tags'] ) : '';
		$atts['posts'] = ! empty( $atts['posts'] ) ? implode( ',', $atts['posts'] ) : '';
		$atts['formats'] = ! empty( $atts['formats'] ) ? implode( ',', $atts['formats'] ) : '';
		$atts = th90_archive_related_atts( $atts );

		$atts['is_grid'] = true;
		$atts['grid_type'] = 'one';

		/* Module Classes */
		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'posts-grid1',
			),
			th90_box_class( $atts )
		);

		$atts = th90_blog_atts_convert( $atts );

		/* Render HTML */
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>" data-current="1">
			<?php
			th90_box_heading( $atts );

			/* Render Posts */
			th90_render_posts_loop( th90_query( $atts ), $atts );

			/* Render Pagination */
			th90_render_pagination( th90_query( $atts ), $atts );
			?>
		</div>
		<?php
		/* Ajax JSON Pagination */
		if ( ( ! empty( $atts['pagi'] ) && 'numeric' != $atts['pagi'] ) || ( isset( $atts['_sort'] ) && 'yes' == $atts['_sort'] ) ) {
			th90_json_pagination( $block_id, $atts );
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {

	}
}
