<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_G_Postsgroup6 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'g-postsgroup6';
	}

	public function get_title() {
		return __( 'Posts Group 6', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-posts-group th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-groups' ];
	}

	public function controls_general() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$controls = new TH90_Controls();
		$controls->general_query_default( $this );

		$this->add_control(
			'_post_sep',
			[
                'label'        => esc_html__( 'Add Post Separator?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
			]
		);

		$this->add_responsive_control(
			'_big_width',
			[
				'label' =>esc_html__( 'Big post width', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 20,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-list-grids' => 'grid-template-columns: {{SIZE}}% 1fr;',
				],
			]
		);

		$this->add_responsive_control(
			'_post_hspace',
			[
				'label' =>esc_html__( 'Horizontal posts space(gap)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-list-grids, {{WRAPPER}} .post-list-childs' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .post-item:not(:first-child) > *::before' => 'top: calc(({{SIZE}}{{UNIT}} / 2) * -1);',
				],
			]
		);
		$this->add_responsive_control(
			'_post_vspace',
			[
				'label' =>esc_html__( 'Vertical posts space(gap)', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-list-grids, {{WRAPPER}} .post-list-childs' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	public function controls_posts() {
		$controls = new TH90_Controls();

		$this->start_controls_section(
			'section_post_big',
			[
				'label' => __( 'Big Post', 'atlas-core' ),
			]
		);
		$this->add_control(
			'post_style',
			[
				'label' => esc_html__( 'Big Post Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HIDDEN,
				'default' => 'medium1',
			]
		);
		$controls->post_default( $this, '', '_b', true );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_post_small',
			[
				'label' => __( 'Small Posts', 'atlas-core' ),
			]
		);

		$controls->post_default( $this, '', '_s', true  );

		$this->end_controls_section();
	}

	public function controls_query() {
		/* Section Query */
		$this->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Posts Query', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->query_default( $this );

		$this->end_controls_section();

		/* Posts Sort */
		$controls->sort_default( $this );
	}

	public function style_controls_posts() {

		$controls = new TH90_Controls();

		$this->start_controls_section(
			'_section_style_post_big',
			[
				'label' => __( 'Post big Style', 'atlas-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$controls->post_style_default( $this, '', '_b' );
		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_post_small',
			[
				'label' => __( 'Post small Style', 'atlas-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$controls->post_style_default( $this, '', '_s' );
		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_general();

		$this->controls_posts();

		$this->controls_query();

		$this->style_controls_posts();

		/* Widget Boxed */
		$controls = new TH90_Controls();
		$controls->box_settings( $this );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();
		$atts['categories'] = ! empty( $atts['categories'] ) ? implode( ',', $atts['categories'] ) : '';
		$atts['tags'] = ! empty( $atts['tags'] ) ? implode( ',', $atts['tags'] ) : '';
		$atts['posts'] = ! empty( $atts['posts'] ) ? implode( ',', $atts['posts'] ) : '';
		$atts['formats'] = ! empty( $atts['formats'] ) ? implode( ',', $atts['formats'] ) : '';
		$atts = th90_archive_related_atts( $atts );
		$atts['group_style'] = 'group4';
		$atts['post_style'] = $atts['group_style'];
		$atts['group_big'] = 'medium1';
		$atts['group_small'] = 'medium1';

		/* Module Classes */
		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-group',
				'block-groupmedium2',
				'block-' . $atts['group_style'],
				'yes' == $atts['_post_sep'] ? 'post_sep-' . $atts['_post_sep'] : '',
			),
			th90_box_class( $atts )
		);

		$atts = th90_blog_atts_convert( $atts, '_b' );
		$atts = th90_blog_atts_convert( $atts, '_s' );

		/* Render HTML */
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<?php
			th90_box_heading( $atts );

			/* Render Posts */
			$block_query = th90_query( $atts );
			th90_render_posts_loop( $block_query, $atts );

			?>
		</div>
		<?php
		/* Ajax JSON Pagination */
		if ( isset( $atts['_sort'] ) && 'yes' == $atts['_sort'] ) {
			th90_json_pagination( $block_id, $atts );
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {

	}
}
