<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Triggeroffcanvas extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-triggeroffcanvas';
	}

	public function get_title() {
		return __( 'OffCanvas/Mobile Menu Trigger', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-menu-bar th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_trigger',
			[
				'label' => __( 'OffCanvas/Mobile Menu Trigger Settings', 'atlas-core' ),
			]
		);
		$this->add_control(
			'_trigger_note',
			[
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw'	=> sprintf( esc_html__( 'You can settings the OffCanvas/Mobile Menu from %1$sTheme Options%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('?page=th90_options&tab=11') . '"><strong>', '</strong></a>' ),
				//'content_classes' => 'elementor-descriptor',
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			]
		);
		$controls = new TH90_Controls();
		$controls->btn_trigger( $this, 'offcanvas' );
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		?>
		<div class="trigger-wrap">
			<?php th90_trigger_button( 'offcanvas', $atts ); ?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
