<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Triggercart extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-triggercart';
	}

	public function get_title() {
		return __( 'Cart Trigger', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-cart-light th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_trigger',
			[
				'label' => __( 'Cart Trigger Settings', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->btn_trigger( $this );
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		?>
		<div class="trigger-wrap">
			<?php th90_trigger_button( 'cart', $atts ); ?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
