<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_social extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-social';
	}

	public function get_title() {
		return __( 'Social', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-social-icons th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$controls = new TH90_Controls();

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$controls->general_socials( $this );

		$this->end_controls_section();

		$this->start_controls_section(
			'section_accounts',
			[
				'label' => __( 'Socials Account', 'atlas-core' ),
			]
		);

		$controls->account_socials( $this );

		$this->end_controls_section();

		/* Widget Boxed */
		$controls->box_settings( $this, 'no' );
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array_merge(
			array(
				'th90-block',
				'block-socials',
			),
			th90_box_class( $atts )
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<?php th90_box_heading( $atts ); ?>
			<?php th90_core_the_socials( $atts, $atts['style'] ); ?>
		</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
