<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Mainmenu extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-mainmenu';
	}

	public function get_title() {
		return __( 'Menu Navigation', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-nav-menu th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		$skins = array();
	    foreach ( th90_default_options()['skins'] as $key => $value ) {
	        $skins[$key]['title'] = 'Style ' . $key;
	        $skins[$key]['imagesmall'] = $value['img'];
			$skins[$key]['width'] = '33.3%';
	        $skins[$key]['width'] = '95px';
	    }

		$this->start_controls_section(
			'section_menu',
			[
				'label' => __( 'Menu Settings', 'atlas-core' ),
			]
		);

		$this->add_control(
			'menu',
			[
				'label'     => esc_html__( 'Menu', 'atlas-core' ),
				'description' => sprintf( esc_html__( 'Default menu is main menu. Create custom menus from %1$shere%2$s.', 'atlas-core' ), '<a href="' . admin_url('nav-menus.php?action=edit&menu=0') . '" target="_blank"><strong>', '</strong></a>' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => array_merge(
					array(
						'' => 'Default',
					),
					th90_get_terms( 'nav_menu', 'slug' )
				),
				'label_block' => true,
			]
		);

		$this->add_responsive_control(
			'menu_height',
			[
				'label' => esc_html__( 'Menu height', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .navmain-wrap' => 'height: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
			]
		);

		$this->add_responsive_control(
			'menu_item_space',
			[
				'label' =>esc_html__( 'Menu item space', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'vw'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'vw' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} ul.nav-main > li > .menu-item-space' => 'width: {{SIZE}}{{UNIT}};',
				],

			]
		);

		$this->add_control(
			'menu_hov',
			[
				'label'   => esc_html__( 'Menu hover style', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'atlas-core' ),
					'color'   => esc_html__( 'Colored', 'atlas-core' ),
					'none'   => esc_html__( 'None', 'atlas-core' ),
				],
			]
		);

		$this->add_control(
			'menu_parent_indicator',
			[
				'label'     => esc_html__( 'Parent items arrow indicator', 'atlas-core' ),
				'description' => esc_html__( 'If you want to activated indicator on first level of menu when they have submenu', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default'   => 'yes',
			]
		);

		// Divider Icon
		$this->add_control(
			'div_icon_active',
			[
				'label'     => esc_html__( 'Activate divider icon', 'atlas-core' ),
				'description' => esc_html__( 'If you want to showing divider icon between menu items.', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default'   => 'no',
			]
		);

		$this->add_control(
			'div_icon',
			[
				'label'       => esc_html__( 'Divider icon', 'atlas-core' ),
				'placeholder' => '<svg ...> ... </svg> or Symbol',
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => '',
				'label_block' => true,
				'condition'   => [ 'div_icon_active' => 'yes' ],
			]
		);

		$this->add_responsive_control(
			'div_icon_size',
			[
				'label' => __( 'Divider icon size', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.nav-main > li > .menu-item-space' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [ 'div_icon_active' => 'yes' ],
			]
		);
		$this->add_control(
			'_div_icon_color',
			[
				'label' => esc_html__('Divider icon color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} ul.nav-main > li > .menu-item-space .icon-svg' => 'color: {{VALUE}};',
				],
				'condition'   => [ 'div_icon_active' => 'yes' ],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'menu_typo',
				'label'       => esc_html__( 'Menu typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} ul.nav-main > li > a',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_submenu',
			[
				'label' => __( 'Sub Menu Settings', 'atlas-core' ),
			]
		);

		$this->add_control(
			'submenu_width',
			[
				'label' => esc_html__( 'Submenu width', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} ul.nav-main ul.sub-menu' => 'width: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
					'size' => 150,
				],
			]
		);

		$this->add_control(
			'submenu_radius',
			[
				'label' => esc_html__( 'Submenu radius', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} ul.nav-main ul.sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'submenu_typo',
				'label'       => esc_html__( 'Submenu typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} ul.nav-main ul.sub-menu > li > a',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array(
			'th90-block',
			'block-menus',
			'menuhover-' . $atts['menu_hov'],
		);
		?>
		<div id="th90-block_<?php echo absint( $block_id ); ?>" class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<?php get_template_part( 'template-parts/header/navigation', 'main', $atts ); ?>
		</div>
		<?php


	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
