<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class TH90_E_Logo extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-logo';
	}

	public function get_title() {
		return __( 'Logo', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-logo th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$controls = new TH90_Controls();

		$this->start_controls_section(
			'section_logo',
			[
				'label' => __( 'Logo', 'atlas-core' ),
			]
		);

		$controls->logo_settings( $this );

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		$atts['logo_id']             = ! empty( $atts['logo'] ) ? $atts['logo']['id'] : '';
		$atts['logo_retina_id']      = ! empty( $atts['logo_retina'] ) ? $atts['logo_retina']['id'] : '';
		$atts['logo_dark_id']        = ! empty( $atts['logo_dark'] ) ? $atts['logo_dark']['id'] : '';
		$atts['logo_dark_retina_id'] = ! empty( $atts['logo_dark_retina'] ) ? $atts['logo_dark_retina']['id'] : '';

		if ( ! empty( $atts['custom_link']['url'] ) ) {
			$this->add_link_attributes( 'logo_link', $atts['custom_link'] );
			$atts['link'] = $this->get_render_attribute_string( 'logo_link' );
		}
		if ( 'default' !== $atts['logo_type'] ) {
			th90_logo( $atts );
		} else {
			th90_logo();
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
