<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Heading extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-heading';
	}

	public function get_title() {
		return __( 'Block Heading', 'atlas-core' );
	}

	public function get_keywords() {
		return [ 'title' ];
	}

	public function get_icon() {
		return 'eicon-heading th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	public function controls_heading() {
		/* Section General */
		$this->start_controls_section(
			'section_block_heading',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$controls = new TH90_Controls();
		$controls->heading_settings( $this );
		$this->end_controls_section();
	}

	public function controls_subheading() {

		/* Section General */
		$this->start_controls_section(
			'section_block_subheading',
			[
				'label' => __( 'Sub Heading', 'atlas-core' ),
			]
		);

		$this->add_control(
			'subheading',
			[
				'label' => esc_html__( 'Sub Heading text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => '',
				'label_block' => true,
			]
		);
		$this->add_control(
			'subheading_pos',
			[
				'label'   => esc_html__( 'Sub Heading position', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'top' => esc_html__( 'Top', 'atlas-core' ),
					'bottom'   => esc_html__( 'Bottom', 'atlas-core' ),
				],
			]
		);
		$this->add_control(
			'subheading_color',
			[
				'label' => esc_html__('Sub Heading color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .heading-wrap .subheading' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subheading_typography',
				'label' => esc_html__( 'Sub Heading typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .heading-wrap .subheading',
			]
		);

		$this->add_control(
			'subheading_gap',
			[
				'label' => esc_html__( 'Sub Heading Gap', 'atlas-core' ),
				'type' => Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'vw' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} .heading-wrap .subheading' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_controls() {

		$this->controls_heading();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		$atts['_heading_active'] = 'yes';
		th90_box_heading( $atts );
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
