<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Divider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-divider';
	}

	public function get_title() {
		return __( 'Divider & Space', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-divider th90-widget-icon';
	}

	public function get_keywords() {
		return [ 'line', 'border', 'divider', 'space' ];
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		/* Section General */
		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_control(
			'type',
			[
				'label' => __( 'Type', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'horizontal',
				'options' => [
					'horizontal' => [
						'title' => esc_html__( 'Horizontal', 'elementor' ),
						'icon' => 'eicon-v-align-stretch',
					],
					'vertical' => [
						'title' => esc_html__( 'Vertical', 'elementor' ),
						'icon' => 'eicon-h-align-stretch',
					],
				],
				'prefix_class' => 'div-',
			]
		);
		$this->add_responsive_control(
			'height',
			[
				'label' =>esc_html__( 'Height', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .divider-inner' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					 'type' => 'vertical',
				],
			]
		);

		$this->add_responsive_control(
			'width',
			[
				'label' =>esc_html__( 'Width', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .divider-inner' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					 'type' => 'horizontal',
				],
			]
		);

		$this->add_responsive_control(
			'line_style',
			[
				'label' => __( 'Line style', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'solid' => 'Solid',
					'dashed' => 'Dashed',
					'dotted' => 'Dotted',
					'double' => 'Double',
				],
				'default' => 'solid',
				'selectors' => [
					'{{WRAPPER}} .divider-inner' => 'border-style: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'line_color_light',
			[
				'label' => esc_html__('Line color - Light skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'.site-light {{WRAPPER}} .divider-inner' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'line_color_dark',
			[
				'label' => esc_html__('Line color - Dark skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'.site-dark {{WRAPPER}} .divider-inner' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'hline_size',
			[
				'label' =>esc_html__( 'Line size', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .divider-inner' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					 'type' => 'horizontal',
				],
			]
		);
		$this->add_responsive_control(
			'vline_size',
			[
				'label' =>esc_html__( 'Line size', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .divider-inner' => 'border-left-width: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					 'type' => 'vertical',
				],
			]
		);

		$this->add_responsive_control(
			'hspace',
			[
				'label' => esc_html__( 'Spacing', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} .block-divider' => 'padding: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
				'condition'   => [
					 'type' => 'horizontal',
				],
			]
		);

		$this->add_responsive_control(
			'vspace',
			[
				'label' => esc_html__( 'Spacing', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'allowed_dimensions' => 'horizontal',
				'selectors' => [
					'{{WRAPPER}} .block-divider' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					 'type' => 'vertical',
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		global $block_id;
		$block_id++;
		$atts = $this->get_settings_for_display();

		$wrapper_classes = array(
			'th90-block',
			'block-divider',
		);

		?>
		<div class="<?php echo esc_attr( implode( ' ', array_filter( $wrapper_classes ) ) ); ?>">
			<div class="divider-inner">-</div>
		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
