<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Currentdate extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-currentdate';
	}

	public function get_title() {
		return __( 'Current Date', 'atlas-core' );
	}

	public function get_keywords() {
		return [ 'time' ];
	}

	public function get_icon() {
		return 'eicon-date th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Date style', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__( 'Style 1', 'atlas-core' ),
					'2'   => esc_html__( 'Style 2', 'atlas-core' ),
				],
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '',
				],
			]
		);
		$this->add_control(
			'date_color',
			[
				'label' => esc_html__('Date color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .current-date' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'date_typo',
				'label'       => esc_html__( 'Date typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .current-date',
			]
		);

		
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		$month = wp_date( 'M' );
		$date = wp_date( 'd' );
		$year = wp_date( 'Y' );

		if ( '1' == $atts['style'] ) {
			$currentdate = '<div class="cur-date"><span class="d">' . wp_date( 'd' ) . '</span><span class="my"><span class="m">' . wp_date( 'M' ) . '</span><span class="y">' . wp_date( 'Y' ) . '</span></span></div>';
		} else {
			$currentdate = wp_date( 'F j, Y' );
		}

		if ( ! empty( $atts['link']['url'] ) ) {
			$this->add_link_attributes( 'date', $atts['link'] );
			$this->add_render_attribute( 'date', 'class', 'current-date' );
			?>
			<a <?php $this->print_render_attribute_string( 'date' ); ?>>
				<?php echo $currentdate; ?>
			</a>
			<?php
		} else {
			echo '<div class="current-date">' . $currentdate . '</div>';
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
